/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSMetricUtil {
    private static final Logger logger = LoggerFactory.getLogger(KMSMetricUtil.class);
    private static final String HSM_ENABLED = "ranger.ks.hsm.enabled";
    private static String metricType;

    public static void main(String[] args) {
        logger.info("KMSMetricUtil : main()");
        if (args.length != 2) {
            System.out.println("type: Incorrect Arguments usage : For KMSMetric Usage: metric -type  hsmenabled | encryptedkey | encryptedkeybyalgorithm");
        } else if (!args[0].equalsIgnoreCase("-type") || !args[1].equalsIgnoreCase("hsmenabled") && !args[1].equalsIgnoreCase("encryptedkey") && !args[1].equalsIgnoreCase("encryptedkeybyalgorithm")) {
            System.out.println("type: Incorrect Arguments usage : For KMSMetric Usage: metric -type  hsmenabled | encryptedkey | encryptedkeybyalgorithm");
        } else {
            metricType = args[1];
            if (logger.isDebugEnabled()) {
                logger.debug("KMSMetric Type : " + metricType);
            }
        }
        KMSMetricUtil kmsmetricutil = new KMSMetricUtil();
        kmsmetricutil.getKMSMetricCalculation(metricType);
    }

    private void getKMSMetricCalculation(String caseValue) {
        logger.info("Metric Type : " + caseValue);
        try {
            switch (caseValue.toLowerCase()) {
                case "hsmenabled": {
                    try {
                        KMSConfiguration kmsConfig = new KMSConfiguration();
                        if (kmsConfig != null) {
                            if (kmsConfig.getACLsConf() != null) {
                                String hsmEnabledValue = kmsConfig.getACLsConf().get(HSM_ENABLED);
                                HashMap<String, String> hsmEnabledMap = new HashMap<String, String>();
                                if (hsmEnabledValue != null) {
                                    hsmEnabledMap.put("hsmEnabled", hsmEnabledValue);
                                    Gson gson = new GsonBuilder().create();
                                    String jsonHSMEnabled = gson.toJson(hsmEnabledMap);
                                    System.out.println(jsonHSMEnabled);
                                    break;
                                }
                                hsmEnabledMap.put("hsmEnabled", "");
                                Gson gson = new GsonBuilder().create();
                                String jsonHSMEnabled = gson.toJson(hsmEnabledMap);
                                System.out.println(jsonHSMEnabled);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error calculating KMSMetric for HSM enabled : " + e.getMessage());
                    }
                    break;
                }
                case "encryptedkey": {
                    try {
                        KMSWebApp kmsWebAppEncryptedKey = new KMSWebApp();
                        if (kmsWebAppEncryptedKey != null) {
                            kmsWebAppEncryptedKey.contextInitialized(null);
                            KeyProviderCryptoExtension keyProvider = kmsWebAppEncryptedKey.getKeyProvider();
                            if (keyProvider != null && keyProvider.getKeys() != null) {
                                Integer encryptedKeyCount = keyProvider.getKeys().size();
                                HashMap<String, Integer> encryptedKeyCountValueMap = new HashMap<String, Integer>();
                                encryptedKeyCountValueMap.put("encryptedKeyCount", encryptedKeyCount);
                                Gson gson = new GsonBuilder().create();
                                String jsonEncKeycount = gson.toJson(encryptedKeyCountValueMap);
                                System.out.println(jsonEncKeycount);
                            } else {
                                HashMap<String, String> encryptedKeyCountValueMap = new HashMap<String, String>();
                                encryptedKeyCountValueMap.put("encryptedKeyCount", "");
                                Gson gson = new GsonBuilder().create();
                                String jsonEncKeycount = gson.toJson(encryptedKeyCountValueMap);
                                System.out.println(jsonEncKeycount);
                            }
                            kmsWebAppEncryptedKey.contextDestroyed(null);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error calculating KMSMetric for encrypted key count: " + e.getMessage());
                    }
                    break;
                }
                case "encryptedkeybyalgorithm": {
                    try {
                        KMSWebApp kmsWebApp = new KMSWebApp();
                        if (kmsWebApp != null) {
                            kmsWebApp.contextInitialized(null);
                            KeyProviderCryptoExtension keyProvider = kmsWebApp.getKeyProvider();
                            HashMap<String, Integer> encryptedKeyByAlgorithmCountMap = new HashMap<String, Integer>();
                            int count = 0;
                            if (keyProvider != null && keyProvider.getKeys() != null && keyProvider.getKeys().size() > 0) {
                                ArrayList keyList = new ArrayList();
                                keyList.addAll(keyProvider.getKeys());
                                if (keyList != null) {
                                    for (String key : keyList) {
                                        String algorithmName = keyProvider.getMetadata(key).getCipher();
                                        if (encryptedKeyByAlgorithmCountMap.containsKey(algorithmName)) {
                                            count = (Integer)encryptedKeyByAlgorithmCountMap.get(algorithmName);
                                            encryptedKeyByAlgorithmCountMap.put(algorithmName, ++count);
                                            continue;
                                        }
                                        encryptedKeyByAlgorithmCountMap.put(algorithmName, 1);
                                    }
                                    Gson gson = new GsonBuilder().create();
                                    String jsonEncKeyByAlgo = gson.toJson(encryptedKeyByAlgorithmCountMap);
                                    System.out.println(jsonEncKeyByAlgo);
                                }
                            } else {
                                encryptedKeyByAlgorithmCountMap.put("encryptedKeyByAlgorithm", count);
                                Gson gson = new GsonBuilder().create();
                                String jsonEncKeyByAlgo = gson.toJson(encryptedKeyByAlgorithmCountMap);
                                System.out.println(jsonEncKeyByAlgo);
                            }
                            kmsWebApp.contextDestroyed(null);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error calculating KMSMetric for encrypted key by algorithm : " + e.getMessage());
                    }
                    break;
                }
                default: {
                    System.out.println("type: Incorrect Arguments usage : For KMSMetric Usage: metric -type  hsmenabled | encryptedkey | encryptedkeybyalgorithm");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error calculating KMSMetric : " + e.getMessage());
        }
    }
}

