/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerRole
extends RangerBaseModelObject
implements Serializable {
    public static final String KEY_USER = "user";
    public static final String KEY_GROUP = "group";
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Map<String, Object> options;
    private List<RoleMember> users;
    private List<RoleMember> groups;
    private List<RoleMember> roles;
    private String createdByUser;

    public RangerRole() {
        this(null, null, null, null, null, null);
    }

    public RangerRole(String name, String description, Map<String, Object> options, List<RoleMember> users, List<RoleMember> groups) {
        this(name, description, options, users, groups, null);
    }

    public RangerRole(String name, String description, Map<String, Object> options, List<RoleMember> users, List<RoleMember> groups, List<RoleMember> roles) {
        this.setName(name);
        this.setDescription(description);
        this.setOptions(options);
        this.setUsers(users);
        this.setGroups(groups);
        this.setRoles(roles);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options == null ? new HashMap() : options;
    }

    public List<RoleMember> getUsers() {
        return this.users;
    }

    public void setUsers(List<RoleMember> users) {
        this.users = users == null ? new ArrayList() : users;
    }

    public List<RoleMember> getGroups() {
        return this.groups;
    }

    public void setGroups(List<RoleMember> groups) {
        this.groups = groups == null ? new ArrayList() : groups;
    }

    public List<RoleMember> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleMember> roles) {
        this.roles = roles == null ? new ArrayList() : roles;
    }

    public String getCreatedByUser() {
        return this.createdByUser;
    }

    public void setCreatedByUser(String createdByUser) {
        this.createdByUser = createdByUser;
    }

    @Override
    public String toString() {
        return "{name=" + this.name + ", description=" + this.description + ", options=" + this.getPrintableOptions(this.options) + ", users=" + this.users + ", groups=" + this.groups + ", roles=" + this.roles + ", createdByUser=" + this.createdByUser + "}";
    }

    private String getPrintableOptions(Map<String, Object> options) {
        if (MapUtils.isEmpty(options)) {
            return "{}";
        }
        StringBuilder ret = new StringBuilder();
        ret.append("{");
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            ret.append(entry.getKey()).append(", ").append("[").append(entry.getValue()).append("]").append(",");
        }
        ret.append("}");
        return ret.toString();
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RoleMember
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private boolean isAdmin;

        public RoleMember() {
            this(null, false);
        }

        public RoleMember(String name, boolean isAdmin) {
            this.setName(name);
            this.setIsAdmin(isAdmin);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIsAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
        }

        public String getName() {
            return this.name;
        }

        public boolean getIsAdmin() {
            return this.isAdmin;
        }

        public String toString() {
            return "{" + this.name + ", " + this.isAdmin + "}";
        }

        public int hashCode() {
            return Objects.hash(this.name, this.isAdmin);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RoleMember other = (RoleMember)obj;
            return Objects.equals(this.name, other.name) && this.isAdmin == other.isAdmin;
        }
    }
}

