/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.yarn.client.json.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ranger.services.yarn.client.json.model.SchedulerResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FairSchedulerResponse
implements Serializable,
SchedulerResponse {
    private static final long serialVersionUID = 1L;
    private YarnScheduler scheduler = null;

    public YarnScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public List<String> getQueueNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.scheduler != null) {
            this.scheduler.collectQueueNames(ret);
        }
        return ret;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnChildQueues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<YarnRootQueue> queue = null;

        public List<YarnRootQueue> getQueue() {
            return this.queue;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.queue != null) {
                for (YarnRootQueue schedulerInfo : this.queue) {
                    schedulerInfo.collectQueueNames(queueNames, false);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnRootQueue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String queueName = null;
        private YarnChildQueues childQueues = null;

        public String getQueueName() {
            return this.queueName;
        }

        public YarnChildQueues getChildQueues() {
            return this.childQueues;
        }

        public void collectQueueNames(List<String> queueNames, boolean isRoot) {
            if (this.queueName != null) {
                if (!isRoot) {
                    queueNames.add(this.queueName);
                }
                if (this.childQueues != null) {
                    this.childQueues.collectQueueNames(queueNames);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnSchedulerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private YarnRootQueue rootQueue = null;

        public YarnRootQueue getRootQueue() {
            return this.rootQueue;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.rootQueue != null) {
                this.rootQueue.collectQueueNames(queueNames, true);
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnScheduler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private YarnSchedulerInfo schedulerInfo = null;

        public YarnSchedulerInfo getSchedulerInfo() {
            return this.schedulerInfo;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.schedulerInfo != null) {
                this.schedulerInfo.collectQueueNames(queueNames);
            }
        }
    }
}

