/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class LeafRuntimeField
implements RuntimeField {
    private final String name;
    private final MappedFieldType mappedFieldType;
    private final List<FieldMapper.Parameter<?>> parameters;

    public LeafRuntimeField(String name, MappedFieldType mappedFieldType, List<FieldMapper.Parameter<?>> parameters) {
        this.name = name;
        this.mappedFieldType = mappedFieldType;
        this.parameters = parameters;
        assert (mappedFieldType.name().endsWith(name)) : "full name: " + mappedFieldType.name() + " - leaf name: " + name;
    }

    @Override
    public String name() {
        return this.mappedFieldType.name();
    }

    @Override
    public Stream<MappedFieldType> asMappedFieldTypes() {
        return Stream.of(this.mappedFieldType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", this.mappedFieldType.typeName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        for (FieldMapper.Parameter<?> parameter : this.parameters) {
            parameter.toXContent(builder, includeDefaults);
        }
        builder.endObject();
        return builder;
    }
}

