/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SourceLookup;

public final class DocValueFetcher
implements ValueFetcher {
    private final DocValueFormat format;
    private final IndexFieldData<?> ifd;
    private FormattedDocValues formattedDocValues;

    public DocValueFetcher(DocValueFormat format, IndexFieldData<?> ifd) {
        this.format = format;
        this.ifd = ifd;
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.formattedDocValues = this.ifd.load(context).getFormattedValues(this.format);
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup, List<Object> ignoredValues) throws IOException {
        if (!this.formattedDocValues.advanceExact(lookup.docId())) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.formattedDocValues.docValueCount());
        int count = this.formattedDocValues.docValueCount();
        for (int i = 0; i < count; ++i) {
            result.add(this.formattedDocValues.nextValue());
        }
        return result;
    }
}

