/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DataDiskImage;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.OSDiskImage;
import com.microsoft.azure.management.compute.PurchasePlan;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@LangDefinition
class VirtualMachineImageImpl
extends IndexableWrapperImpl<VirtualMachineImageInner>
implements VirtualMachineImage {
    private final Region location;
    private ImageReference imageReference;

    VirtualMachineImageImpl(Region location, String publisher, String offer, String sku, String version) {
        super(null);
        this.location = location;
        this.imageReference = new ImageReference();
        this.imageReference.withPublisher(publisher);
        this.imageReference.withOffer(offer);
        this.imageReference.withSku(sku);
        this.imageReference.withVersion(version);
    }

    VirtualMachineImageImpl(Region location, String publisher, String offer, String sku, String version, VirtualMachineImageInner innerModel) {
        super((Object)innerModel);
        this.location = location;
        this.imageReference = new ImageReference();
        this.imageReference.withPublisher(publisher);
        this.imageReference.withOffer(offer);
        this.imageReference.withSku(sku);
        this.imageReference.withVersion(version);
    }

    @Override
    public String id() {
        if (this.inner() == null) {
            return null;
        }
        return ((VirtualMachineImageInner)((Object)this.inner())).id();
    }

    @Override
    public Region location() {
        return this.location;
    }

    @Override
    public String publisherName() {
        return this.imageReference.publisher();
    }

    @Override
    public String offer() {
        return this.imageReference.offer();
    }

    @Override
    public String sku() {
        return this.imageReference.sku();
    }

    @Override
    public String version() {
        return this.imageReference.version();
    }

    @Override
    public ImageReference imageReference() {
        return this.imageReference;
    }

    @Override
    public PurchasePlan plan() {
        return ((VirtualMachineImageInner)((Object)this.inner())).plan();
    }

    @Override
    public OSDiskImage osDiskImage() {
        return ((VirtualMachineImageInner)((Object)this.inner())).osDiskImage();
    }

    @Override
    public Map<Integer, DataDiskImage> dataDiskImages() {
        if (((VirtualMachineImageInner)((Object)this.inner())).dataDiskImages() == null) {
            return Collections.unmodifiableMap(new HashMap());
        }
        HashMap<Integer, DataDiskImage> diskImages = new HashMap<Integer, DataDiskImage>();
        for (DataDiskImage diskImage : ((VirtualMachineImageInner)((Object)this.inner())).dataDiskImages()) {
            diskImages.put(diskImage.lun(), diskImage);
        }
        return Collections.unmodifiableMap(diskImages);
    }
}

