/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class TermVectorsResponse {
    private final String index;
    private final String type;
    private final String id;
    private final long docVersion;
    private final boolean found;
    private final long tookInMillis;
    private final List<TermVector> termVectorList;
    private static final ConstructingObjectParser<TermVectorsResponse, Void> PARSER = new ConstructingObjectParser("term_vectors", true, args -> {
        List termVectorList = (List)args[6];
        if (termVectorList != null) {
            Collections.sort(termVectorList, Comparator.comparing(TermVector::getFieldName));
        }
        return new TermVectorsResponse((String)args[0], (String)args[1], (String)args[2], (Long)args[3], (Boolean)args[4], (Long)args[5], termVectorList);
    });

    public TermVectorsResponse(String index, String type, String id, long version, boolean found, long tookInMillis, List<TermVector> termVectorList) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.docVersion = version;
        this.found = found;
        this.tookInMillis = tookInMillis;
        this.termVectorList = termVectorList;
    }

    public static TermVectorsResponse fromXContent(XContentParser parser) {
        return (TermVectorsResponse)PARSER.apply(parser, null);
    }

    public String getIndex() {
        return this.index;
    }

    @Deprecated
    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean getFound() {
        return this.found;
    }

    public long getDocVersion() {
        return this.docVersion;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public List<TermVector> getTermVectorsList() {
        return this.termVectorList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TermVectorsResponse)) {
            return false;
        }
        TermVectorsResponse other = (TermVectorsResponse)obj;
        return this.index.equals(other.index) && this.type.equals(other.type) && Objects.equals(this.id, other.id) && this.docVersion == other.docVersion && this.found == other.found && this.tookInMillis == other.tookInMillis && Objects.equals(this.termVectorList, other.termVectorList);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.type, this.id, this.docVersion, this.found, this.tookInMillis, this.termVectorList);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("_index", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("_type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("_id", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("_version", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("found", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("took", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, fieldName) -> TermVector.fromXContent(p, fieldName), new ParseField("term_vectors", new String[0]));
    }

    public static final class TermVector {
        private static final ConstructingObjectParser<TermVector, String> PARSER = new ConstructingObjectParser("term_vector", true, (args, ctxFieldName) -> {
            List terms = (List)args[1];
            if (terms != null) {
                Collections.sort(terms, Comparator.comparing(Term::getTerm));
            }
            return new TermVector((String)ctxFieldName, (FieldStatistics)args[0], terms);
        });
        private final String fieldName;
        @Nullable
        private final FieldStatistics fieldStatistics;
        @Nullable
        private final List<Term> terms;

        public TermVector(String fieldName, FieldStatistics fieldStatistics, List<Term> terms) {
            this.fieldName = fieldName;
            this.fieldStatistics = fieldStatistics;
            this.terms = terms;
        }

        public static TermVector fromXContent(XContentParser parser, String fieldName) {
            return (TermVector)PARSER.apply(parser, (Object)fieldName);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public List<Term> getTerms() {
            return this.terms;
        }

        public FieldStatistics getFieldStatistics() {
            return this.fieldStatistics;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TermVector)) {
                return false;
            }
            TermVector other = (TermVector)obj;
            return this.fieldName.equals(other.fieldName) && Objects.equals(this.fieldStatistics, other.fieldStatistics) && Objects.equals(this.terms, other.terms);
        }

        public int hashCode() {
            return Objects.hash(this.fieldName, this.fieldStatistics, this.terms);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FieldStatistics.fromXContent(p), new ParseField("field_statistics", new String[0]));
            PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, term) -> Term.fromXContent(p, term), new ParseField("terms", new String[0]));
        }

        public static final class FieldStatistics {
            private static final ConstructingObjectParser<FieldStatistics, Void> PARSER = new ConstructingObjectParser("field_statistics", true, args -> new FieldStatistics((Long)args[0], (Integer)args[1], (Long)args[2]));
            private final long sumDocFreq;
            private final int docCount;
            private final long sumTotalTermFreq;

            public FieldStatistics(long sumDocFreq, int docCount, long sumTotalTermFreq) {
                this.sumDocFreq = sumDocFreq;
                this.docCount = docCount;
                this.sumTotalTermFreq = sumTotalTermFreq;
            }

            public static FieldStatistics fromXContent(XContentParser parser) {
                return (FieldStatistics)PARSER.apply(parser, null);
            }

            public int getDocCount() {
                return this.docCount;
            }

            public long getSumDocFreq() {
                return this.sumDocFreq;
            }

            public long getSumTotalTermFreq() {
                return this.sumTotalTermFreq;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof FieldStatistics)) {
                    return false;
                }
                FieldStatistics other = (FieldStatistics)obj;
                return this.docCount == other.docCount && this.sumDocFreq == other.sumDocFreq && this.sumTotalTermFreq == other.sumTotalTermFreq;
            }

            public int hashCode() {
                return Objects.hash(this.docCount, this.sumDocFreq, this.sumTotalTermFreq);
            }

            static {
                PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("sum_doc_freq", new String[0]));
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("doc_count", new String[0]));
                PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("sum_ttf", new String[0]));
            }
        }

        public static final class Term {
            private static final ConstructingObjectParser<Term, String> PARSER = new ConstructingObjectParser("token", true, (args, ctxTerm) -> {
                List tokens = (List)args[4];
                if (tokens != null) {
                    Collections.sort(tokens, Comparator.comparing(Token::getPosition, Comparator.nullsFirst(Integer::compareTo)).thenComparing(Token::getStartOffset, Comparator.nullsFirst(Integer::compareTo)).thenComparing(Token::getEndOffset, Comparator.nullsFirst(Integer::compareTo)));
                }
                return new Term((String)ctxTerm, (Integer)args[0], (Integer)args[1], (Long)args[2], (Float)args[3], tokens);
            });
            private final String term;
            private final int termFreq;
            @Nullable
            private final Integer docFreq;
            @Nullable
            private final Long totalTermFreq;
            @Nullable
            private final Float score;
            @Nullable
            private final List<Token> tokens;

            public Term(String term, int termFreq, Integer docFreq, Long totalTermFreq, Float score, List<Token> tokens) {
                this.term = term;
                this.termFreq = termFreq;
                this.docFreq = docFreq;
                this.totalTermFreq = totalTermFreq;
                this.score = score;
                this.tokens = tokens;
            }

            public static Term fromXContent(XContentParser parser, String term) {
                return (Term)PARSER.apply(parser, (Object)term);
            }

            public String getTerm() {
                return this.term;
            }

            public int getTermFreq() {
                return this.termFreq;
            }

            public Integer getDocFreq() {
                return this.docFreq;
            }

            public Long getTotalTermFreq() {
                return this.totalTermFreq;
            }

            public Float getScore() {
                return this.score;
            }

            public List<Token> getTokens() {
                return this.tokens;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof Term)) {
                    return false;
                }
                Term other = (Term)obj;
                return this.term.equals(other.term) && this.termFreq == other.termFreq && Objects.equals(this.docFreq, other.docFreq) && Objects.equals(this.totalTermFreq, other.totalTermFreq) && Objects.equals(this.score, other.score) && Objects.equals(this.tokens, other.tokens);
            }

            public int hashCode() {
                return Objects.hash(this.term, this.termFreq, this.docFreq, this.totalTermFreq, this.score, this.tokens);
            }

            static {
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("term_freq", new String[0]));
                PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("doc_freq", new String[0]));
                PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ttf", new String[0]));
                PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), new ParseField("score", new String[0]));
                PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Token.fromXContent(p), new ParseField("tokens", new String[0]));
            }
        }

        public static final class Token {
            private static final ConstructingObjectParser<Token, Void> PARSER = new ConstructingObjectParser("token", true, args -> new Token((Integer)args[0], (Integer)args[1], (Integer)args[2], (String)args[3]));
            @Nullable
            private final Integer startOffset;
            @Nullable
            private final Integer endOffset;
            @Nullable
            private final Integer position;
            @Nullable
            private final String payload;

            public Token(Integer startOffset, Integer endOffset, Integer position, String payload) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
                this.position = position;
                this.payload = payload;
            }

            public static Token fromXContent(XContentParser parser) {
                return (Token)PARSER.apply(parser, null);
            }

            public Integer getStartOffset() {
                return this.startOffset;
            }

            public Integer getEndOffset() {
                return this.endOffset;
            }

            public Integer getPosition() {
                return this.position;
            }

            public String getPayload() {
                return this.payload;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof Token)) {
                    return false;
                }
                Token other = (Token)obj;
                return Objects.equals(this.startOffset, other.startOffset) && Objects.equals(this.endOffset, other.endOffset) && Objects.equals(this.position, other.position) && Objects.equals(this.payload, other.payload);
            }

            public int hashCode() {
                return Objects.hash(this.startOffset, this.endOffset, this.position, this.payload);
            }

            static {
                PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("start_offset", new String[0]));
                PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("end_offset", new String[0]));
                PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("position", new String[0]));
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("payload", new String[0]));
            }
        }
    }
}

