/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.Timestamps;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;

public final class SqlTimestamp {
    public static final String JSON_FORMAT = "uuuu-MM-dd HH:mm:ss[.SSS]";
    public static final DateTimeFormatter JSON_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss[.SSS]");
    private final int precision;
    private final long epochMicros;
    private final int picosOfMicros;
    private final Optional<TimeZoneKey> sessionTimeZoneKey;

    public static SqlTimestamp fromMillis(int precision, long millis) {
        return SqlTimestamp.newInstance(precision, millis * 1000L, 0);
    }

    @Deprecated
    public static SqlTimestamp legacyFromMillis(int precision, long millisUtc, TimeZoneKey sessionTimeZoneKey) {
        return SqlTimestamp.newLegacyInstance(precision, millisUtc * 1000L, 0, sessionTimeZoneKey);
    }

    public static SqlTimestamp newInstance(int precision, long epochMicros, int picosOfMicro) {
        return SqlTimestamp.newInstanceWithRounding(precision, epochMicros, picosOfMicro, Optional.empty());
    }

    @Deprecated
    public static SqlTimestamp newLegacyInstance(int precision, long epochMicros, int picosOfMicro, TimeZoneKey sessionTimeZoneKey) {
        return SqlTimestamp.newInstanceWithRounding(precision, epochMicros, picosOfMicro, Optional.of(sessionTimeZoneKey));
    }

    private static SqlTimestamp newInstanceWithRounding(int precision, long epochMicros, int picosOfMicro, Optional<TimeZoneKey> sessionTimeZoneKey) {
        if (precision < 6) {
            epochMicros = Timestamps.round(epochMicros, 6 - precision);
            picosOfMicro = 0;
        } else if (precision == 6) {
            if (Timestamps.round(picosOfMicro, 6) == 1000000L) {
                ++epochMicros;
            }
            picosOfMicro = 0;
        } else {
            picosOfMicro = (int)Timestamps.round(picosOfMicro, 12 - precision);
        }
        return new SqlTimestamp(precision, epochMicros, picosOfMicro, sessionTimeZoneKey);
    }

    private SqlTimestamp(int precision, long epochMicros, int picosOfMicro, Optional<TimeZoneKey> sessionTimeZoneKey) {
        this.precision = precision;
        this.epochMicros = epochMicros;
        this.picosOfMicros = picosOfMicro;
        this.sessionTimeZoneKey = sessionTimeZoneKey;
    }

    public int getPrecision() {
        return this.precision;
    }

    public long getMillis() {
        SqlTimestamp.checkState(!this.isLegacyTimestamp(), "getMillis() can be called in new timestamp semantics only");
        return Timestamps.roundDiv(this.epochMicros, 1000L);
    }

    @Deprecated
    public long getMillisUtc() {
        SqlTimestamp.checkState(this.isLegacyTimestamp(), "getMillisUtc() can be called in legacy timestamp semantics only");
        return Timestamps.roundDiv(this.epochMicros, 1000L);
    }

    public long getEpochMicros() {
        return this.epochMicros;
    }

    public long getPicosOfMicros() {
        return this.picosOfMicros;
    }

    @Deprecated
    public Optional<TimeZoneKey> getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    public boolean isLegacyTimestamp() {
        return this.sessionTimeZoneKey.isPresent();
    }

    public SqlTimestamp roundTo(int precision) {
        return SqlTimestamp.newInstanceWithRounding(precision, this.epochMicros, this.picosOfMicros, this.sessionTimeZoneKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimestamp that = (SqlTimestamp)o;
        return this.epochMicros == that.epochMicros && this.picosOfMicros == that.picosOfMicros && this.precision == that.precision && this.sessionTimeZoneKey.equals(that.sessionTimeZoneKey);
    }

    public int hashCode() {
        return Objects.hash(this.epochMicros, this.picosOfMicros, this.precision, this.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        ZoneId zoneId = this.sessionTimeZoneKey.map(TimeZoneKey::getId).map(ZoneId::of).orElse(ZoneOffset.UTC);
        return Timestamps.formatTimestamp(this.precision, this.epochMicros, this.picosOfMicros, zoneId);
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

