/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.security;

import io.prestosql.spi.security.SelectedRole;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorIdentity {
    private final String user;
    private final Set<String> groups;
    private final Optional<Principal> principal;
    private final Optional<SelectedRole> role;
    private final Map<String, String> extraCredentials;

    @Deprecated
    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> role) {
        this(user, principal, role, Collections.emptyMap());
    }

    @Deprecated
    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> role, Map<String, String> extraCredentials) {
        this(user, Collections.emptySet(), principal, role, extraCredentials);
    }

    private ConnectorIdentity(String user, Set<String> groups, Optional<Principal> principal, Optional<SelectedRole> role, Map<String, String> extraCredentials) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.groups = Set.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.role = Objects.requireNonNull(role, "role is null");
        this.extraCredentials = Map.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Optional<SelectedRole> getRole() {
        return this.role;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorIdentity{");
        sb.append("user='").append(this.user).append('\'');
        sb.append(", groups=").append(this.groups);
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        this.role.ifPresent(role -> sb.append(", role=").append(role));
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append('}');
        return sb.toString();
    }

    public static ConnectorIdentity ofUser(String user) {
        return new Builder(user).build();
    }

    public static Builder forUser(String user) {
        return new Builder(user);
    }

    public static class Builder {
        private final String user;
        private Set<String> groups = Collections.emptySet();
        private Optional<Principal> principal = Optional.empty();
        private Optional<SelectedRole> role = Optional.empty();
        private Map<String, String> extraCredentials = new HashMap<String, String>();

        private Builder(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
        }

        public Builder withGroups(Set<String> groups) {
            this.groups = Set.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
            return this;
        }

        public Builder withPrincipal(Principal principal) {
            return this.withPrincipal(Optional.of(Objects.requireNonNull(principal, "principal is null")));
        }

        public Builder withPrincipal(Optional<Principal> principal) {
            this.principal = Objects.requireNonNull(principal, "principal is null");
            return this;
        }

        public Builder withRole(SelectedRole role) {
            return this.withRole(Optional.of(Objects.requireNonNull(role, "role is null")));
        }

        public Builder withRole(Optional<SelectedRole> role) {
            this.role = Objects.requireNonNull(role, "role is null");
            return this;
        }

        public Builder withExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials = new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
            return this;
        }

        public ConnectorIdentity build() {
            return new ConnectorIdentity(this.user, this.groups, this.principal, this.role, this.extraCredentials);
        }
    }
}

