/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;

public class ExchangeId {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private final String id;

    public static ExchangeId createRandomExchangeId() {
        return new ExchangeId(UUID.randomUUID().toString());
    }

    @JsonCreator
    public ExchangeId(String id) {
        Objects.requireNonNull(id, "id is null");
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
        this.id = id;
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeId that = (ExchangeId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

