/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.$internal.client.auth.external.ExternalRedirectStrategy;
import io.trino.jdbc.$internal.client.auth.external.RedirectException;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class CompositeRedirectHandler
implements RedirectHandler {
    private final List<RedirectHandler> handlers;

    public CompositeRedirectHandler(List<ExternalRedirectStrategy> strategies) {
        this.handlers = Objects.requireNonNull(strategies, "strategies is null").stream().map(ExternalRedirectStrategy::getHandler).collect(ImmutableList.toImmutableList());
        Preconditions.checkState(!this.handlers.isEmpty(), "Expected at least one external redirect handler");
    }

    @Override
    public void redirectTo(URI uri) throws RedirectException {
        RedirectException redirectException = new RedirectException(String.format("Could not redirect to " + uri, new Object[0]));
        for (RedirectHandler handler : this.handlers) {
            try {
                handler.redirectTo(uri);
                return;
            }
            catch (RedirectException e) {
                redirectException.addSuppressed(e);
            }
        }
        throw redirectException;
    }
}

