/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.util.ArrayList;
import java.util.List;

public final class ScmInfo {
    private String clusterId;
    private String scmId;
    private List<String> peerRoles;

    private ScmInfo(String clusterId, String scmId, List<String> peerRoles) {
        this.clusterId = clusterId;
        this.scmId = scmId;
        this.peerRoles = peerRoles;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getScmId() {
        return this.scmId;
    }

    public List<String> getRatisPeerRoles() {
        return this.peerRoles;
    }

    public static class Builder {
        private String clusterId;
        private String scmId;
        private List<String> peerRoles = new ArrayList<String>();

        public Builder setClusterId(String cid) {
            this.clusterId = cid;
            return this;
        }

        public Builder setScmId(String id) {
            this.scmId = id;
            return this;
        }

        public Builder setRatisPeerRoles(List<String> roles) {
            this.peerRoles.addAll(roles);
            return this;
        }

        public ScmInfo build() {
            return new ScmInfo(this.clusterId, this.scmId, this.peerRoles);
        }
    }
}

