/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlanStatus;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateTask;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataTable;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.PreInsertTableDesc;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.plan.AbortTxnsDesc;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterMaterializedViewDesc;
import org.apache.hadoop.hive.ql.plan.AlterResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableAlterPartDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableExchangePartition;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.AlterWMTriggerDesc;
import org.apache.hadoop.hive.ql.plan.CacheMetadataDesc;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateOrAlterWMMappingDesc;
import org.apache.hadoop.hive.ql.plan.CreateOrAlterWMPoolDesc;
import org.apache.hadoop.hive.ql.plan.CreateOrDropTriggerToPoolMappingDesc;
import org.apache.hadoop.hive.ql.plan.CreateResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.CreateWMTriggerDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.DropWMMappingDesc;
import org.apache.hadoop.hive.ql.plan.DropWMPoolDesc;
import org.apache.hadoop.hive.ql.plan.DropWMTriggerDesc;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.InsertCommitHookDesc;
import org.apache.hadoop.hive.ql.plan.KillQueryDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowConfDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowResourcePlanDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTxnsDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveV1Authorizer;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.common.util.AnnotationUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.apache.hive.common.util.RetryUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.exec.DDLTask");
    private static final int separator = 9;
    private static final int terminator = 10;
    private static String INTERMEDIATE_ARCHIVED_DIR_SUFFIX;
    private static String INTERMEDIATE_ORIGINAL_DIR_SUFFIX;
    private static String INTERMEDIATE_EXTRACTED_DIR_SUFFIX;
    private MetaDataFormatter formatter;
    private final HiveAuthorizationTranslator defaultAuthorizationTranslator = new DefaultHiveAuthorizationTranslator();
    private Task<? extends Serializable> subtask = null;
    public static final String DATABASE_PATH_SUFFIX = ".db";

    public Task<? extends Serializable> getSubtask() {
        return this.subtask;
    }

    @Override
    public boolean requireLock() {
        return this.work != null && ((DDLWork)this.work).getNeedLock();
    }

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext ctx, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, ctx, opContext);
        this.formatter = MetaDataFormatUtils.getFormatter(this.conf);
        INTERMEDIATE_ARCHIVED_DIR_SUFFIX = HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        INTERMEDIATE_ORIGINAL_DIR_SUFFIX = HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        INTERMEDIATE_EXTRACTED_DIR_SUFFIX = HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
    }

    @Override
    public int execute(DriverContext driverContext) {
        if (driverContext.getCtx().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return 0;
        }
        try {
            MsckDesc msckDesc;
            Hive db = Hive.get(this.conf);
            CreateDatabaseDesc createDatabaseDesc = ((DDLWork)this.work).getCreateDatabaseDesc();
            if (null != createDatabaseDesc) {
                return this.createDatabase(db, createDatabaseDesc);
            }
            DropDatabaseDesc dropDatabaseDesc = ((DDLWork)this.work).getDropDatabaseDesc();
            if (dropDatabaseDesc != null) {
                return this.dropDatabase(db, dropDatabaseDesc);
            }
            LockDatabaseDesc lockDatabaseDesc = ((DDLWork)this.work).getLockDatabaseDesc();
            if (lockDatabaseDesc != null) {
                return this.lockDatabase(db, lockDatabaseDesc);
            }
            UnlockDatabaseDesc unlockDatabaseDesc = ((DDLWork)this.work).getUnlockDatabaseDesc();
            if (unlockDatabaseDesc != null) {
                return this.unlockDatabase(db, unlockDatabaseDesc);
            }
            SwitchDatabaseDesc switchDatabaseDesc = ((DDLWork)this.work).getSwitchDatabaseDesc();
            if (switchDatabaseDesc != null) {
                return this.switchDatabase(db, switchDatabaseDesc);
            }
            DescDatabaseDesc descDatabaseDesc = ((DDLWork)this.work).getDescDatabaseDesc();
            if (descDatabaseDesc != null) {
                return this.descDatabase(db, descDatabaseDesc);
            }
            AlterDatabaseDesc alterDatabaseDesc = ((DDLWork)this.work).getAlterDatabaseDesc();
            if (alterDatabaseDesc != null) {
                return this.alterDatabase(db, alterDatabaseDesc);
            }
            CreateTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            CreateTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            DropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                this.dropTableOrPartitions(db, dropTbl);
                return 0;
            }
            AlterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                if (!this.allowOperationInReplicationScope(db, alterTbl.getOldName(), null, alterTbl.getReplicationSpec())) {
                    LOG.debug("DDLTask: Alter Table is skipped as table {} is newer than update", (Object)alterTbl.getOldName());
                    return 0;
                }
                if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.DROPCONSTRAINT) {
                    return this.dropConstraint(db, alterTbl);
                }
                if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCONSTRAINT) {
                    return this.addConstraints(db, alterTbl);
                }
                return this.alterTable(db, alterTbl);
            }
            CreateViewDesc crtView = ((DDLWork)this.work).getCreateViewDesc();
            if (crtView != null) {
                return this.createView(db, crtView);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartitions(db, addPartitionDesc);
            }
            RenamePartitionDesc renamePartitionDesc = ((DDLWork)this.work).getRenamePartitionDesc();
            if (renamePartitionDesc != null) {
                return this.renamePartition(db, renamePartitionDesc);
            }
            AlterTableSimpleDesc simpleDesc = ((DDLWork)this.work).getAlterTblSimpleDesc();
            if (simpleDesc != null) {
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.TOUCH) {
                    return this.touch(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.ARCHIVE) {
                    return this.archive(db, simpleDesc, driverContext);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.UNARCHIVE) {
                    return this.unarchive(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.COMPACT) {
                    return this.compact(db, simpleDesc);
                }
            }
            if ((msckDesc = ((DDLWork)this.work).getMsckDesc()) != null) {
                return this.msck(db, msckDesc);
            }
            DescTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            DescFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(db, descFunc);
            }
            ShowDatabasesDesc showDatabases = ((DDLWork)this.work).getShowDatabasesDesc();
            if (showDatabases != null) {
                return this.showDatabases(db, showDatabases);
            }
            ShowTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTablesOrViews(db, showTbls);
            }
            ShowColumnsDesc showCols = ((DDLWork)this.work).getShowColumnsDesc();
            if (showCols != null) {
                return this.showColumns(db, showCols);
            }
            ShowTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            ShowTblPropertiesDesc showTblProperties = ((DDLWork)this.work).getShowTblPropertiesDesc();
            if (showTblProperties != null) {
                return this.showTableProperties(db, showTblProperties);
            }
            ShowFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(db, showFuncs);
            }
            ShowLocksDesc showLocks = ((DDLWork)this.work).getShowLocksDesc();
            if (showLocks != null) {
                return this.showLocks(db, showLocks);
            }
            ShowCompactionsDesc compactionsDesc = ((DDLWork)this.work).getShowCompactionsDesc();
            if (compactionsDesc != null) {
                return this.showCompactions(db, compactionsDesc);
            }
            ShowTxnsDesc txnsDesc = ((DDLWork)this.work).getShowTxnsDesc();
            if (txnsDesc != null) {
                return this.showTxns(db, txnsDesc);
            }
            AbortTxnsDesc abortTxnsDesc = ((DDLWork)this.work).getAbortTxnsDesc();
            if (abortTxnsDesc != null) {
                return this.abortTxns(db, abortTxnsDesc);
            }
            LockTableDesc lockTbl = ((DDLWork)this.work).getLockTblDesc();
            if (lockTbl != null) {
                return this.lockTable(db, lockTbl);
            }
            UnlockTableDesc unlockTbl = ((DDLWork)this.work).getUnlockTblDesc();
            if (unlockTbl != null) {
                return this.unlockTable(db, unlockTbl);
            }
            ShowPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
            ShowCreateDatabaseDesc showCreateDb = ((DDLWork)this.work).getShowCreateDbDesc();
            if (showCreateDb != null) {
                return this.showCreateDatabase(db, showCreateDb);
            }
            ShowCreateTableDesc showCreateTbl = ((DDLWork)this.work).getShowCreateTblDesc();
            if (showCreateTbl != null) {
                return this.showCreateTable(db, showCreateTbl);
            }
            ShowConfDesc showConf = ((DDLWork)this.work).getShowConfDesc();
            if (showConf != null) {
                return this.showConf(db, showConf);
            }
            RoleDDLDesc roleDDLDesc = ((DDLWork)this.work).getRoleDDLDesc();
            if (roleDDLDesc != null) {
                return this.roleDDL(db, roleDDLDesc);
            }
            GrantDesc grantDesc = ((DDLWork)this.work).getGrantDesc();
            if (grantDesc != null) {
                return this.grantOrRevokePrivileges(db, grantDesc.getPrincipals(), grantDesc.getPrivileges(), grantDesc.getPrivilegeSubjectDesc(), grantDesc.getGrantor(), grantDesc.getGrantorType(), grantDesc.isGrantOption(), true);
            }
            RevokeDesc revokeDesc = ((DDLWork)this.work).getRevokeDesc();
            if (revokeDesc != null) {
                return this.grantOrRevokePrivileges(db, revokeDesc.getPrincipals(), revokeDesc.getPrivileges(), revokeDesc.getPrivilegeSubjectDesc(), null, null, revokeDesc.isGrantOption(), false);
            }
            ShowGrantDesc showGrantDesc = ((DDLWork)this.work).getShowGrantDesc();
            if (showGrantDesc != null) {
                return this.showGrants(db, showGrantDesc);
            }
            GrantRevokeRoleDDL grantOrRevokeRoleDDL = ((DDLWork)this.work).getGrantRevokeRoleDDL();
            if (grantOrRevokeRoleDDL != null) {
                return this.grantOrRevokeRole(db, grantOrRevokeRoleDDL);
            }
            AlterTablePartMergeFilesDesc mergeFilesDesc = ((DDLWork)this.work).getMergeFilesDesc();
            if (mergeFilesDesc != null) {
                return this.mergeFiles(db, mergeFilesDesc, driverContext);
            }
            AlterTableAlterPartDesc alterPartDesc = ((DDLWork)this.work).getAlterTableAlterPartDesc();
            if (alterPartDesc != null) {
                return this.alterTableAlterPart(db, alterPartDesc);
            }
            TruncateTableDesc truncateTableDesc = ((DDLWork)this.work).getTruncateTblDesc();
            if (truncateTableDesc != null) {
                return this.truncateTable(db, truncateTableDesc);
            }
            AlterTableExchangePartition alterTableExchangePartition = ((DDLWork)this.work).getAlterTableExchangePartition();
            if (alterTableExchangePartition != null) {
                return this.exchangeTablePartition(db, alterTableExchangePartition);
            }
            CacheMetadataDesc cacheMetadataDesc = ((DDLWork)this.work).getCacheMetadataDesc();
            if (cacheMetadataDesc != null) {
                return this.cacheMetadata(db, cacheMetadataDesc);
            }
            InsertCommitHookDesc insertCommitHookDesc = ((DDLWork)this.work).getInsertCommitHookDesc();
            if (insertCommitHookDesc != null) {
                return this.insertCommitWork(db, insertCommitHookDesc);
            }
            PreInsertTableDesc preInsertTableDesc = ((DDLWork)this.work).getPreInsertTableDesc();
            if (preInsertTableDesc != null) {
                return this.preInsertWork(db, preInsertTableDesc);
            }
            KillQueryDesc killQueryDesc = ((DDLWork)this.work).getKillQueryDesc();
            if (killQueryDesc != null) {
                return this.killQuery(db, killQueryDesc);
            }
            if (((DDLWork)this.work).getCreateResourcePlanDesc() != null) {
                return this.createResourcePlan(db, ((DDLWork)this.work).getCreateResourcePlanDesc());
            }
            if (((DDLWork)this.work).getShowResourcePlanDesc() != null) {
                return this.showResourcePlans(db, ((DDLWork)this.work).getShowResourcePlanDesc());
            }
            if (((DDLWork)this.work).getAlterResourcePlanDesc() != null) {
                return this.alterResourcePlan(db, ((DDLWork)this.work).getAlterResourcePlanDesc());
            }
            if (((DDLWork)this.work).getDropResourcePlanDesc() != null) {
                return this.dropResourcePlan(db, ((DDLWork)this.work).getDropResourcePlanDesc());
            }
            if (((DDLWork)this.work).getCreateWMTriggerDesc() != null) {
                return this.createWMTrigger(db, ((DDLWork)this.work).getCreateWMTriggerDesc());
            }
            if (((DDLWork)this.work).getAlterWMTriggerDesc() != null) {
                return this.alterWMTrigger(db, ((DDLWork)this.work).getAlterWMTriggerDesc());
            }
            if (((DDLWork)this.work).getDropWMTriggerDesc() != null) {
                return this.dropWMTrigger(db, ((DDLWork)this.work).getDropWMTriggerDesc());
            }
            if (((DDLWork)this.work).getWmPoolDesc() != null) {
                return this.createOrAlterWMPool(db, ((DDLWork)this.work).getWmPoolDesc());
            }
            if (((DDLWork)this.work).getDropWMPoolDesc() != null) {
                return this.dropWMPool(db, ((DDLWork)this.work).getDropWMPoolDesc());
            }
            if (((DDLWork)this.work).getWmMappingDesc() != null) {
                return this.createOrAlterWMMapping(db, ((DDLWork)this.work).getWmMappingDesc());
            }
            if (((DDLWork)this.work).getDropWMMappingDesc() != null) {
                return this.dropWMMapping(db, ((DDLWork)this.work).getDropWMMappingDesc());
            }
            if (((DDLWork)this.work).getTriggerToPoolMappingDesc() != null) {
                return this.createOrDropTriggerToPoolMapping(db, ((DDLWork)this.work).getTriggerToPoolMappingDesc());
            }
            if (((DDLWork)this.work).getAlterMaterializedViewDesc() != null) {
                return this.alterMaterializedView(db, ((DDLWork)this.work).getAlterMaterializedViewDesc());
            }
        }
        catch (Throwable e) {
            this.failed(e);
            return 1;
        }
        assert (false);
        return 0;
    }

    private int createResourcePlan(Hive db, CreateResourcePlanDesc createResourcePlanDesc) throws HiveException {
        db.createResourcePlan(createResourcePlanDesc.getResourcePlan(), createResourcePlanDesc.getCopyFromName());
        return 0;
    }

    private int showResourcePlans(Hive db, ShowResourcePlanDesc showResourcePlanDesc) throws HiveException {
        DataOutputStream out = this.getOutputStream(showResourcePlanDesc.getResFile());
        try {
            String rpName = showResourcePlanDesc.getResourcePlanName();
            if (rpName != null) {
                this.formatter.showFullResourcePlan(out, db.getResourcePlan(rpName));
            } else {
                this.formatter.showResourcePlans(out, db.getAllResourcePlans());
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
        return 0;
    }

    private int alterResourcePlan(Hive db, AlterResourcePlanDesc desc) throws HiveException {
        boolean mustHaveAppliedChange;
        if (desc.shouldValidate()) {
            WMValidateResourcePlanResponse result = db.validateResourcePlan(desc.getResourcePlanName());
            try (DataOutputStream out = this.getOutputStream(desc.getResFile());){
                this.formatter.showErrors(out, result);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            return 0;
        }
        WMNullableResourcePlan resourcePlan = desc.getResourcePlan();
        WorkloadManager wm = WorkloadManager.getInstance();
        TezSessionPoolManager pm = TezSessionPoolManager.getInstance();
        boolean isActivate = false;
        boolean isInTest = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST);
        if (resourcePlan.getStatus() != null) {
            isActivate = resourcePlan.getStatus() == WMResourcePlanStatus.ACTIVE;
        }
        WMFullResourcePlan appliedRp = db.alterResourcePlan(desc.getResourcePlanName(), resourcePlan, desc.isEnableActivate(), desc.isForceDeactivate(), desc.isReplace());
        boolean bl = mustHaveAppliedChange = isActivate || desc.isForceDeactivate();
        if (!mustHaveAppliedChange && !desc.isReplace()) {
            return 0;
        }
        if (appliedRp == null && !mustHaveAppliedChange) {
            return 0;
        }
        if (wm == null && isInTest) {
            return 0;
        }
        if (appliedRp == null != desc.isForceDeactivate()) {
            throw new HiveException("Cannot get a resource plan to apply; or non-null plan on disable");
        }
        assert (appliedRp == null || appliedRp.getPlan().getStatus() == WMResourcePlanStatus.ACTIVE);
        this.handleWorkloadManagementServiceChange(wm, pm, isActivate, appliedRp);
        return 0;
    }

    private int handleWorkloadManagementServiceChange(WorkloadManager wm, TezSessionPoolManager pm, boolean isActivate, WMFullResourcePlan appliedRp) throws HiveException {
        String name = null;
        if (isActivate) {
            name = appliedRp.getPlan().getName();
            LOG.info("Activating a new resource plan " + name + ": " + appliedRp);
        } else {
            LOG.info("Disabling workload management");
        }
        if (wm != null) {
            ListenableFuture<Boolean> future = wm.updateResourcePlanAsync(appliedRp);
            boolean isOk = false;
            try {
                future.get();
                isOk = true;
                if (isActivate) {
                    LOG.info("Successfully activated resource plan " + name);
                } else {
                    LOG.info("Successfully disabled workload management");
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HiveException(e);
            }
            finally {
                if (!isOk) {
                    if (isActivate) {
                        LOG.error("Failed to activate resource plan " + name);
                    } else {
                        LOG.error("Failed to disable workload management");
                    }
                }
            }
        }
        if (pm != null) {
            pm.updateTriggers(appliedRp);
            LOG.info("Updated tez session pool manager with active resource plan: {}", (Object)name);
        }
        return 0;
    }

    private int dropResourcePlan(Hive db, DropResourcePlanDesc desc) throws HiveException {
        db.dropResourcePlan(desc.getRpName());
        return 0;
    }

    private int createWMTrigger(Hive db, CreateWMTriggerDesc desc) throws HiveException {
        db.createWMTrigger(desc.getTrigger());
        return 0;
    }

    private int alterWMTrigger(Hive db, AlterWMTriggerDesc desc) throws HiveException {
        db.alterWMTrigger(desc.getTrigger());
        return 0;
    }

    private int dropWMTrigger(Hive db, DropWMTriggerDesc desc) throws HiveException {
        db.dropWMTrigger(desc.getRpName(), desc.getTriggerName());
        return 0;
    }

    private int createOrAlterWMPool(Hive db, CreateOrAlterWMPoolDesc desc) throws HiveException {
        if (desc.isUpdate()) {
            db.alterWMPool(desc.getAlterPool(), desc.getPoolPath());
        } else {
            db.createWMPool(desc.getCreatePool());
        }
        return 0;
    }

    private int dropWMPool(Hive db, DropWMPoolDesc desc) throws HiveException {
        db.dropWMPool(desc.getResourcePlanName(), desc.getPoolPath());
        return 0;
    }

    private int createOrAlterWMMapping(Hive db, CreateOrAlterWMMappingDesc desc) throws HiveException {
        db.createOrUpdateWMMapping(desc.getMapping(), desc.isUpdate());
        return 0;
    }

    private int dropWMMapping(Hive db, DropWMMappingDesc desc) throws HiveException {
        db.dropWMMapping(desc.getMapping());
        return 0;
    }

    private int createOrDropTriggerToPoolMapping(Hive db, CreateOrDropTriggerToPoolMappingDesc desc) throws HiveException {
        if (!desc.isUnmanagedPool()) {
            db.createOrDropTriggerToPoolMapping(desc.getResourcePlanName(), desc.getTriggerName(), desc.getPoolPath(), desc.shouldDrop());
        } else {
            assert (desc.getPoolPath() == null);
            WMTrigger trigger = new WMTrigger(desc.getResourcePlanName(), desc.getTriggerName());
            trigger.setIsInUnmanaged(!desc.shouldDrop());
            db.alterWMTrigger(trigger);
        }
        return 0;
    }

    private int preInsertWork(Hive db, PreInsertTableDesc preInsertTableDesc) throws HiveException {
        try {
            HiveMetaHook hook = preInsertTableDesc.getTable().getStorageHandler().getMetaHook();
            if (hook == null || !(hook instanceof DefaultHiveMetaHook)) {
                return 0;
            }
            DefaultHiveMetaHook hiveMetaHook = (DefaultHiveMetaHook)hook;
            hiveMetaHook.preInsertTable(preInsertTableDesc.getTable().getTTable(), preInsertTableDesc.isOverwrite());
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertCommitWork(Hive db, InsertCommitHookDesc insertCommitHookDesc) throws MetaException {
        boolean failed = true;
        HiveMetaHook hook = insertCommitHookDesc.getTable().getStorageHandler().getMetaHook();
        if (hook == null || !(hook instanceof DefaultHiveMetaHook)) {
            return 0;
        }
        DefaultHiveMetaHook hiveMetaHook = (DefaultHiveMetaHook)hook;
        try {
            hiveMetaHook.commitInsertTable(insertCommitHookDesc.getTable().getTTable(), insertCommitHookDesc.isOverwrite());
            failed = false;
        }
        finally {
            if (failed) {
                hiveMetaHook.rollbackInsertTable(insertCommitHookDesc.getTable().getTTable(), insertCommitHookDesc.isOverwrite());
            }
        }
        return 0;
    }

    private int cacheMetadata(Hive db, CacheMetadataDesc desc) throws HiveException {
        db.cacheFileMetadata(desc.getDbName(), desc.getTableName(), desc.getPartName(), desc.isAllParts());
        return 0;
    }

    private void failed(Throwable e) {
        while (e.getCause() != null && e.getClass() == RuntimeException.class) {
            e = e.getCause();
        }
        this.setException(e);
        LOG.error("Failed", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showConf(Hive db, ShowConfDesc showConf) throws Exception {
        HiveConf.ConfVars conf = HiveConf.getConfVars(showConf.getConfName());
        if (conf == null) {
            throw new HiveException("invalid configuration name " + showConf.getConfName());
        }
        String description = conf.getDescription();
        String defaultValue = conf.getDefaultValue();
        try (DataOutputStream output = this.getOutputStream(showConf.getResFile());){
            if (defaultValue != null) {
                output.write(defaultValue.getBytes());
            }
            output.write(9);
            output.write(conf.typeString().getBytes());
            output.write(9);
            if (description != null) {
                output.write(description.replaceAll(" *\n *", " ").getBytes());
            }
            output.write(10);
        }
        return 0;
    }

    private DataOutputStream getOutputStream(String resFile) throws HiveException {
        try {
            return this.getOutputStream(new Path(resFile));
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private DataOutputStream getOutputStream(Path outputFile) throws HiveException {
        try {
            FileSystem fs = outputFile.getFileSystem((Configuration)this.conf);
            return fs.create(outputFile);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private int mergeFiles(Hive db, AlterTablePartMergeFilesDesc mergeFilesDesc, DriverContext driverContext) throws HiveException {
        Task task;
        ListBucketingCtx lbCtx = mergeFilesDesc.getLbCtx();
        boolean lbatc = lbCtx == null ? false : lbCtx.isSkewedStoredAsDir();
        int lbd = lbCtx == null ? 0 : lbCtx.calculateListBucketingLevel();
        MergeFileWork mergeWork = new MergeFileWork(mergeFilesDesc.getInputDir(), mergeFilesDesc.getOutputDir(), mergeFilesDesc.getInputFormatClass().getName(), mergeFilesDesc.getTableDesc());
        LinkedHashMap<Path, ArrayList<String>> pathToAliases = new LinkedHashMap<Path, ArrayList<String>>();
        ArrayList<String> inputDirstr = new ArrayList<String>(1);
        inputDirstr.add(mergeFilesDesc.getInputDir().toString());
        pathToAliases.put(mergeFilesDesc.getInputDir().get(0), inputDirstr);
        mergeWork.setPathToAliases(pathToAliases);
        mergeWork.setListBucketingCtx(mergeFilesDesc.getLbCtx());
        mergeWork.resolveConcatenateMerge(db.getConf());
        mergeWork.setMapperCannotSpanPartns(true);
        mergeWork.setSourceTableInputFormat(mergeFilesDesc.getInputFormatClass().getName());
        FileMergeDesc fmd = mergeFilesDesc.getInputFormatClass().equals(RCFileInputFormat.class) ? new RCFileMergeDesc() : new OrcFileMergeDesc();
        fmd.setDpCtx(null);
        fmd.setHasDynamicPartitions(false);
        fmd.setListBucketingAlterTableConcatenate(lbatc);
        fmd.setListBucketingDepth(lbd);
        fmd.setOutputPath(mergeFilesDesc.getOutputDir());
        CompilationOpContext opContext = driverContext.getCtx().getOpContext();
        Operator<FileMergeDesc> mergeOp = OperatorFactory.get(opContext, fmd);
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        aliasToWork.put(mergeFilesDesc.getInputDir().toString(), mergeOp);
        mergeWork.setAliasToWork(aliasToWork);
        DriverContext driverCxt = new DriverContext();
        if (this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            TezWork tezWork = new TezWork(this.queryState.getQueryId(), this.conf);
            mergeWork.setName("File Merge");
            tezWork.add(mergeWork);
            task = new TezTask();
            ((TezTask)task).setWork(tezWork);
        } else {
            task = new MergeFileTask();
            task.setWork(mergeWork);
        }
        task.initialize(this.queryState, this.getQueryPlan(), driverCxt, opContext);
        this.subtask = task;
        int ret = task.execute(driverCxt);
        if (this.subtask.getException() != null) {
            this.setException(this.subtask.getException());
        }
        return ret;
    }

    private HiveAuthorizer getSessionAuthorizer(Hive db) {
        HiveAuthorizer authorizer = SessionState.get().getAuthorizerV2();
        if (authorizer == null) {
            authorizer = new HiveV1Authorizer(this.conf, db);
        }
        return authorizer;
    }

    private int grantOrRevokeRole(Hive db, GrantRevokeRoleDDL grantOrRevokeRoleDDL) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer(db);
        HivePrincipal grantorPrinc = null;
        if (grantOrRevokeRoleDDL.getGrantor() != null) {
            grantorPrinc = new HivePrincipal(grantOrRevokeRoleDDL.getGrantor(), AuthorizationUtils.getHivePrincipalType(grantOrRevokeRoleDDL.getGrantorType()));
        }
        List<HivePrincipal> principals = AuthorizationUtils.getHivePrincipals(grantOrRevokeRoleDDL.getPrincipalDesc(), this.getAuthorizationTranslator(authorizer));
        List<String> roles = grantOrRevokeRoleDDL.getRoles();
        boolean grantOption = grantOrRevokeRoleDDL.isGrantOption();
        if (grantOrRevokeRoleDDL.getGrant()) {
            authorizer.grantRole(principals, roles, grantOption, grantorPrinc);
        } else {
            authorizer.revokeRole(principals, roles, grantOption, grantorPrinc);
        }
        return 0;
    }

    private HiveAuthorizationTranslator getAuthorizationTranslator(HiveAuthorizer authorizer) throws HiveAuthzPluginException {
        if (authorizer.getHiveAuthorizationTranslator() == null) {
            return this.defaultAuthorizationTranslator;
        }
        return (HiveAuthorizationTranslator)authorizer.getHiveAuthorizationTranslator();
    }

    private int showGrants(Hive db, ShowGrantDesc showGrantDesc) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer(db);
        try {
            List<HivePrivilegeInfo> privInfos = authorizer.showPrivileges(this.getAuthorizationTranslator(authorizer).getHivePrincipal(showGrantDesc.getPrincipalDesc()), this.getAuthorizationTranslator(authorizer).getHivePrivilegeObject(showGrantDesc.getHiveObj()));
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
            this.writeToFile(DDLTask.writeGrantInfo(privInfos, testMode), showGrantDesc.getResFile());
        }
        catch (IOException e) {
            throw new HiveException("Error in show grant statement", e);
        }
        return 0;
    }

    private int grantOrRevokePrivileges(Hive db, List<PrincipalDesc> principals, List<PrivilegeDesc> privileges, PrivilegeObjectDesc privSubjectDesc, String grantor, PrincipalType grantorType, boolean grantOption, boolean isGrant) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer(db);
        List<HivePrincipal> hivePrincipals = AuthorizationUtils.getHivePrincipals(principals, this.getAuthorizationTranslator(authorizer));
        List<HivePrivilege> hivePrivileges = AuthorizationUtils.getHivePrivileges(privileges, this.getAuthorizationTranslator(authorizer));
        HivePrivilegeObject hivePrivObject = this.getAuthorizationTranslator(authorizer).getHivePrivilegeObject(privSubjectDesc);
        HivePrincipal grantorPrincipal = new HivePrincipal(grantor, AuthorizationUtils.getHivePrincipalType(grantorType));
        if (isGrant) {
            authorizer.grantPrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        } else {
            authorizer.revokePrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        }
        return 0;
    }

    private int roleDDL(Hive db, RoleDDLDesc roleDDLDesc) throws Exception {
        HiveAuthorizer authorizer = this.getSessionAuthorizer(db);
        RoleDDLDesc.RoleOperation operation = roleDDLDesc.getOperation();
        switch (operation) {
            case CREATE_ROLE: {
                authorizer.createRole(roleDDLDesc.getName(), null);
                break;
            }
            case DROP_ROLE: {
                authorizer.dropRole(roleDDLDesc.getName());
                break;
            }
            case SHOW_ROLE_GRANT: {
                boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
                List<HiveRoleGrant> roles = authorizer.getRoleGrantInfoForPrincipal(AuthorizationUtils.getHivePrincipal(roleDDLDesc.getName(), roleDDLDesc.getPrincipalType()));
                this.writeToFile(DDLTask.writeRolesGrantedInfo(roles, testMode), roleDDLDesc.getResFile());
                break;
            }
            case SHOW_ROLES: {
                List<String> allRoles = authorizer.getAllRoles();
                this.writeListToFileAfterSort(allRoles, roleDDLDesc.getResFile());
                break;
            }
            case SHOW_CURRENT_ROLE: {
                List<String> roleNames = authorizer.getCurrentRoleNames();
                this.writeListToFileAfterSort(roleNames, roleDDLDesc.getResFile());
                break;
            }
            case SET_ROLE: {
                authorizer.setCurrentRole(roleDDLDesc.getName());
                break;
            }
            case SHOW_ROLE_PRINCIPALS: {
                boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
                List<HiveRoleGrant> roleGrants = authorizer.getPrincipalGrantInfoForRole(roleDDLDesc.getName());
                this.writeToFile(this.writeHiveRoleGrantInfo(roleGrants, testMode), roleDDLDesc.getResFile());
                break;
            }
            default: {
                throw new HiveException("Unkown role operation " + operation.getOperationName());
            }
        }
        return 0;
    }

    private String writeHiveRoleGrantInfo(List<HiveRoleGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (HiveRoleGrant roleGrant : roleGrants) {
            DDLTask.appendNonNull(builder, roleGrant.getPrincipalName(), true);
            DDLTask.appendNonNull(builder, roleGrant.getPrincipalType());
            DDLTask.appendNonNull(builder, roleGrant.isGrantOption());
            DDLTask.appendNonNull(builder, roleGrant.getGrantor());
            DDLTask.appendNonNull(builder, roleGrant.getGrantorType());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
        }
        return builder.toString();
    }

    private void writeListToFileAfterSort(List<String> entries, String resFile) throws IOException {
        Collections.sort(entries);
        StringBuilder sb = new StringBuilder();
        for (String entry : entries) {
            DDLTask.appendNonNull(sb, entry, true);
        }
        this.writeToFile(sb.toString(), resFile);
    }

    private int alterDatabase(Hive db, AlterDatabaseDesc alterDbDesc) throws HiveException {
        String dbName = alterDbDesc.getDatabaseName();
        Database database = db.getDatabase(dbName);
        if (database == null) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        Map<String, String> params = database.getParameters();
        if (null != alterDbDesc.getReplicationSpec() && !alterDbDesc.getReplicationSpec().allowEventReplacementInto(params)) {
            LOG.debug("DDLTask: Alter Database {} is skipped as database is newer than update", (Object)dbName);
            return 0;
        }
        switch (alterDbDesc.getAlterType()) {
            case ALTER_PROPERTY: {
                Map<String, String> newParams = alterDbDesc.getDatabaseProperties();
                if (params != null && newParams != null) {
                    params.putAll(newParams);
                    database.setParameters(params);
                    break;
                }
                database.setParameters(newParams);
                break;
            }
            case ALTER_OWNER: {
                database.setOwnerName(alterDbDesc.getOwnerPrincipal().getName());
                database.setOwnerType(alterDbDesc.getOwnerPrincipal().getType());
                break;
            }
            case ALTER_LOCATION: {
                try {
                    String newLocation = alterDbDesc.getLocation();
                    URI locationURI = new URI(newLocation);
                    if (!locationURI.isAbsolute() || StringUtils.isBlank(locationURI.getScheme())) {
                        throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, newLocation);
                    }
                    if (newLocation.equals(database.getLocationUri())) {
                        LOG.info("AlterDatabase skipped. No change in location.");
                        break;
                    }
                    database.setLocationUri(newLocation);
                    break;
                }
                catch (URISyntaxException e) {
                    throw new HiveException(e);
                }
            }
            default: {
                throw new AssertionError((Object)("Unsupported alter database type! : " + alterDbDesc.getAlterType()));
            }
        }
        db.alterDatabase(database.getName(), database);
        return 0;
    }

    private int alterMaterializedView(Hive db, AlterMaterializedViewDesc alterMVDesc) throws HiveException {
        String mvName = alterMVDesc.getMaterializedViewName();
        Table oldMV = db.getTable(mvName);
        Table mv = oldMV.copy();
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        switch (alterMVDesc.getOp()) {
            case UPDATE_REWRITE_FLAG: {
                if (mv.isRewriteEnabled() == alterMVDesc.isRewriteEnable()) {
                    return 0;
                }
                mv.setRewriteEnabled(alterMVDesc.isRewriteEnable());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported alter materialized view type! : " + alterMVDesc.getOp()));
            }
        }
        db.alterTable(mv, environmentContext);
        return 0;
    }

    private int addPartitions(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        List<Partition> parts = db.createPartitions(addPartitionDesc);
        for (Partition part : parts) {
            this.addIfAbsentByName(new WriteEntity(part, WriteEntity.WriteType.INSERT));
        }
        return 0;
    }

    private int renamePartition(Hive db, RenamePartitionDesc renamePartitionDesc) throws HiveException {
        LinkedHashMap<String, String> oldPartSpec;
        String tableName = renamePartitionDesc.getTableName();
        if (!this.allowOperationInReplicationScope(db, tableName, oldPartSpec = renamePartitionDesc.getOldPartSpec(), renamePartitionDesc.getReplicationSpec())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DDLTask: Rename Partition is skipped as table {} / partition {} is newer than update", (Object)tableName, (Object)FileUtils.makePartName(new ArrayList<String>(oldPartSpec.keySet()), new ArrayList<String>(oldPartSpec.values())));
            }
            return 0;
        }
        String[] names = Utilities.getDbTableName(tableName);
        if (Utils.isBootstrapDumpInProgress(db, names[0])) {
            LOG.error("DDLTask: Rename Partition not allowed as bootstrap dump in progress");
            throw new HiveException("Rename Partition: Not allowed as bootstrap dump in progress");
        }
        Table tbl = db.getTable(tableName);
        Partition oldPart = db.getPartition(tbl, oldPartSpec, false);
        if (oldPart == null) {
            String partName = FileUtils.makePartName(new ArrayList<String>(oldPartSpec.keySet()), new ArrayList<String>(oldPartSpec.values()));
            throw new HiveException("Rename partition: source partition [" + partName + "] does not exist.");
        }
        Partition part = db.getPartition(tbl, oldPartSpec, false);
        part.setValues(renamePartitionDesc.getNewPartSpec());
        db.renamePartition(tbl, oldPartSpec, part);
        Partition newPart = db.getPartition(tbl, renamePartitionDesc.getNewPartSpec(), false);
        ((DDLWork)this.work).getInputs().add(new ReadEntity(oldPart));
        this.addIfAbsentByName(new WriteEntity(newPart, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int alterTableAlterPart(Hive db, AlterTableAlterPartDesc alterPartitionDesc) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int touch(Hive db, AlterTableSimpleDesc touchDesc) throws HiveException {
        Table tbl = db.getTable(touchDesc.getTableName());
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        if (touchDesc.getPartSpec() == null) {
            db.alterTable(tbl, environmentContext);
            ((DDLWork)this.work).getInputs().add(new ReadEntity(tbl));
            this.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            Partition part = db.getPartition(tbl, touchDesc.getPartSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                db.alterPartition(touchDesc.getTableName(), part, environmentContext);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            this.addIfAbsentByName(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private void setIsArchived(Partition p, boolean state, int level) {
        Map<String, String> params = p.getParameters();
        if (state) {
            params.put("is_archived", "true");
            params.put("archiving_level", Integer.toString(level));
        } else {
            params.remove("is_archived");
            params.remove("archiving_level");
        }
    }

    private String getOriginalLocation(Partition p) {
        Map<String, String> params = p.getParameters();
        return params.get("original_location");
    }

    private void setOriginalLocation(Partition p, String loc) {
        Map<String, String> params = p.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    private void setArchived(Partition p, Path harPath, int level) {
        assert (!ArchiveUtils.isArchived(p));
        this.setIsArchived(p, true, level);
        this.setOriginalLocation(p, p.getLocation());
        p.setLocation(harPath.toString());
    }

    private void setUnArchived(Partition p) {
        assert (ArchiveUtils.isArchived(p));
        String parentDir = this.getOriginalLocation(p);
        this.setIsArchived(p, false, 0);
        this.setOriginalLocation(p, null);
        assert (parentDir != null);
        p.setLocation(parentDir);
    }

    private boolean pathExists(Path p) throws HiveException {
        try {
            FileSystem fs = p.getFileSystem((Configuration)this.conf);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void deleteDir(Path dir, Database db) throws HiveException {
        try {
            Warehouse wh = new Warehouse(this.conf);
            wh.deleteDir(dir, true, db);
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
    }

    boolean partitionInCustomLocation(Table tbl, Partition p) throws HiveException {
        String subdir = null;
        try {
            subdir = Warehouse.makePartName(tbl.getPartCols(), p.getValues());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to get partition's directory", e);
        }
        Path tableDir = tbl.getDataLocation();
        if (tableDir == null) {
            throw new HiveException("Table has no location set");
        }
        String standardLocation = new Path(tableDir, subdir).toString();
        if (ArchiveUtils.isArchived(p)) {
            return !this.getOriginalLocation(p).equals(standardLocation);
        }
        return !p.getLocation().equals(standardLocation);
    }

    private int archive(Hive db, AlterTableSimpleDesc simpleDesc, DriverContext driverContext) throws HiveException {
        Table tbl = db.getTable(simpleDesc.getTableName());
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("ARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : p.getDataLocation();
        }
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateOriginalDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
        this.console.printInfo("intermediate.archived is " + intermediateArchivedDir.toString());
        this.console.printInfo("intermediate.original is " + intermediateOriginalDir.toString());
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        URI archiveUri = new Path(originalDir, archiveName).toUri();
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        for (Partition p : partitions) {
            if (!ArchiveUtils.isArchived(p)) continue;
            if (ArchiveUtils.getArchivingLevel(p) != partSpecInfo.values.size()) {
                String name = ArchiveUtils.getPartialName(p, ArchiveUtils.getArchivingLevel(p));
                String m = String.format("Conflict with existing archive %s", name);
                throw new HiveException(m);
            }
            throw new HiveException("Partition(s) already archived");
        }
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateOriginalDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed ARCHIVE");
        }
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(intermediateOriginalDir)) {
            Path tmpPath = new Path(driverContext.getCtx().getExternalTmpPath(originalDir), "partlevel");
            this.console.printInfo("Creating " + archiveName + " for " + originalDir.toString());
            this.console.printInfo("in " + (Path)tmpPath);
            this.console.printInfo("Please wait... (this may take a while)");
            int ret = 0;
            try {
                int maxJobNameLen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
                String jobname = String.format("Archiving %s@%s", tbl.getTableName(), partSpecInfo.getName());
                jobname = Utilities.abbreviate(jobname, maxJobNameLen - 6);
                this.conf.set("mapreduce.job.name", jobname);
                HadoopArchives har = new HadoopArchives((Configuration)this.conf);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-archiveName");
                args.add(archiveName);
                args.add("-p");
                args.add(originalDir.toString());
                args.add(tmpPath.toString());
                ret = ToolRunner.run((Tool)har, (String[])args.toArray(new String[0]));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
            try {
                this.console.printInfo("Moving " + (Path)tmpPath + " to " + intermediateArchivedDir);
                if (this.pathExists(intermediateArchivedDir)) {
                    throw new HiveException("The intermediate archive directory already exists.");
                }
                fs.rename(tmpPath, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException("Error while moving tmp directory");
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.console.printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        if (!this.pathExists(intermediateOriginalDir)) {
            this.console.printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.console.printInfo(intermediateOriginalDir + " already exists. Assuming it contains the original files in the partition");
        }
        if (!this.pathExists(originalDir)) {
            this.console.printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.console.printInfo(originalDir + " already exists. Assuming it contains the archived version of the partition");
        }
        try {
            for (Partition p : partitions) {
                URI originalPartitionUri = ArchiveUtils.addSlash(p.getDataLocation().toUri());
                URI harPartitionDir = harHelper.getHarUri(originalPartitionUri);
                StringBuilder authority = new StringBuilder();
                if (harPartitionDir.getUserInfo() != null) {
                    authority.append(harPartitionDir.getUserInfo()).append("@");
                }
                authority.append(harPartitionDir.getHost());
                if (harPartitionDir.getPort() != -1) {
                    authority.append(":").append(harPartitionDir.getPort());
                }
                Path harPath = new Path(harPartitionDir.getScheme(), authority.toString(), harPartitionDir.getPath());
                this.setArchived(p, harPath, partSpecInfo.values.size());
                db.alterPartition(simpleDesc.getTableName(), p, null);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
        if (this.pathExists(intermediateOriginalDir)) {
            this.deleteDir(intermediateOriginalDir, db.getDatabase(tbl.getDbName()));
        }
        if (recovery) {
            this.console.printInfo("Recovery after ARCHIVE succeeded");
        }
        return 0;
    }

    private int unarchive(Hive db, AlterTableSimpleDesc simpleDesc) throws HiveException, URISyntaxException {
        Table tbl = db.getTable(simpleDesc.getTableName());
        if (simpleDesc.getPartSpec() == null) {
            throw new HiveException("UNARCHIVE is for partitions only");
        }
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        int partSpecLevel = partSpec.size();
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("UNARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : new Path(p.getLocation());
        }
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateExtractedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_EXTRACTED_DIR_SUFFIX);
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateExtractedDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed UNARCHIVE");
        }
        for (Partition p : partitions) {
            this.checkArchiveProperty(partSpecLevel, recovery, p);
        }
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        Path archivePath = new Path(originalDir, archiveName);
        URI archiveUri = archivePath.toUri();
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        URI sourceUri = harHelper.getHarUri(originalUri);
        Path sourceDir = new Path(sourceUri.getScheme(), sourceUri.getAuthority(), sourceUri.getPath());
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(archivePath)) {
            throw new HiveException("Haven't found any archive where it should be");
        }
        Path tmpPath = this.driverContext.getCtx().getExternalTmpPath(originalDir);
        try {
            fs = tmpPath.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (!this.pathExists(intermediateExtractedDir) && !this.pathExists(intermediateArchivedDir)) {
            try {
                String copySource = sourceDir.toString();
                String copyDest = tmpPath.toString();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(copySource);
                args.add(copyDest);
                this.console.printInfo("Copying " + copySource + " to " + copyDest);
                FileSystem srcFs = FileSystem.get((URI)sourceDir.toUri(), (Configuration)this.conf);
                srcFs.initialize(sourceDir.toUri(), (Configuration)this.conf);
                FsShell fss = new FsShell((Configuration)this.conf);
                int ret = 0;
                try {
                    ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                if (ret != 0) {
                    throw new HiveException("Error while copying files from archive, return code=" + ret);
                }
                this.console.printInfo("Successfully Copied " + copySource + " to " + copyDest);
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateExtractedDir);
                if (fs.exists(intermediateExtractedDir)) {
                    throw new HiveException("Invalid state: the intermediate extracted directory already exists.");
                }
                fs.rename(tmpPath, intermediateExtractedDir);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        if (!this.pathExists(intermediateArchivedDir)) {
            try {
                this.console.printInfo("Moving " + originalDir + " to " + intermediateArchivedDir);
                fs.rename(originalDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(intermediateArchivedDir + " already exists. Assuming it contains the archived version of the partition");
        }
        if (!this.pathExists(originalDir)) {
            try {
                this.console.printInfo("Moving " + intermediateExtractedDir + " to " + originalDir);
                fs.rename(intermediateExtractedDir, originalDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(originalDir + " already exists. Assuming it contains the extracted files in the partition");
        }
        for (Partition p : partitions) {
            this.setUnArchived(p);
            try {
                db.alterPartition(simpleDesc.getTableName(), p, null);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.deleteDir(intermediateArchivedDir, db.getDatabase(tbl.getDbName()));
        }
        if (recovery) {
            this.console.printInfo("Recovery after UNARCHIVE succeeded");
        }
        return 0;
    }

    private void checkArchiveProperty(int partSpecLevel, boolean recovery, Partition p) throws HiveException {
        if (!ArchiveUtils.isArchived(p) && !recovery) {
            throw new HiveException("Partition " + p.getName() + " is not archived.");
        }
        int archiveLevel = ArchiveUtils.getArchivingLevel(p);
        if (partSpecLevel > archiveLevel) {
            throw new HiveException("Partition " + p.getName() + " is archived at level " + archiveLevel + ", and given partspec only has " + partSpecLevel + " specs.");
        }
    }

    private int compact(Hive db, AlterTableSimpleDesc desc) throws HiveException {
        block19: {
            ShowCompactResponseElement compaction;
            CompactionResponse resp;
            Table tbl = db.getTable(desc.getTableName());
            if (!AcidUtils.isTransactionalTable(tbl)) {
                throw new HiveException(ErrorMsg.NONACID_COMPACTION_NOT_SUPPORTED, tbl.getDbName(), tbl.getTableName());
            }
            String partName = null;
            if (desc.getPartSpec() == null) {
                if (tbl.isPartitioned()) {
                    throw new HiveException(ErrorMsg.NO_COMPACTION_PARTITION);
                }
            } else {
                LinkedHashMap<String, String> partSpec = desc.getPartSpec();
                List<Partition> partitions = db.getPartitions(tbl, partSpec);
                if (partitions.size() > 1) {
                    throw new HiveException(ErrorMsg.TOO_MANY_COMPACTION_PARTITIONS);
                }
                if (partitions.size() == 0) {
                    throw new HiveException(ErrorMsg.INVALID_PARTITION_SPEC);
                }
                partName = partitions.get(0).getName();
            }
            if ((resp = db.compact2(tbl.getDbName(), tbl.getTableName(), partName, desc.getCompactionType(), desc.getProps())).isAccepted()) {
                this.console.printInfo("Compaction enqueued with id " + resp.getId());
            } else {
                this.console.printInfo("Compaction already enqueued with id " + resp.getId() + "; State is " + resp.getState());
            }
            if (!desc.isBlocking() || !resp.isAccepted()) break block19;
            StringBuilder progressDots = new StringBuilder();
            long waitTimeMs = 1000L;
            block9: while (true) {
                waitTimeMs = (waitTimeMs *= 2L) < 300000L ? waitTimeMs : 300000L;
                try {
                    Thread.sleep(waitTimeMs);
                }
                catch (InterruptedException ex) {
                    this.console.printInfo("Interrupted while waiting for compaction with id=" + resp.getId());
                    break block19;
                }
                ShowCompactResponse allCompactions = db.showCompactions();
                Iterator<ShowCompactResponseElement> iterator = allCompactions.getCompacts().iterator();
                do {
                    if (!iterator.hasNext()) continue block9;
                    compaction = iterator.next();
                } while (resp.getId() != compaction.getId());
                switch (compaction.getState()) {
                    case "working": 
                    case "initiated": {
                        this.console.printInfo(progressDots.toString());
                        progressDots.append(".");
                        continue block9;
                    }
                }
                break;
            }
            this.console.printInfo("Compaction with id " + resp.getId() + " finished with status: " + compaction.getState());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        result = new CheckResult();
        repairOutput = new ArrayList<String>();
        try {
            checker = new HiveMetaStoreChecker(db);
            names = Utilities.getDbTableName(msckDesc.getTableName());
            checker.checkMetastore(names[0], names[1], msckDesc.getPartSpecs(), result);
            partsNotInMs = result.getPartitionsNotInMs();
            partsNotInFs = result.getPartitionsNotOnFs();
            if (msckDesc.isRepairPartitions() == false) return 0;
            table = db.getTable(msckDesc.getTableName());
            maxRetries = this.conf.getIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_MAX_RETRIES);
            decayingFactor = 2;
            if (!msckDesc.isAddPartitions() || partsNotInMs.isEmpty()) ** GOTO lbl38
            batchSize = this.conf.getIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_SIZE);
            if (batchSize == 0) {
                batchSize = partsNotInMs.size();
            }
            vals = null;
            settingStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_MSCK_PATH_VALIDATION);
            doValidate = "ignore".equals(settingStr) == false;
            v0 = doSkip = doValidate != false && "skip".equals(settingStr) != false;
            if (!doValidate) ** GOTO lbl33
            iter = partsNotInMs.iterator();
            while (true) {
                if (iter.hasNext()) {
                    part = iter.next();
                    try {
                        vals = Warehouse.makeValsFromName(part.getPartitionName(), vals);
                    }
                    catch (MetaException ex) {
                        throw new HiveException(ex);
                    }
                    var19_51 = vals.iterator();
                    break;
                }
lbl33:
                // 3 sources

                try {
                    this.createPartitionsInBatches(db, repairOutput, partsNotInMs, table, batchSize, decayingFactor, maxRetries);
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
lbl38:
                // 2 sources

                if (msckDesc.isDropPartitions() == false) return 0;
                if (partsNotInFs.isEmpty() != false) return 0;
                batchSize = this.conf.getIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_SIZE);
                if (batchSize == 0) {
                    batchSize = partsNotInFs.size();
                }
                try {
                    this.dropPartitionsInBatches(db, repairOutput, partsNotInFs, table, batchSize, decayingFactor, maxRetries);
                    return 0;
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
                break;
            }
        }
        catch (HiveException e) {
            DDLTask.LOG.warn("Failed to run metacheck: ", (Throwable)e);
            var6_11 = 1;
            return var6_11;
        }
        catch (IOException e) {
            DDLTask.LOG.warn("Failed to run metacheck: ", (Throwable)e);
            var6_12 = 1;
            return var6_12;
        }
        finally {
            resultOut = null;
            try {
                resFile = new Path(msckDesc.getResFile());
                fs = resFile.getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                DDLTask.LOG.warn("Failed to save metacheck output: ", (Throwable)e);
                fs = 1;
                return fs;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        DDLTask.LOG.warn("Failed to close output file: ", (Throwable)e);
                        return 1;
                    }
                }
            }
        }
        while (true) {
            if (!var19_51.hasNext()) ** continue;
            val = var19_51.next();
            escapedPath = FileUtils.escapePathName(val);
            if (!DDLTask.$assertionsDisabled && escapedPath == null) {
                throw new AssertionError();
            }
            if (escapedPath.equals(val)) ** continue;
            errorMsg = "Repair: Cannot add partition " + msckDesc.getTableName() + ":" + part.getPartitionName() + " due to invalid characters in the name";
            if (doSkip == false) throw new HiveException(errorMsg);
            repairOutput.add(errorMsg);
            iter.remove();
        }
    }

    @VisibleForTesting
    void createPartitionsInBatches(final Hive db, final List<String> repairOutput, Set<CheckResult.PartitionResult> partsNotInMs, final Table table, int batchSize, int decayingFactor, int maxRetries) throws Exception {
        final String addMsgFormat = "Repair: Added partition to metastore " + table.getTableName() + ":%s";
        final HashSet<CheckResult.PartitionResult> batchWork = new HashSet<CheckResult.PartitionResult>(partsNotInMs);
        new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(batchSize, decayingFactor, maxRetries){

            @Override
            public Void execute(int size) throws Exception {
                while (!batchWork.isEmpty()) {
                    int currentBatchSize = size;
                    AddPartitionDesc apd = new AddPartitionDesc(table.getDbName(), table.getTableName(), true);
                    ArrayList<CheckResult.PartitionResult> lastBatch = new ArrayList<CheckResult.PartitionResult>(currentBatchSize);
                    ArrayList<String> addMsgs = new ArrayList<String>(currentBatchSize);
                    for (CheckResult.PartitionResult part : batchWork) {
                        if (currentBatchSize == 0) break;
                        apd.addPartition(Warehouse.makeSpecFromName(part.getPartitionName()), null);
                        lastBatch.add(part);
                        addMsgs.add(String.format(addMsgFormat, part.getPartitionName()));
                        --currentBatchSize;
                    }
                    db.createPartitions(apd);
                    batchWork.removeAll(lastBatch);
                    repairOutput.addAll(addMsgs);
                }
                return null;
            }
        }.run();
    }

    @VisibleForTesting
    void dropPartitionsInBatches(final Hive db, final List<String> repairOutput, Set<CheckResult.PartitionResult> partsNotInFs, final Table table, int batchSize, int decayingFactor, int maxRetries) throws Exception {
        final String dropMsgFormat = "Repair: Dropped partition from metastore " + table.getFullyQualifiedName() + ":%s";
        final HashSet<CheckResult.PartitionResult> batchWork = new HashSet<CheckResult.PartitionResult>(partsNotInFs);
        new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(batchSize, decayingFactor, maxRetries){

            @Override
            public Void execute(int size) throws Exception {
                while (!batchWork.isEmpty()) {
                    int currentBatchSize = size;
                    ArrayList<CheckResult.PartitionResult> lastBatch = new ArrayList<CheckResult.PartitionResult>(currentBatchSize);
                    ArrayList<String> dropMsgs = new ArrayList<String>(currentBatchSize);
                    ArrayList<String> dropParts = new ArrayList<String>(currentBatchSize);
                    for (CheckResult.PartitionResult part : batchWork) {
                        if (currentBatchSize == 0) break;
                        dropParts.add(part.getPartitionName());
                        lastBatch.add(part);
                        dropMsgs.add(String.format(dropMsgFormat, part.getPartitionName()));
                        --currentBatchSize;
                    }
                    db.dropPartitions(table, dropParts, false, true);
                    batchWork.removeAll(lastBatch);
                    repairOutput.addAll(dropMsgs);
                }
                return null;
            }
        }.run();
    }

    private boolean writeMsckResult(Set<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    private int showPartitions(Hive db, ShowPartitionsDesc showParts) throws HiveException {
        String tabName = showParts.getTabName();
        Table tbl = null;
        List<String> parts = null;
        tbl = db.getTable(tabName);
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tabName);
        }
        parts = showParts.getPartSpec() != null ? db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), showParts.getPartSpec(), (short)-1) : db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), (short)-1);
        DataOutputStream outStream = this.getOutputStream(showParts.getResFile());
        try {
            this.formatter.showTablePartitions(outStream, parts);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "show partitions for table " + tabName);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showCreateDatabase(Hive db, ShowCreateDatabaseDesc showCreateDb) throws HiveException {
        DataOutputStream outStream = this.getOutputStream(showCreateDb.getResFile());
        try {
            String dbName = showCreateDb.getDatabaseName();
            int n = this.showCreateDatabase(db, outStream, dbName);
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
    }

    private int showCreateDatabase(Hive db, DataOutputStream outStream, String databaseName) throws Exception {
        Database database = db.getDatabase(databaseName);
        StringBuilder createDb_str = new StringBuilder();
        createDb_str.append("CREATE DATABASE `").append(database.getName()).append("`\n");
        if (database.getDescription() != null) {
            createDb_str.append("COMMENT\n  '");
            createDb_str.append(HiveStringUtils.escapeHiveCommand(database.getDescription())).append("'\n");
        }
        createDb_str.append("LOCATION\n  '");
        createDb_str.append(database.getLocationUri()).append("'\n");
        String propertiesToString = this.propertiesToString(database.getParameters(), null);
        if (!propertiesToString.isEmpty()) {
            createDb_str.append("WITH DBPROPERTIES (\n");
            createDb_str.append(propertiesToString).append(")\n");
        }
        outStream.write(createDb_str.toString().getBytes("UTF-8"));
        return 0;
    }

    private int showCreateTable(Hive db, ShowCreateTableDesc showCreateTbl) throws HiveException {
        DataOutputStream outStream = this.getOutputStream(showCreateTbl.getResFile());
        try {
            String tableName = showCreateTbl.getTableName();
            int n = this.showCreateTable(db, outStream, tableName);
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
    }

    private int showCreateTable(Hive db, DataOutputStream outStream, String tableName) throws HiveException {
        String EXTERNAL = "external";
        String TEMPORARY = "temporary";
        String LIST_COLUMNS = "columns";
        String TBL_COMMENT = "tbl_comment";
        String LIST_PARTITIONS = "partitions";
        String SORT_BUCKET = "sort_bucket";
        String SKEWED_INFO = "tbl_skewedinfo";
        String ROW_FORMAT = "row_format";
        String TBL_LOCATION = "tbl_location";
        String TBL_PROPERTIES = "tbl_properties";
        boolean needsLocation = true;
        StringBuilder createTab_str = new StringBuilder();
        Table tbl = db.getTable(tableName, false);
        ArrayList<String> duplicateProps = new ArrayList<String>();
        try {
            needsLocation = DDLTask.doesTableNeedLocation(tbl);
            if (tbl.isView()) {
                String createTab_stmt = "CREATE VIEW `" + tableName + "` AS " + tbl.getViewExpandedText();
                outStream.write(createTab_stmt.getBytes(StandardCharsets.UTF_8));
                return 0;
            }
            createTab_str.append("CREATE <temporary><external>TABLE `");
            createTab_str.append(tableName + "`(\n");
            createTab_str.append("<columns>)\n");
            createTab_str.append("<tbl_comment>\n");
            createTab_str.append("<partitions>\n");
            createTab_str.append("<sort_bucket>\n");
            createTab_str.append("<tbl_skewedinfo>\n");
            createTab_str.append("<row_format>\n");
            if (needsLocation) {
                createTab_str.append("LOCATION\n");
                createTab_str.append("<tbl_location>\n");
            }
            createTab_str.append("TBLPROPERTIES (\n");
            createTab_str.append("<tbl_properties>)\n");
            ST createTab_stmt = new ST(createTab_str.toString());
            String tbl_temp = "";
            if (tbl.isTemporary()) {
                duplicateProps.add("TEMPORARY");
                tbl_temp = "TEMPORARY ";
            }
            String tbl_external = "";
            if (tbl.getTableType() == TableType.EXTERNAL_TABLE) {
                duplicateProps.add("EXTERNAL");
                tbl_external = "EXTERNAL ";
            }
            String tbl_columns = "";
            List<FieldSchema> cols = tbl.getCols();
            ArrayList<CallSite> columns = new ArrayList<CallSite>();
            for (FieldSchema col : cols) {
                String columnDesc = "  `" + col.getName() + "` " + col.getType();
                if (col.getComment() != null) {
                    columnDesc = columnDesc + " COMMENT '" + HiveStringUtils.escapeHiveCommand(col.getComment()) + "'";
                }
                columns.add((CallSite)((Object)columnDesc));
            }
            tbl_columns = StringUtils.join(columns, ", \n");
            Object tbl_comment = "";
            String tabComment = tbl.getProperty("comment");
            if (tabComment != null) {
                duplicateProps.add("comment");
                tbl_comment = "COMMENT '" + HiveStringUtils.escapeHiveCommand(tabComment) + "'";
            }
            Object tbl_partitions = "";
            List<FieldSchema> partKeys = tbl.getPartitionKeys();
            if (partKeys.size() > 0) {
                tbl_partitions = (String)tbl_partitions + "PARTITIONED BY ( \n";
                ArrayList<CallSite> partCols = new ArrayList<CallSite>();
                for (FieldSchema partKey : partKeys) {
                    String partColDesc = "  `" + partKey.getName() + "` " + partKey.getType();
                    if (partKey.getComment() != null) {
                        partColDesc = partColDesc + " COMMENT '" + HiveStringUtils.escapeHiveCommand(partKey.getComment()) + "'";
                    }
                    partCols.add((CallSite)((Object)partColDesc));
                }
                tbl_partitions = (String)tbl_partitions + StringUtils.join(partCols, ", \n");
                tbl_partitions = (String)tbl_partitions + ")";
            }
            Object tbl_sort_bucket = "";
            List<String> buckCols = tbl.getBucketCols();
            if (buckCols.size() > 0) {
                duplicateProps.add("SORTBUCKETCOLSPREFIX");
                tbl_sort_bucket = (String)tbl_sort_bucket + "CLUSTERED BY ( \n  ";
                tbl_sort_bucket = (String)tbl_sort_bucket + StringUtils.join(buckCols, ", \n  ");
                tbl_sort_bucket = (String)tbl_sort_bucket + ") \n";
                List<Order> sortCols = tbl.getSortCols();
                if (sortCols.size() > 0) {
                    tbl_sort_bucket = (String)tbl_sort_bucket + "SORTED BY ( \n";
                    ArrayList<CallSite> sortKeys = new ArrayList<CallSite>();
                    for (Order order : sortCols) {
                        String sortKeyDesc = "  " + order.getCol() + " ";
                        if (order.getOrder() == 1) {
                            sortKeyDesc = sortKeyDesc + "ASC";
                        } else if (order.getOrder() == 0) {
                            sortKeyDesc = sortKeyDesc + "DESC";
                        }
                        sortKeys.add((CallSite)((Object)sortKeyDesc));
                    }
                    tbl_sort_bucket = (String)tbl_sort_bucket + StringUtils.join(sortKeys, ", \n");
                    tbl_sort_bucket = (String)tbl_sort_bucket + ") \n";
                }
                tbl_sort_bucket = (String)tbl_sort_bucket + "INTO " + tbl.getNumBuckets() + " BUCKETS";
            }
            StringBuilder tbl_skewedinfo = new StringBuilder();
            SkewedInfo skewedInfo = tbl.getSkewedInfo();
            if (skewedInfo != null && !skewedInfo.getSkewedColNames().isEmpty()) {
                tbl_skewedinfo.append("SKEWED BY (" + StringUtils.join(skewedInfo.getSkewedColNames(), ",") + ")\n");
                tbl_skewedinfo.append("  ON (");
                ArrayList<CallSite> colValueList = new ArrayList<CallSite>();
                for (List<String> colValues : skewedInfo.getSkewedColValues()) {
                    colValueList.add((CallSite)((Object)("('" + StringUtils.join(colValues, "','") + "')")));
                }
                tbl_skewedinfo.append(StringUtils.join(colValueList, ",") + ")");
                if (tbl.isStoredAsSubDirectories()) {
                    tbl_skewedinfo.append("\n  STORED AS DIRECTORIES");
                }
            }
            StringBuilder tbl_row_format = new StringBuilder();
            StorageDescriptor storageDescriptor = tbl.getTTable().getSd();
            SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
            Map<String, String> serdeParams = serdeInfo.getParameters();
            tbl_row_format.append("ROW FORMAT SERDE \n");
            tbl_row_format.append("  '" + HiveStringUtils.escapeHiveCommand(serdeInfo.getSerializationLib()) + "' \n");
            if (tbl.getStorageHandler() == null) {
                if ("1".equals(serdeParams.get("serialization.format"))) {
                    serdeParams.remove("serialization.format");
                }
                if (!serdeParams.isEmpty()) {
                    DDLTask.appendSerdeParams(tbl_row_format, serdeParams).append(" \n");
                }
                tbl_row_format.append("STORED AS INPUTFORMAT \n  '" + HiveStringUtils.escapeHiveCommand(storageDescriptor.getInputFormat()) + "' \n");
                tbl_row_format.append("OUTPUTFORMAT \n  '" + HiveStringUtils.escapeHiveCommand(storageDescriptor.getOutputFormat()) + "'");
            } else {
                duplicateProps.add("storage_handler");
                tbl_row_format.append("STORED BY \n  '" + HiveStringUtils.escapeHiveCommand(tbl.getParameters().get("storage_handler")) + "' \n");
                if (!serdeParams.isEmpty()) {
                    DDLTask.appendSerdeParams(tbl_row_format, serdeInfo.getParameters());
                }
            }
            String tbl_location = "  '" + HiveStringUtils.escapeHiveCommand(storageDescriptor.getLocation()) + "'";
            duplicateProps.addAll(Arrays.asList(StatsSetupConst.TABLE_PARAMS_STATS_KEYS));
            String tbl_properties = this.propertiesToString(tbl.getParameters(), duplicateProps);
            createTab_stmt.add("temporary", (Object)tbl_temp);
            createTab_stmt.add("external", (Object)tbl_external);
            createTab_stmt.add("columns", (Object)tbl_columns);
            createTab_stmt.add("tbl_comment", tbl_comment);
            createTab_stmt.add("partitions", tbl_partitions);
            createTab_stmt.add("sort_bucket", tbl_sort_bucket);
            createTab_stmt.add("tbl_skewedinfo", (Object)tbl_skewedinfo);
            createTab_stmt.add("row_format", (Object)tbl_row_format);
            if (needsLocation) {
                createTab_stmt.add("tbl_location", (Object)tbl_location);
            }
            createTab_stmt.add("tbl_properties", (Object)tbl_properties);
            outStream.write(createTab_stmt.render().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.info("show create table: ", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private String propertiesToString(Map<String, String> props, List<String> exclude) {
        Object prop_string = "";
        if (!props.isEmpty()) {
            TreeMap<String, String> properties = new TreeMap<String, String>(props);
            ArrayList<CallSite> realProps = new ArrayList<CallSite>();
            for (String key : properties.keySet()) {
                if (properties.get(key) == null || exclude != null && exclude.contains(key)) continue;
                realProps.add((CallSite)((Object)("  '" + key + "'='" + HiveStringUtils.escapeHiveCommand((String)properties.get(key)) + "'")));
            }
            prop_string = (String)prop_string + StringUtils.join(realProps, ", \n");
        }
        return prop_string;
    }

    public static StringBuilder appendSerdeParams(StringBuilder builder, Map<String, String> serdeParam) {
        serdeParam = new TreeMap<String, String>(serdeParam);
        builder.append("WITH SERDEPROPERTIES ( \n");
        ArrayList<CallSite> serdeCols = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entry : serdeParam.entrySet()) {
            serdeCols.add((CallSite)((Object)("  '" + entry.getKey() + "'='" + HiveStringUtils.escapeHiveCommand(entry.getValue()) + "'")));
        }
        builder.append(StringUtils.join(serdeCols, ", \n")).append(')');
        return builder;
    }

    private int showDatabases(Hive db, ShowDatabasesDesc showDatabasesDesc) throws HiveException {
        List<String> databases = null;
        if (showDatabasesDesc.getPattern() != null) {
            LOG.info("pattern: {}", (Object)showDatabasesDesc.getPattern());
            databases = db.getDatabasesByPattern(showDatabasesDesc.getPattern());
        } else {
            databases = db.getAllDatabases();
        }
        LOG.info("results : {}", (Object)databases.size());
        DataOutputStream outStream = this.getOutputStream(showDatabasesDesc.getResFile());
        try {
            this.formatter.showDatabases(outStream, databases);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "show databases");
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showTablesOrViews(Hive db, ShowTablesDesc showDesc) throws HiveException {
        List<String> tablesOrViews = null;
        String dbName = showDesc.getDbName();
        String pattern = showDesc.getPattern();
        String resultsFile = showDesc.getResFile();
        TableType type = showDesc.getType();
        if (!db.databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        LOG.debug("pattern: {}", (Object)pattern);
        tablesOrViews = db.getTablesByType(dbName, pattern, type);
        LOG.debug("results : {}", (Object)tablesOrViews.size());
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(resultsFile);
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            TreeSet<String> sortedSet = new TreeSet<String>(tablesOrViews);
            this.formatter.showTables((DataOutputStream)outStream, sortedSet);
            outStream.close();
            outStream = null;
        }
        catch (Exception e) {
            try {
                throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "in database" + dbName);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    public int showColumns(Hive db, ShowColumnsDesc showCols) throws HiveException {
        Table table = db.getTable(showCols.getTableName());
        DataOutputStream outStream = this.getOutputStream(showCols.getResFile());
        try {
            List<FieldSchema> allCols = table.getCols();
            allCols.addAll(table.getPartCols());
            List<FieldSchema> cols = this.getColumnsByPattern(allCols, showCols.getPattern());
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            TextMetaDataTable tmd = new TextMetaDataTable();
            for (FieldSchema fieldSchema : cols) {
                tmd.addRow(MetaDataFormatUtils.extractColumnValues(fieldSchema));
            }
            outStream.writeBytes(tmd.renderTable(isOutputPadded));
        }
        catch (IOException e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private List<FieldSchema> getColumnsByPattern(List<FieldSchema> cols, String columnPattern) {
        if (columnPattern == null) {
            columnPattern = "*";
        }
        columnPattern = columnPattern.toLowerCase();
        columnPattern = columnPattern.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(columnPattern);
        Matcher matcher = pattern.matcher("");
        TreeSet<FieldSchema> sortedCol = new TreeSet<FieldSchema>(new Comparator<FieldSchema>(){

            @Override
            public int compare(FieldSchema f1, FieldSchema f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (FieldSchema column : cols) {
            matcher.reset(column.getName());
            if (!matcher.matches()) continue;
            sortedCol.add(column);
        }
        return new ArrayList<FieldSchema>(sortedCol);
    }

    private int showFunctions(Hive db, ShowFunctionsDesc showFuncs) throws HiveException {
        Set<String> funcs = null;
        if (showFuncs.getPattern() != null) {
            LOG.info("pattern: {}", (Object)showFuncs.getPattern());
            if (showFuncs.getIsLikePattern()) {
                funcs = FunctionRegistry.getFunctionNamesByLikePattern(showFuncs.getPattern());
            } else {
                this.console.printInfo("SHOW FUNCTIONS is deprecated, please use SHOW FUNCTIONS LIKE instead.");
                funcs = FunctionRegistry.getFunctionNames(showFuncs.getPattern());
            }
            LOG.info("results : {}", (Object)funcs.size());
        } else {
            funcs = FunctionRegistry.getFunctionNames();
        }
        DataOutputStream outStream = this.getOutputStream(showFuncs.getResFile());
        try {
            TreeSet<String> sortedFuncs = new TreeSet<String>(funcs);
            sortedFuncs.removeAll(serdeConstants.PrimitiveTypes);
            Iterator iterFuncs = sortedFuncs.iterator();
            while (iterFuncs.hasNext()) {
                outStream.writeBytes((String)iterFuncs.next());
                outStream.write(10);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("show function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showLocks(Hive db, ShowLocksDesc showLocks) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (txnManager.useNewShowLocksFormat()) {
            return this.showLocksNewFormat(showLocks, lockMgr);
        }
        boolean isExt = showLocks.isExt();
        if (lockMgr == null) {
            throw new HiveException("show Locks LockManager not specified");
        }
        DataOutputStream outStream = this.getOutputStream(showLocks.getResFile());
        try {
            List<HiveLock> locks = null;
            locks = showLocks.getTableName() == null ? lockMgr.getLocks(false, isExt) : lockMgr.getLocks(HiveLockObject.createFrom(db, showLocks.getTableName(), showLocks.getPartSpec()), true, isExt);
            Collections.sort(locks, new Comparator<HiveLock>(){

                @Override
                public int compare(HiveLock o1, HiveLock o2) {
                    int cmp = o1.getHiveLockObject().getName().compareTo(o2.getHiveLockObject().getName());
                    if (cmp == 0) {
                        if (o1.getHiveLockMode() == o2.getHiveLockMode()) {
                            return cmp;
                        }
                        if (o1.getHiveLockMode() == HiveLockMode.EXCLUSIVE) {
                            return -1;
                        }
                        return 1;
                    }
                    return cmp;
                }
            });
            for (HiveLock lock2 : locks) {
                HiveLockObject.HiveLockObjectData lockData;
                outStream.writeBytes(lock2.getHiveLockObject().getDisplayName());
                outStream.write(9);
                outStream.writeBytes(lock2.getHiveLockMode().toString());
                if (isExt && (lockData = lock2.getHiveLockObject().getData()) != null) {
                    outStream.write(10);
                    outStream.writeBytes("LOCK_QUERYID:" + lockData.getQueryId());
                    outStream.write(10);
                    outStream.writeBytes("LOCK_TIME:" + lockData.getLockTime());
                    outStream.write(10);
                    outStream.writeBytes("LOCK_MODE:" + lockData.getLockMode());
                    outStream.write(10);
                    outStream.writeBytes("LOCK_QUERYSTRING:" + lockData.getQueryStr());
                }
                outStream.write(10);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("show function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e.toString(), e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    public static void dumpLockInfo(DataOutputStream os, ShowLocksResponse rsp) throws IOException {
        os.writeBytes("Lock ID");
        os.write(9);
        os.writeBytes("Database");
        os.write(9);
        os.writeBytes("Table");
        os.write(9);
        os.writeBytes("Partition");
        os.write(9);
        os.writeBytes("State");
        os.write(9);
        os.writeBytes("Blocked By");
        os.write(9);
        os.writeBytes("Type");
        os.write(9);
        os.writeBytes("Transaction ID");
        os.write(9);
        os.writeBytes("Last Heartbeat");
        os.write(9);
        os.writeBytes("Acquired At");
        os.write(9);
        os.writeBytes("User");
        os.write(9);
        os.writeBytes("Hostname");
        os.write(9);
        os.writeBytes("Agent Info");
        os.write(10);
        List<ShowLocksResponseElement> locks = rsp.getLocks();
        if (locks != null) {
            for (ShowLocksResponseElement lock2 : locks) {
                if (lock2.isSetLockIdInternal()) {
                    os.writeBytes(Long.toString(lock2.getLockid()) + "." + Long.toString(lock2.getLockIdInternal()));
                } else {
                    os.writeBytes(Long.toString(lock2.getLockid()));
                }
                os.write(9);
                os.writeBytes(lock2.getDbname());
                os.write(9);
                os.writeBytes(lock2.getTablename() == null ? "NULL" : lock2.getTablename());
                os.write(9);
                os.writeBytes(lock2.getPartname() == null ? "NULL" : lock2.getPartname());
                os.write(9);
                os.writeBytes(lock2.getState().toString());
                os.write(9);
                if (lock2.isSetBlockedByExtId()) {
                    os.writeBytes(Long.toString(lock2.getBlockedByExtId()) + "." + Long.toString(lock2.getBlockedByIntId()));
                } else {
                    os.writeBytes("            ");
                }
                os.write(9);
                os.writeBytes(lock2.getType().toString());
                os.write(9);
                os.writeBytes(lock2.getTxnid() == 0L ? "NULL" : Long.toString(lock2.getTxnid()));
                os.write(9);
                os.writeBytes(Long.toString(lock2.getLastheartbeat()));
                os.write(9);
                os.writeBytes(lock2.getAcquiredat() == 0L ? "NULL" : Long.toString(lock2.getAcquiredat()));
                os.write(9);
                os.writeBytes(lock2.getUser());
                os.write(9);
                os.writeBytes(lock2.getHostname());
                os.write(9);
                os.writeBytes(lock2.getAgentInfo() == null ? "NULL" : lock2.getAgentInfo());
                os.write(9);
                os.write(10);
            }
        }
    }

    private int showLocksNewFormat(ShowLocksDesc showLocks, HiveLockManager lm) throws HiveException {
        if (!(lm instanceof DbLockManager)) {
            throw new RuntimeException("New lock format only supported with db lock manager.");
        }
        DbLockManager lockMgr = (DbLockManager)lm;
        String dbName = showLocks.getDbName();
        String tblName = showLocks.getTableName();
        HashMap<String, String> partSpec = showLocks.getPartSpec();
        if (dbName == null && tblName != null) {
            dbName = SessionState.get().getCurrentDatabase();
        }
        ShowLocksRequest rqst = new ShowLocksRequest();
        rqst.setDbname(dbName);
        rqst.setTablename(tblName);
        if (partSpec != null) {
            ArrayList<String> keyList = new ArrayList<String>();
            ArrayList<String> valList = new ArrayList<String>();
            for (String partKey : partSpec.keySet()) {
                String partVal = (String)partSpec.remove(partKey);
                keyList.add(partKey);
                valList.add(partVal);
            }
            String partName = FileUtils.makePartName(keyList, valList);
            rqst.setPartname(partName);
        }
        ShowLocksResponse rsp = lockMgr.getLocks(rqst);
        DataOutputStream os = this.getOutputStream(showLocks.getResFile());
        try {
            DDLTask.dumpLockInfo(os, rsp);
        }
        catch (FileNotFoundException e) {
            LOG.warn("show function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        finally {
            IOUtils.closeStream((Closeable)os);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showCompactions(Hive db, ShowCompactionsDesc desc) throws HiveException {
        ShowCompactResponse rsp = db.showCompactions();
        String noVal = " --- ";
        DataOutputStream os = this.getOutputStream(desc.getResFile());
        try {
            os.writeBytes("CompactionId");
            os.write(9);
            os.writeBytes("Database");
            os.write(9);
            os.writeBytes("Table");
            os.write(9);
            os.writeBytes("Partition");
            os.write(9);
            os.writeBytes("Type");
            os.write(9);
            os.writeBytes("State");
            os.write(9);
            os.writeBytes("Worker");
            os.write(9);
            os.writeBytes("Start Time");
            os.write(9);
            os.writeBytes("Duration(ms)");
            os.write(9);
            os.writeBytes("HadoopJobId");
            os.write(10);
            if (rsp.getCompacts() != null) {
                for (ShowCompactResponseElement e : rsp.getCompacts()) {
                    os.writeBytes(Long.toString(e.getId()));
                    os.write(9);
                    os.writeBytes(e.getDbname());
                    os.write(9);
                    os.writeBytes(e.getTablename());
                    os.write(9);
                    String part = e.getPartitionname();
                    os.writeBytes(part == null ? " --- " : part);
                    os.write(9);
                    os.writeBytes(e.getType().toString());
                    os.write(9);
                    os.writeBytes(e.getState());
                    os.write(9);
                    String wid = e.getWorkerid();
                    os.writeBytes(wid == null ? " --- " : wid);
                    os.write(9);
                    os.writeBytes(e.isSetStart() ? Long.toString(e.getStart()) : " --- ");
                    os.write(9);
                    os.writeBytes(e.isSetEndTime() ? Long.toString(e.getEndTime() - e.getStart()) : " --- ");
                    os.write(9);
                    os.writeBytes(e.isSetHadoopJobId() ? e.getHadoopJobId() : " --- ");
                    os.write(10);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("show compactions: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)os);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showTxns(Hive db, ShowTxnsDesc desc) throws HiveException {
        GetOpenTxnsInfoResponse rsp = db.showTransactions();
        DataOutputStream os = this.getOutputStream(desc.getResFile());
        try {
            os.writeBytes("Transaction ID");
            os.write(9);
            os.writeBytes("Transaction State");
            os.write(9);
            os.writeBytes("Started Time");
            os.write(9);
            os.writeBytes("Last Heartbeat Time");
            os.write(9);
            os.writeBytes("User");
            os.write(9);
            os.writeBytes("Hostname");
            os.write(10);
            for (TxnInfo txn : rsp.getOpen_txns()) {
                os.writeBytes(Long.toString(txn.getId()));
                os.write(9);
                os.writeBytes(txn.getState().toString());
                os.write(9);
                os.writeBytes(Long.toString(txn.getStartedTime()));
                os.write(9);
                os.writeBytes(Long.toString(txn.getLastHeartbeatTime()));
                os.write(9);
                os.writeBytes(txn.getUser());
                os.write(9);
                os.writeBytes(txn.getHostname());
                os.write(10);
            }
        }
        catch (IOException e) {
            LOG.warn("show transactions: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)os);
        }
        return 0;
    }

    private int abortTxns(Hive db, AbortTxnsDesc desc) throws HiveException {
        db.abortTransactions(desc.getTxnids());
        return 0;
    }

    private int killQuery(Hive db, KillQueryDesc desc) throws HiveException {
        SessionState sessionState = SessionState.get();
        for (String queryId : desc.getQueryIds()) {
            sessionState.getKillQuery().killQuery(queryId, "User invoked KILL QUERY");
        }
        LOG.info("kill query called ({})", desc.getQueryIds());
        return 0;
    }

    private int lockTable(Hive db, LockTableDesc lockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.lockTable(db, lockTbl);
    }

    private int lockDatabase(Hive db, LockDatabaseDesc lockDb) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.lockDatabase(db, lockDb);
    }

    private int unlockDatabase(Hive db, UnlockDatabaseDesc unlockDb) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.unlockDatabase(db, unlockDb);
    }

    private int unlockTable(Hive db, UnlockTableDesc unlockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.unlockTable(db, unlockTbl);
    }

    private int describeFunction(Hive db, DescFunctionDesc descFunc) throws HiveException, SQLException {
        String funcName = descFunc.getName();
        DataOutputStream outStream = this.getOutputStream(descFunc.getResFile());
        try {
            Description desc = null;
            Class<?> funcClass = null;
            FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(funcName);
            if (functionInfo != null) {
                funcClass = functionInfo.getFunctionClass();
            }
            if (funcClass != null) {
                desc = AnnotationUtils.getAnnotation(funcClass, Description.class);
            }
            if (desc != null) {
                outStream.writeBytes(desc.value().replace("_FUNC_", funcName));
                if (descFunc.isExtended()) {
                    Set<String> synonyms = FunctionRegistry.getFunctionSynonyms(funcName);
                    if (synonyms.size() > 0) {
                        outStream.writeBytes("\nSynonyms: " + StringUtils.join(synonyms, ", "));
                    }
                    if (desc.extended().length() > 0) {
                        outStream.writeBytes("\n" + desc.extended().replace("_FUNC_", funcName));
                    }
                }
            } else if (funcClass != null) {
                outStream.writeBytes("There is no documentation for function '" + funcName + "'");
            } else {
                outStream.writeBytes("Function '" + funcName + "' does not exist.");
            }
            outStream.write(10);
            if (descFunc.isExtended()) {
                if (funcClass != null) {
                    outStream.writeBytes("Function class:" + funcClass.getName() + "\n");
                }
                if (functionInfo != null) {
                    outStream.writeBytes("Function type:" + functionInfo.getFunctionType() + "\n");
                    FunctionInfo.FunctionResource[] resources = functionInfo.getResources();
                    if (resources != null) {
                        for (FunctionInfo.FunctionResource resource : resources) {
                            outStream.writeBytes("Resource:" + resource.getResourceURI() + "\n");
                        }
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("describe function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("describe function: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int descDatabase(Hive db, DescDatabaseDesc descDatabase) throws HiveException {
        DataOutputStream outStream = this.getOutputStream(descDatabase.getResFile());
        try {
            Database database = db.getDatabase(descDatabase.getDatabaseName());
            if (database == null) {
                throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, descDatabase.getDatabaseName());
            }
            Map<String, String> params = null;
            if (descDatabase.isExt()) {
                params = database.getParameters();
            }
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST) && params != null) {
                params = new TreeMap<String, String>(params);
            }
            String location = database.getLocationUri();
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST)) {
                location = "location/in/test";
            }
            PrincipalType ownerType = database.getOwnerType();
            this.formatter.showDatabaseDescription(outStream, database.getName(), database.getDescription(), location, database.getOwnerName(), null == ownerType ? null : ownerType.name(), params);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showTableStatus(Hive db, ShowTableStatusDesc showTblStatus) throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        HashMap<String, String> part = showTblStatus.getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = db.getTable(showTblStatus.getDbName(), showTblStatus.getPattern());
            par = db.getPartition(tbl, part, false);
            if (par == null) {
                throw new HiveException("Partition " + part + " for table " + showTblStatus.getPattern() + " does not exist.");
            }
            tbls.add(tbl);
        } else {
            LOG.info("pattern: {}", (Object)showTblStatus.getPattern());
            List<String> tblStr = db.getTablesForDb(showTblStatus.getDbName(), showTblStatus.getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = db.getTable(showTblStatus.getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info("results : {}", (Object)tblStr.size());
        }
        DataOutputStream outStream = this.getOutputStream(showTblStatus.getResFile());
        try {
            this.formatter.showTableStatus(outStream, db, this.conf, tbls, part, par);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "show table status");
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showTableProperties(Hive db, ShowTblPropertiesDesc showTblPrpt) throws HiveException {
        String tableName = showTblPrpt.getTableName();
        Table tbl = db.getTable(tableName, false);
        try {
            if (tbl == null) {
                String errMsg = "Table " + tableName + " does not exist";
                this.writeToFile(errMsg, showTblPrpt.getResFile());
                return 0;
            }
            LOG.info("DDLTask: show properties for {}", (Object)tableName);
            StringBuilder builder = new StringBuilder();
            String propertyName = showTblPrpt.getPropertyName();
            if (propertyName != null) {
                String propertyValue = tbl.getProperty(propertyName);
                if (propertyValue == null) {
                    String errMsg = "Table " + tableName + " does not have property: " + propertyName;
                    builder.append(errMsg);
                } else {
                    builder.append(propertyValue);
                }
            } else {
                TreeMap<String, String> properties = new TreeMap<String, String>(tbl.getParameters());
                for (Map.Entry entry : properties.entrySet()) {
                    DDLTask.appendNonNull(builder, entry.getKey(), true);
                    DDLTask.appendNonNull(builder, entry.getValue());
                }
            }
            LOG.info("DDLTask: written data for showing properties of {}", (Object)tableName);
            this.writeToFile(builder.toString(), showTblPrpt.getResFile());
        }
        catch (FileNotFoundException e) {
            LOG.info("show table properties: ", (Throwable)e);
            return 1;
        }
        catch (IOException e) {
            LOG.info("show table properties: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String data, String file) throws IOException {
        Path resFile = new Path(file);
        FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
        FSDataOutputStream out = fs.create(resFile);
        try {
            if (data != null && !data.isEmpty()) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write(data);
                writer.write(10);
                writer.flush();
            }
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }

    private int describeTable(Hive db, DescTableDesc descTbl) throws HiveException, MetaException {
        String colPath = descTbl.getColumnPath();
        String tableName = descTbl.getTableName();
        Table tbl = db.getTable(tableName, false);
        if (tbl == null) {
            throw new HiveException(ErrorMsg.INVALID_TABLE, tableName);
        }
        Partition part = null;
        if (descTbl.getPartSpec() != null) {
            part = db.getPartition(tbl, descTbl.getPartSpec(), false);
            if (part == null) {
                throw new HiveException(ErrorMsg.INVALID_PARTITION, StringUtils.join(descTbl.getPartSpec().keySet(), ','), tableName);
            }
            tbl = part.getTable();
        }
        DataOutputStream outStream = this.getOutputStream(descTbl.getResFile());
        try {
            Iterable<String> parts;
            String errorMsgs;
            LOG.debug("DDLTask: got data for {}", (Object)tableName);
            List<FieldSchema> cols = null;
            List<ColumnStatisticsObj> colStats = null;
            Deserializer deserializer = tbl.getDeserializer(true);
            if (deserializer instanceof AbstractSerDe && (errorMsgs = ((AbstractSerDe)deserializer).getConfigurationErrors()) != null && !errorMsgs.isEmpty()) {
                throw new SQLException(errorMsgs);
            }
            if (colPath.equals(tableName)) {
                List<FieldSchema> list = cols = part == null || tbl.getTableType() == TableType.VIRTUAL_VIEW ? tbl.getCols() : part.getCols();
                if (!descTbl.isFormatted()) {
                    cols.addAll(tbl.getPartCols());
                }
                if (descTbl.isExt() || descTbl.isFormatted()) {
                    boolean disablePartitionStats = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_DESCRIBE_PARTITIONED_TABLE_IGNORE_STATS);
                    if (tbl.isPartitioned() && part == null && !disablePartitionStats) {
                        Map<Object, Object> tblProps = tbl.getParameters() == null ? new HashMap() : tbl.getParameters();
                        HashMap<String, Long> valueMap = new HashMap<String, Long>();
                        HashMap<String, Boolean> stateMap = new HashMap<String, Boolean>();
                        for (String string : StatsSetupConst.supportedStats) {
                            valueMap.put(string, 0L);
                            stateMap.put(string, true);
                        }
                        parts = new PartitionIterable(db, tbl, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
                        int numParts = 0;
                        for (Partition partition : parts) {
                            Map<String, String> props = partition.getParameters();
                            Boolean state = StatsSetupConst.areBasicStatsUptoDate(props);
                            for (String stat : StatsSetupConst.supportedStats) {
                                stateMap.put(stat, (Boolean)stateMap.get(stat) != false && state != false);
                                if (props == null || props.get(stat) == null) continue;
                                valueMap.put(stat, (Long)valueMap.get(stat) + Long.parseLong(props.get(stat)));
                            }
                            ++numParts;
                        }
                        for (String stat : StatsSetupConst.supportedStats) {
                            StatsSetupConst.setBasicStatsState(tblProps, Boolean.toString((Boolean)stateMap.get(stat)));
                            tblProps.put(stat, ((Long)valueMap.get(stat)).toString());
                        }
                        tblProps.put("numPartitions", Integer.toString(numParts));
                        tbl.setParameters(tblProps);
                    }
                }
            } else if (descTbl.isFormatted()) {
                String colName = colPath.split("\\.")[1];
                String[] dbTab = Utilities.getDbTableName(tableName);
                ArrayList<String> colNames = new ArrayList<String>();
                colNames.add(colName.toLowerCase());
                if (null == part) {
                    if (tbl.isPartitioned()) {
                        HashMap<String, String> tblProps;
                        Map<Object, Object> map = tblProps = tbl.getParameters() == null ? new HashMap() : tbl.getParameters();
                        if (tbl.isPartitionKey((String)colNames.get(0))) {
                            FieldSchema partCol = tbl.getPartColByName((String)colNames.get(0));
                            cols = Collections.singletonList(partCol);
                            PartitionIterable parts2 = new PartitionIterable(db, tbl, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
                            ColumnInfo ci = new ColumnInfo(partCol.getName(), TypeInfoUtils.getTypeInfoFromTypeString(partCol.getType()), null, false);
                            ColStatistics colStatistics = StatsUtils.getColStatsForPartCol(ci, parts2, this.conf);
                            ColumnStatisticsData data = new ColumnStatisticsData();
                            ColStatistics.Range r = colStatistics.getRange();
                            StatObjectConverter.fillColumnStatisticsData(partCol.getType(), data, r == null ? (Number)null : (Number)r.minValue, r == null ? (Number)null : (Number)r.maxValue, r == null ? (Number)null : (Number)r.minValue, r == null ? (Number)null : (Number)r.maxValue, r == null ? null : r.minValue.toString(), r == null ? null : r.maxValue.toString(), colStatistics.getNumNulls(), colStatistics.getCountDistint(), null, colStatistics.getAvgColLen(), colStatistics.getAvgColLen(), colStatistics.getNumTrues(), colStatistics.getNumFalses());
                            ColumnStatisticsObj cso = new ColumnStatisticsObj(partCol.getName(), partCol.getType(), data);
                            colStats = Collections.singletonList(cso);
                            StatsSetupConst.setColumnStatsState(tblProps, colNames);
                        } else {
                            cols = Hive.getFieldsFromDeserializer(colPath, deserializer);
                            parts = db.getPartitionNames(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), (short)-1);
                            AggrStats aggrStats = db.getAggrColStatsFor(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), (List<String>)colNames, (List<String>)parts);
                            colStats = aggrStats.getColStats();
                            if ((long)parts.size() == aggrStats.getPartsFound()) {
                                StatsSetupConst.setColumnStatsState(tblProps, colNames);
                            } else {
                                StatsSetupConst.removeColumnStatsState(tblProps, colNames);
                            }
                        }
                        tbl.setParameters(tblProps);
                    } else {
                        cols = Hive.getFieldsFromDeserializer(colPath, deserializer);
                        colStats = db.getTableColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), colNames);
                    }
                } else {
                    ArrayList<String> partitions = new ArrayList<String>();
                    partitions.add(part.getName());
                    cols = Hive.getFieldsFromDeserializer(colPath, deserializer);
                    colStats = db.getPartitionColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), partitions, colNames).get(part.getName());
                }
            } else {
                cols = Hive.getFieldsFromDeserializer(colPath, deserializer);
            }
            PrimaryKeyInfo pkInfo = null;
            ForeignKeyInfo fkInfo = null;
            UniqueConstraint ukInfo = null;
            NotNullConstraint nnInfo = null;
            DefaultConstraint dInfo = null;
            CheckConstraint cInfo = null;
            StorageHandlerInfo storageHandlerInfo = null;
            if (descTbl.isExt() || descTbl.isFormatted()) {
                pkInfo = db.getPrimaryKeys(tbl.getDbName(), tbl.getTableName());
                fkInfo = db.getForeignKeys(tbl.getDbName(), tbl.getTableName());
                ukInfo = db.getUniqueConstraints(tbl.getDbName(), tbl.getTableName());
                nnInfo = db.getNotNullConstraints(tbl.getDbName(), tbl.getTableName());
                dInfo = db.getDefaultConstraints(tbl.getDbName(), tbl.getTableName());
                cInfo = db.getCheckConstraints(tbl.getDbName(), tbl.getTableName());
                storageHandlerInfo = db.getStorageHandlerInfo(tbl);
            }
            DDLTask.fixDecimalColumnTypeName(cols);
            boolean bl = !SessionState.get().isHiveServerQuery();
            this.formatter.describeTable(outStream, colPath, tableName, tbl, part, cols, descTbl.isFormatted(), descTbl.isExt(), bl, colStats, pkInfo, fkInfo, ukInfo, nnInfo, dInfo, cInfo, storageHandlerInfo);
            LOG.debug("DDLTask: written data for {}", (Object)tableName);
        }
        catch (SQLException e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, tableName);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private static void fixDecimalColumnTypeName(List<FieldSchema> cols) {
        for (FieldSchema col : cols) {
            if (!"decimal".equals(col.getType())) continue;
            col.setType(DecimalTypeInfo.getQualifiedName(10, 0));
        }
    }

    static String writeGrantInfo(List<HivePrivilegeInfo> privileges, boolean testMode) {
        if (privileges == null || privileges.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(privileges, new Comparator<HivePrivilegeInfo>(){

            @Override
            public int compare(HivePrivilegeInfo o1, HivePrivilegeInfo o2) {
                int compare = o1.getObject().compareTo(o2.getObject());
                if (compare == 0) {
                    compare = o1.getPrincipal().compareTo(o2.getPrincipal());
                }
                if (compare == 0) {
                    compare = o1.getPrivilege().compareTo(o2.getPrivilege());
                }
                return compare;
            }
        });
        for (HivePrivilegeInfo privilege : privileges) {
            HivePrincipal principal = privilege.getPrincipal();
            HivePrivilegeObject resource = privilege.getObject();
            HivePrincipal grantor = privilege.getGrantorPrincipal();
            DDLTask.appendNonNull(builder, resource.getDbname(), true);
            DDLTask.appendNonNull(builder, resource.getObjectName());
            DDLTask.appendNonNull(builder, resource.getPartKeys());
            DDLTask.appendNonNull(builder, resource.getColumns());
            DDLTask.appendNonNull(builder, principal.getName());
            DDLTask.appendNonNull(builder, (Object)principal.getType());
            DDLTask.appendNonNull(builder, privilege.getPrivilege().getName());
            DDLTask.appendNonNull(builder, privilege.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)privilege.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, grantor.getName());
        }
        return builder.toString();
    }

    static String writeRoleGrantsInfo(List<RolePrincipalGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (RolePrincipalGrant roleGrant : roleGrants) {
            DDLTask.appendNonNull(builder, roleGrant.getRoleName(), true);
            DDLTask.appendNonNull(builder, roleGrant.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, roleGrant.getGrantorName());
        }
        return builder.toString();
    }

    static String writeRolesGrantedInfo(List<HiveRoleGrant> roles, boolean testMode) {
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roles);
        for (HiveRoleGrant role : roles) {
            DDLTask.appendNonNull(builder, role.getRoleName(), true);
            DDLTask.appendNonNull(builder, role.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)role.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, role.getGrantor());
        }
        return builder.toString();
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value) {
        return DDLTask.appendNonNull(builder, value, false);
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value, boolean firstColumn) {
        if (!firstColumn) {
            builder.append('\t');
        } else if (builder.length() > 0) {
            builder.append('\n');
        }
        if (value != null) {
            builder.append(value);
        }
        return builder;
    }

    private int alterTable(Hive db, AlterTableDesc alterTbl) throws HiveException {
        String[] names;
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME && Utils.isBootstrapDumpInProgress(db, (names = Utilities.getDbTableName(alterTbl.getOldName()))[0])) {
            LOG.error("DDLTask: Rename Table not allowed as bootstrap dump in progress");
            throw new HiveException("Rename Table: Not allowed as bootstrap dump in progress");
        }
        Table tbl = db.getTable(alterTbl.getOldName());
        List<Object> allPartitions = null;
        if (alterTbl.getPartSpec() != null) {
            HashMap<String, String> partSpec = alterTbl.getPartSpec();
            if (DDLSemanticAnalyzer.isFullSpec(tbl, partSpec)) {
                allPartitions = new ArrayList();
                Partition part = db.getPartition(tbl, partSpec, false);
                if (part == null) {
                    throw new HiveException(ErrorMsg.INVALID_PARTITION, StringUtils.join(alterTbl.getPartSpec().keySet(), ',') + " for table " + alterTbl.getOldName());
                }
                allPartitions.add(part);
            } else {
                allPartitions = db.getPartitions(tbl, alterTbl.getPartSpec());
            }
        }
        Table oldTbl = tbl;
        tbl = oldTbl.copy();
        if (allPartitions != null) {
            for (Partition partition : allPartitions) {
                this.addChildTasks(this.alterTableOrSinglePartition(alterTbl, tbl, partition));
            }
        } else {
            this.addChildTasks(this.alterTableOrSinglePartition(alterTbl, tbl, null));
        }
        if (allPartitions == null) {
            this.updateModifiedParameters(tbl.getTTable().getParameters(), this.conf);
            tbl.checkValidity(this.conf);
        } else {
            for (Partition partition : allPartitions) {
                this.updateModifiedParameters(partition.getParameters(), this.conf);
            }
        }
        try {
            EnvironmentContext environmentContext = alterTbl.getEnvironmentContext();
            if (environmentContext == null) {
                environmentContext = new EnvironmentContext();
            }
            environmentContext.putToProperties("alterTableOpType", alterTbl.getOp().name());
            if (allPartitions == null) {
                db.alterTable(alterTbl.getOldName(), tbl, alterTbl.getIsCascade(), environmentContext);
            } else {
                db.alterPartitions(Warehouse.getQualifiedName(tbl.getTTable()), allPartitions, environmentContext);
            }
            this.addConstraints(db, alterTbl);
        }
        catch (InvalidOperationException e) {
            LOG.error("alter table: ", (Throwable)e);
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        if (allPartitions != null) {
            for (Partition partition : allPartitions) {
                ((DDLWork)this.work).getInputs().add(new ReadEntity(partition));
                this.addIfAbsentByName(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK));
            }
        } else {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
            this.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    static boolean addIfAbsentByName(WriteEntity newWriteEntity, Set<WriteEntity> outputs) {
        for (WriteEntity writeEntity : outputs) {
            if (!writeEntity.getName().equalsIgnoreCase(newWriteEntity.getName())) continue;
            LOG.debug("Ignoring request to add {} because {} is present", (Object)newWriteEntity.toStringDetail(), (Object)writeEntity.toStringDetail());
            return false;
        }
        outputs.add(newWriteEntity);
        return true;
    }

    private boolean addIfAbsentByName(WriteEntity newWriteEntity) {
        return DDLTask.addIfAbsentByName(newWriteEntity, ((DDLWork)this.work).getOutputs());
    }

    private void addChildTasks(List<Task<?>> extraTasks) {
        if (extraTasks == null) {
            return;
        }
        for (Task<?> newTask : extraTasks) {
            this.addDependentTask(newTask);
        }
    }

    private boolean isSchemaEvolutionEnabled(Table tbl) {
        boolean isAcid = AcidUtils.isTablePropertyTransactional(tbl.getMetadata());
        return isAcid || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
    }

    private static StorageDescriptor retrieveStorageDescriptor(Table tbl, Partition part) {
        return part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
    }

    private List<Task<?>> alterTableOrSinglePartition(AlterTableDesc alterTbl, Table tbl, Partition part) throws HiveException {
        EnvironmentContext environmentContext = alterTbl.getEnvironmentContext();
        if (environmentContext == null) {
            environmentContext = new EnvironmentContext();
            alterTbl.setEnvironmentContext(environmentContext);
        }
        if (environmentContext.getProperties() == null || environmentContext.getProperties().get("DO_NOT_UPDATE_STATS") == null) {
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME) {
            tbl.setDbName(Utilities.getDatabaseName(alterTbl.getNewName()));
            tbl.setTableName(Utilities.getTableName(alterTbl.getNewName()));
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCOLS) {
            StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            AvroSerdeUtils.handleAlterTableForAvro(this.conf, serializationLib, tbl.getTTable().getParameters());
            List<FieldSchema> oldCols = part == null ? tbl.getColsForMetastore() : part.getColsForMetastore();
            ArrayList<FieldSchema> newCols = alterTbl.getNewCols();
            if (serializationLib.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
                sd.setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newColName);
                    }
                    oldCols.add(newCol);
                }
                sd.setCols(oldCols);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAMECOLUMN) {
            boolean isOrcSchemaEvolution;
            StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            AvroSerdeUtils.handleAlterTableForAvro(this.conf, serializationLib, tbl.getTTable().getParameters());
            List<FieldSchema> oldCols = part == null ? tbl.getColsForMetastore() : part.getColsForMetastore();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            boolean bl = isOrcSchemaEvolution = sd.getInputFormat().equals(OrcInputFormat.class.getName()) && this.isSchemaEvolutionEnabled(tbl);
            if (isOrcSchemaEvolution && (first || afterCol != null && !afterCol.trim().isEmpty())) {
                throw new HiveException(ErrorMsg.CANNOT_REORDER_COLUMNS, alterTbl.getOldName());
            }
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newName);
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                throw new HiveException(ErrorMsg.INVALID_COLUMN, oldName);
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                throw new HiveException(ErrorMsg.INVALID_COLUMN, afterCol);
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            sd.setCols(newCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.REPLACECOLS) {
            boolean droppingColumns;
            boolean isOrcSchemaEvolution;
            StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            if (serializationLib.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(serializationLib.equals(MetadataTypedColumnsetSerDe.class.getName()) || serializationLib.equals(LazySimpleSerDe.class.getName()) || serializationLib.equals(ColumnarSerDe.class.getName()) || serializationLib.equals(DynamicSerDe.class.getName()) || serializationLib.equals(ParquetHiveSerDe.class.getName()) || serializationLib.equals(OrcSerde.class.getName()))) {
                throw new HiveException(ErrorMsg.CANNOT_REPLACE_COLUMNS, alterTbl.getOldName());
            }
            boolean bl = isOrcSchemaEvolution = serializationLib.equals(OrcSerde.class.getName()) && this.isSchemaEvolutionEnabled(tbl);
            if (isOrcSchemaEvolution) {
                List<FieldSchema> existingCols = sd.getCols();
                ArrayList<FieldSchema> replaceCols = alterTbl.getNewCols();
                if (replaceCols.size() < existingCols.size()) {
                    throw new HiveException(ErrorMsg.REPLACE_CANNOT_DROP_COLUMNS, alterTbl.getOldName());
                }
            }
            boolean partitioned = tbl.isPartitioned();
            boolean bl2 = droppingColumns = alterTbl.getNewCols().size() < sd.getCols().size();
            if (ParquetHiveSerDe.isParquetTable(tbl) && this.isSchemaEvolutionEnabled(tbl) && !alterTbl.getIsCascade() && droppingColumns && partitioned) {
                LOG.warn("Cannot drop columns from a partitioned parquet table without the CASCADE option");
                throw new HiveException(ErrorMsg.REPLACE_CANNOT_DROP_COLUMNS, alterTbl.getOldName());
            }
            sd.setCols(alterTbl.getNewCols());
        } else {
            if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDPROPS) {
                return this.alterTableAddProps(alterTbl, tbl, part, environmentContext);
            }
            if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.DROPPROPS) {
                return this.alterTableDropProps(alterTbl, tbl, part, environmentContext);
            }
            if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDEPROPS) {
                StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
                sd.getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDE) {
                StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
                String serdeName = alterTbl.getSerdeName();
                String oldSerdeName = sd.getSerdeInfo().getSerializationLib();
                if (this.isSchemaEvolutionEnabled(tbl) && oldSerdeName.equalsIgnoreCase(OrcSerde.class.getName()) && !serdeName.equalsIgnoreCase(OrcSerde.class.getName())) {
                    throw new HiveException(ErrorMsg.CANNOT_CHANGE_SERDE, OrcSerde.class.getSimpleName(), alterTbl.getOldName());
                }
                sd.getSerdeInfo().setSerializationLib(serdeName);
                if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                    sd.getSerdeInfo().getParameters().putAll(alterTbl.getProps());
                }
                if (part != null) {
                    part.getTPartition().getSd().setCols(part.getTPartition().getSd().getCols());
                } else if (Table.shouldStoreFieldsInMetastore(this.conf, serdeName, tbl.getParameters()) && !Table.hasMetastoreBasedSchema(this.conf, oldSerdeName)) {
                    try {
                        Deserializer oldSerde = HiveMetaStoreUtils.getDeserializer(this.conf, tbl.getTTable(), false, oldSerdeName);
                        tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getTableName(), oldSerde));
                    }
                    catch (MetaException ex) {
                        throw new HiveException(ex);
                    }
                }
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDFILEFORMAT) {
                StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
                if (this.isSchemaEvolutionEnabled(tbl) && sd.getInputFormat().equals(OrcInputFormat.class.getName()) && !alterTbl.getInputFormat().equals(OrcInputFormat.class.getName())) {
                    throw new HiveException(ErrorMsg.CANNOT_CHANGE_FILEFORMAT, "ORC", alterTbl.getOldName());
                }
                sd.setInputFormat(alterTbl.getInputFormat());
                sd.setOutputFormat(alterTbl.getOutputFormat());
                if (alterTbl.getSerdeName() != null) {
                    sd.getSerdeInfo().setSerializationLib(alterTbl.getSerdeName());
                }
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCLUSTERSORTCOLUMN) {
                StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
                List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
                if (!alterTbl.isTurnOffSorting()) {
                    Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
                }
                if (alterTbl.getSortColumns() != null) {
                    Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
                }
                if (alterTbl.isTurnOffSorting()) {
                    sd.setSortCols(new ArrayList<Order>());
                } else if (alterTbl.getNumberBuckets() == -1) {
                    sd.setBucketCols(new ArrayList<String>());
                    sd.setNumBuckets(-1);
                    sd.setSortCols(new ArrayList<Order>());
                } else {
                    sd.setBucketCols(alterTbl.getBucketColumns());
                    sd.setNumBuckets(alterTbl.getNumberBuckets());
                    sd.setSortCols(alterTbl.getSortColumns());
                }
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
                StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
                String newLocation = alterTbl.getNewLocation();
                try {
                    URI locUri = new URI(newLocation);
                    if (!new Path(locUri).isAbsolute()) {
                        throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, newLocation);
                    }
                    sd.setLocation(newLocation);
                }
                catch (URISyntaxException e) {
                    throw new HiveException(e);
                }
                environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSKEWEDBY) {
                List<String> skewedColNames = null;
                List<List<String>> skewedValues = null;
                if (alterTbl.isTurnOffSkewed()) {
                    skewedColNames = new ArrayList<String>();
                    skewedValues = new ArrayList<List<String>>();
                } else {
                    skewedColNames = alterTbl.getSkewedColNames();
                    skewedValues = alterTbl.getSkewedColValues();
                }
                if (null == tbl.getSkewedInfo()) {
                    SkewedInfo skewedInfo = new SkewedInfo();
                    skewedInfo.setSkewedColNames(skewedColNames);
                    skewedInfo.setSkewedColValues(skewedValues);
                    tbl.setSkewedInfo(skewedInfo);
                } else {
                    tbl.setSkewedColNames(skewedColNames);
                    tbl.setSkewedColValues(skewedValues);
                }
                tbl.setStoredAsSubDirectories(alterTbl.isStoredAsSubDirectories());
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.OWNER) {
                if (alterTbl.getOwnerPrincipal() != null) {
                    tbl.setOwner(alterTbl.getOwnerPrincipal().getName());
                    tbl.setOwnerType(alterTbl.getOwnerPrincipal().getType());
                }
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERSKEWEDLOCATION) {
                Map<List<String>, String> locMaps = alterTbl.getSkewedLocations();
                Set<List<String>> keys = locMaps.keySet();
                for (List<String> key : keys) {
                    String newLocation = locMaps.get(key);
                    try {
                        ArrayList<String> slk;
                        URI locUri = new URI(newLocation);
                        if (part != null) {
                            slk = new ArrayList<String>(key);
                            part.setSkewedValueLocationMap(slk, locUri.toString());
                            continue;
                        }
                        slk = new ArrayList<String>(key);
                        tbl.setSkewedValueLocationMap(slk, locUri.toString());
                    }
                    catch (URISyntaxException e) {
                        throw new HiveException(e);
                    }
                }
                environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERBUCKETNUM) {
                if (part != null) {
                    if (part.getBucketCount() == alterTbl.getNumberBuckets()) {
                        return null;
                    }
                    part.setBucketCount(alterTbl.getNumberBuckets());
                } else {
                    if (tbl.getNumBuckets() == alterTbl.getNumberBuckets()) {
                        return null;
                    }
                    tbl.setNumBuckets(alterTbl.getNumberBuckets());
                }
            } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.UPDATECOLUMNS) {
                this.updateColumns(tbl, part);
            } else {
                throw new HiveException(ErrorMsg.UNSUPPORTED_ALTER_TBL_OP, alterTbl.getOp().toString());
            }
        }
        return null;
    }

    private List<Task<?>> alterTableDropProps(AlterTableDesc alterTbl, Table tbl, Partition part, EnvironmentContext environmentContext) throws HiveException {
        if ("USER".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
        }
        List<Task<?>> result = null;
        if (part == null) {
            Set<String> removedSet = alterTbl.getProps().keySet();
            boolean isFromMmTable = AcidUtils.isInsertOnlyTable(tbl.getParameters());
            boolean isRemoved = AcidUtils.isRemovedInsertOnlyTable(removedSet);
            if (isFromMmTable && isRemoved) {
                throw new HiveException("Cannot convert an ACID table to non-ACID");
            }
            if (removedSet.contains("EXTERNAL") && tbl.getTableType() == TableType.EXTERNAL_TABLE) {
                tbl.setTableType(TableType.MANAGED_TABLE);
            }
        }
        Iterator<String> keyItr = alterTbl.getProps().keySet().iterator();
        while (keyItr.hasNext()) {
            if (part != null) {
                part.getTPartition().getParameters().remove(keyItr.next());
                continue;
            }
            tbl.getTTable().getParameters().remove(keyItr.next());
        }
        return result;
    }

    private void checkMmLb(Table tbl) throws HiveException {
        if (!tbl.isStoredAsSubDirectories()) {
            return;
        }
        throw new HiveException("Converting list bucketed tables stored as subdirectories  to MM is not supported. Please re-create a table in the desired format.");
    }

    private void checkMmLb(Partition part) throws HiveException {
        if (!part.isStoredAsSubDirectories()) {
            return;
        }
        throw new HiveException("Converting list bucketed tables stored as subdirectories  to MM is not supported. Please re-create a table in the desired format.");
    }

    private List<Task<?>> generateAddMmTasks(Table tbl, Long writeId) throws HiveException {
        ArrayList<Path> srcs = new ArrayList<Path>();
        ArrayList<Path> tgts = new ArrayList<Path>();
        if (writeId == null) {
            throw new HiveException("Internal error - write ID not set for MM conversion");
        }
        int stmtId = 0;
        String mmDir = AcidUtils.deltaSubdir(writeId, writeId, stmtId);
        Hive db = this.getHive();
        if (tbl.getPartitionKeys().size() > 0) {
            PartitionIterable parts = new PartitionIterable(db, tbl, null, HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
            for (Partition part : parts) {
                this.checkMmLb(part);
                Path src = part.getDataLocation();
                Path tgt = new Path(src, mmDir);
                srcs.add(src);
                tgts.add(tgt);
                if (!Utilities.FILE_OP_LOGGER.isTraceEnabled()) continue;
                Utilities.FILE_OP_LOGGER.trace("Will move " + src + " to " + tgt);
            }
        } else {
            this.checkMmLb(tbl);
            Path src = tbl.getDataLocation();
            Path tgt = new Path(src, mmDir);
            srcs.add(src);
            tgts.add(tgt);
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Will move " + src + " to " + tgt);
            }
        }
        MoveWork mw = new MoveWork(null, null, null, null, false);
        mw.setMultiFilesDesc(new LoadMultiFilesDesc(srcs, tgts, true, null, null));
        return Lists.newArrayList(TaskFactory.get(mw));
    }

    private List<Task<?>> alterTableAddProps(AlterTableDesc alterTbl, Table tbl, Partition part, EnvironmentContext environmentContext) throws HiveException {
        if ("USER".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
        }
        List<Task<?>> result = null;
        if (part != null) {
            part.getTPartition().getParameters().putAll(alterTbl.getProps());
        } else {
            String externalProp;
            boolean isFromMmTable = AcidUtils.isInsertOnlyTable(tbl.getParameters());
            Boolean isToMmTable = AcidUtils.isToInsertOnlyTable(tbl, alterTbl.getProps());
            if (isToMmTable != null) {
                if (!isFromMmTable && isToMmTable.booleanValue()) {
                    if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MM_ALLOW_ORIGINALS)) {
                        result = this.generateAddMmTasks(tbl, alterTbl.getWriteId());
                    } else if (tbl.getPartitionKeys().size() > 0) {
                        Hive db = this.getHive();
                        PartitionIterable parts = new PartitionIterable(db, tbl, null, HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
                        for (Partition part0 : parts) {
                            this.checkMmLb(part0);
                        }
                    } else {
                        this.checkMmLb(tbl);
                    }
                } else if (isFromMmTable && !isToMmTable.booleanValue()) {
                    throw new HiveException("Cannot convert an ACID table to non-ACID");
                }
            }
            if ((externalProp = alterTbl.getProps().get("EXTERNAL")) != null) {
                if (Boolean.parseBoolean(externalProp) && tbl.getTableType() == TableType.MANAGED_TABLE) {
                    tbl.setTableType(TableType.EXTERNAL_TABLE);
                } else if (!Boolean.parseBoolean(externalProp) && tbl.getTableType() == TableType.EXTERNAL_TABLE) {
                    tbl.setTableType(TableType.MANAGED_TABLE);
                }
            }
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        }
        return result;
    }

    private int dropConstraint(Hive db, AlterTableDesc alterTbl) throws SemanticException, HiveException {
        try {
            db.dropConstraint(Utilities.getDatabaseName(alterTbl.getOldName()), Utilities.getTableName(alterTbl.getOldName()), alterTbl.getConstraintName());
        }
        catch (NoSuchObjectException e) {
            throw new HiveException(e);
        }
        return 0;
    }

    private int addConstraints(Hive db, AlterTableDesc alterTbl) throws SemanticException, HiveException {
        try {
            if (alterTbl.getPrimaryKeyCols() != null && !alterTbl.getPrimaryKeyCols().isEmpty()) {
                db.addPrimaryKey(alterTbl.getPrimaryKeyCols());
            }
            if (alterTbl.getForeignKeyCols() != null && !alterTbl.getForeignKeyCols().isEmpty()) {
                try {
                    db.addForeignKey(alterTbl.getForeignKeyCols());
                }
                catch (HiveException e) {
                    if (e.getCause() instanceof InvalidObjectException && alterTbl.getReplicationSpec() != null && alterTbl.getReplicationSpec().isInReplicationScope()) {
                        LOG.debug("InvalidObjectException: ", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (alterTbl.getUniqueConstraintCols() != null && !alterTbl.getUniqueConstraintCols().isEmpty()) {
                db.addUniqueConstraint(alterTbl.getUniqueConstraintCols());
            }
            if (alterTbl.getNotNullConstraintCols() != null && !alterTbl.getNotNullConstraintCols().isEmpty()) {
                db.addNotNullConstraint(alterTbl.getNotNullConstraintCols());
            }
            if (alterTbl.getDefaultConstraintCols() != null && !alterTbl.getDefaultConstraintCols().isEmpty()) {
                db.addDefaultConstraint(alterTbl.getDefaultConstraintCols());
            }
            if (alterTbl.getCheckConstraintCols() != null && !alterTbl.getCheckConstraintCols().isEmpty()) {
                db.addCheckConstraint(alterTbl.getCheckConstraintCols());
            }
        }
        catch (NoSuchObjectException e) {
            throw new HiveException(e);
        }
        return 0;
    }

    private int updateColumns(Table tbl, Partition part) throws HiveException {
        String serializationLib = tbl.getSd().getSerdeInfo().getSerializationLib();
        if (MetastoreConf.getStringCollection(this.conf, MetastoreConf.ConfVars.SERDES_USING_METASTORE_FOR_SCHEMA).contains(serializationLib)) {
            throw new HiveException(tbl.getTableName() + " has serde " + serializationLib + " for which schema is already handled by HMS.");
        }
        Deserializer deserializer = tbl.getDeserializer(true);
        try {
            LOG.info("Updating metastore columns for table: {}", (Object)tbl.getTableName());
            List<FieldSchema> fields = HiveMetaStoreUtils.getFieldsFromDeserializer(tbl.getTableName(), deserializer);
            StorageDescriptor sd = DDLTask.retrieveStorageDescriptor(tbl, part);
            sd.setCols(fields);
        }
        catch (MetaException | SerDeException e) {
            LOG.error("alter table update columns: {}", (Throwable)e);
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }

    private void dropTableOrPartitions(Hive db, DropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable(dropTbl.getTableName());
        }
        catch (InvalidTableException invalidTableException) {
            // empty catch block
        }
        if (dropTbl.getPartSpecs() == null) {
            this.dropTable(db, tbl, dropTbl);
        } else {
            this.dropPartitions(db, tbl, dropTbl);
        }
    }

    private void dropPartitions(Hive db, Table tbl, DropTableDesc dropTbl) throws HiveException {
        ReplicationSpec replicationSpec = dropTbl.getReplicationSpec();
        if (replicationSpec.isInReplicationScope()) {
            if (tbl == null) {
                return;
            }
            for (DropTableDesc.PartSpec partSpec : dropTbl.getPartSpecs()) {
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                try {
                    db.getPartitionsByExpr(tbl, partSpec.getPartSpec(), this.conf, partitions);
                    for (Partition p : Iterables.filter(partitions, replicationSpec.allowEventReplacementInto())) {
                        db.dropPartition(tbl.getDbName(), tbl.getTableName(), p.getValues(), true);
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (Exception e) {
                    throw new HiveException(e.getMessage(), e);
                }
            }
            return;
        }
        List<Partition> droppedParts = db.dropPartitions(dropTbl.getTableName(), dropTbl.getPartSpecs(), PartitionDropOptions.instance().deleteData(true).ifExists(true).purgeData(dropTbl.getIfPurge()));
        for (Partition partition : droppedParts) {
            this.console.printInfo("Dropped the partition " + partition.getName());
            this.addIfAbsentByName(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK));
        }
    }

    private void dropTable(Hive db, Table tbl, DropTableDesc dropTbl) throws HiveException {
        if (tbl != null && dropTbl.getValidationRequired()) {
            if (tbl.isView()) {
                if (!dropTbl.getExpectView()) {
                    if (dropTbl.getIfExists()) {
                        return;
                    }
                    if (dropTbl.getExpectMaterializedView()) {
                        throw new HiveException("Cannot drop a view with DROP MATERIALIZED VIEW");
                    }
                    throw new HiveException("Cannot drop a view with DROP TABLE");
                }
            } else if (tbl.isMaterializedView()) {
                if (!dropTbl.getExpectMaterializedView()) {
                    if (dropTbl.getIfExists()) {
                        return;
                    }
                    if (dropTbl.getExpectView()) {
                        throw new HiveException("Cannot drop a materialized view with DROP VIEW");
                    }
                    throw new HiveException("Cannot drop a materialized view with DROP TABLE");
                }
            } else {
                if (dropTbl.getExpectView()) {
                    if (dropTbl.getIfExists()) {
                        return;
                    }
                    throw new HiveException("Cannot drop a base table with DROP VIEW");
                }
                if (dropTbl.getExpectMaterializedView()) {
                    if (dropTbl.getIfExists()) {
                        return;
                    }
                    throw new HiveException("Cannot drop a base table with DROP MATERIALIZED VIEW");
                }
            }
        }
        ReplicationSpec replicationSpec = dropTbl.getReplicationSpec();
        if (tbl != null && replicationSpec.isInReplicationScope() && !replicationSpec.allowEventReplacementInto(tbl.getParameters())) {
            if (tbl.isPartitioned()) {
                PartitionIterable partitions = new PartitionIterable(db, tbl, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
                for (Partition p : Iterables.filter(partitions, replicationSpec.allowEventReplacementInto())) {
                    db.dropPartition(tbl.getDbName(), tbl.getTableName(), p.getValues(), true);
                }
            }
            LOG.debug("DDLTask: Drop Table is skipped as table {} is newer than update", (Object)dropTbl.getTableName());
            return;
        }
        db.dropTable(dropTbl.getTableName(), dropTbl.getIfPurge());
        if (tbl != null) {
            if (tbl.isMaterializedView() && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_VIEWS_REGISTRY)) {
                HiveMaterializedViewsRegistry.get().dropMaterializedView(tbl);
            }
            this.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
    }

    private boolean updateModifiedParameters(Map<String, String> params, HiveConf conf) throws HiveException {
        String user = null;
        user = SessionState.getUserFromAuthenticator();
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        return true;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        DDLTask.validateSerDe(serdeName, this.conf);
    }

    public static void validateSerDe(String serdeName, HiveConf conf) throws HiveException {
        try {
            Deserializer d = ReflectionUtil.newInstance(conf.getClassByName(serdeName).asSubclass(Deserializer.class), conf);
            if (d != null) {
                LOG.debug("Found class for {}", (Object)serdeName);
            }
        }
        catch (Exception e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createDatabase(Hive db, CreateDatabaseDesc crtDb) throws HiveException {
        Database database = new Database();
        database.setName(crtDb.getName());
        database.setDescription(crtDb.getComment());
        database.setLocationUri(crtDb.getLocationUri());
        database.setParameters(crtDb.getDatabaseProperties());
        database.setOwnerName(SessionState.getUserFromAuthenticator());
        database.setOwnerType(PrincipalType.USER);
        try {
            this.makeLocationQualified(database);
            db.createDatabase(database, crtDb.getIfNotExists());
        }
        catch (AlreadyExistsException ex) {
            throw new HiveException((Throwable)ex, ErrorMsg.DATABSAE_ALREADY_EXISTS, crtDb.getName());
        }
        return 0;
    }

    private int dropDatabase(Hive db, DropDatabaseDesc dropDb) throws HiveException {
        try {
            Database database;
            String dbName = dropDb.getDatabaseName();
            ReplicationSpec replicationSpec = dropDb.getReplicationSpec();
            if (replicationSpec.isInReplicationScope() && ((database = db.getDatabase(dbName)) == null || !replicationSpec.allowEventReplacementInto(database.getParameters()))) {
                return 0;
            }
            db.dropDatabase(dbName, true, dropDb.getIfExists(), dropDb.isCasdade());
            if (dropDb.isCasdade()) {
                FunctionRegistry.unregisterPermanentFunctions(dbName);
            }
        }
        catch (NoSuchObjectException ex) {
            throw new HiveException((Throwable)ex, ErrorMsg.DATABASE_NOT_EXISTS, dropDb.getDatabaseName());
        }
        return 0;
    }

    private int switchDatabase(Hive db, SwitchDatabaseDesc switchDb) throws HiveException {
        String dbName = switchDb.getDatabaseName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        SessionState.get().setCurrentDatabase(dbName);
        Database database = db.getDatabase(dbName);
        assert (database != null);
        Map<String, String> dbParams = database.getParameters();
        if (dbParams != null) {
            for (HiveConf.ConfVars var : HiveConf.dbVars) {
                String newValue = dbParams.get(var.varname);
                if (newValue == null) continue;
                LOG.info("Changing {} from {} to {}", new Object[]{var.varname, this.conf.getVar(var), newValue});
                this.conf.setVar(var, newValue);
            }
        }
        return 0;
    }

    private int createTable(Hive db, CreateTableDesc crtTbl) throws HiveException {
        Table existingTable;
        Table tbl = crtTbl.toTable(this.conf);
        List<SQLPrimaryKey> primaryKeys = crtTbl.getPrimaryKeys();
        List<SQLForeignKey> foreignKeys = crtTbl.getForeignKeys();
        List<SQLUniqueConstraint> uniqueConstraints = crtTbl.getUniqueConstraints();
        List<SQLNotNullConstraint> notNullConstraints = crtTbl.getNotNullConstraints();
        List<SQLDefaultConstraint> defaultConstraints = crtTbl.getDefaultConstraints();
        List<SQLCheckConstraint> checkConstraints = crtTbl.getCheckConstraints();
        LOG.debug("creating table {} on {}", (Object)tbl.getFullyQualifiedName(), (Object)tbl.getDataLocation());
        if (crtTbl.getReplicationSpec().isInReplicationScope() && !crtTbl.getReplaceMode() && (existingTable = db.getTable(tbl.getDbName(), tbl.getTableName(), false)) != null) {
            if (crtTbl.getReplicationSpec().allowEventReplacementInto(existingTable.getParameters())) {
                crtTbl.setReplaceMode(true);
            } else {
                LOG.debug("DDLTask: Create Table is skipped as table {} is newer than update", (Object)crtTbl.getTableName());
                return 0;
            }
        }
        if (crtTbl.getReplaceMode()) {
            db.alterTable(tbl, null);
        } else {
            if (foreignKeys != null && foreignKeys.size() > 0 || primaryKeys != null && primaryKeys.size() > 0 || uniqueConstraints != null && uniqueConstraints.size() > 0 || notNullConstraints != null && notNullConstraints.size() > 0 || checkConstraints != null && checkConstraints.size() > 0 || defaultConstraints != null && defaultConstraints.size() > 0) {
                db.createTable(tbl, crtTbl.getIfNotExists(), primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
            } else {
                db.createTable(tbl, crtTbl.getIfNotExists());
            }
            Long mmWriteId = crtTbl.getInitialMmWriteId();
            if (crtTbl.isCTAS() || mmWriteId != null) {
                Table createdTable = db.getTable(tbl.getDbName(), tbl.getTableName());
                if (crtTbl.isCTAS()) {
                    LineageInfo.DataContainer dc = new LineageInfo.DataContainer(createdTable.getTTable());
                    this.queryState.getLineageState().setLineage(createdTable.getPath(), dc, createdTable.getCols());
                }
            }
        }
        this.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    private int createTableLike(Hive db, CreateTableLikeDesc crtTbl) throws Exception {
        Table tbl;
        Table oldtbl = db.getTable(crtTbl.getLikeTableName());
        if (oldtbl.getTableType() == TableType.VIRTUAL_VIEW || oldtbl.getTableType() == TableType.MATERIALIZED_VIEW) {
            String targetTableName = crtTbl.getTableName();
            tbl = db.newTable(targetTableName);
            if (crtTbl.getTblProps() != null) {
                tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
            }
            tbl.setTableType(TableType.MANAGED_TABLE);
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            }
            tbl.setFields(oldtbl.getCols());
            tbl.setPartCols(oldtbl.getPartCols());
            if (crtTbl.getDefaultSerName() == null) {
                LOG.info("Default to LazySimpleSerDe for table {}", (Object)targetTableName);
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                this.validateSerDe(crtTbl.getDefaultSerName());
                tbl.setSerializationLib(crtTbl.getDefaultSerName());
            }
            if (crtTbl.getDefaultSerdeProps() != null) {
                for (Map.Entry<String, String> m : crtTbl.getDefaultSerdeProps().entrySet()) {
                    tbl.setSerdeParam(m.getKey(), m.getValue());
                }
            }
            tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
            tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        } else {
            tbl = oldtbl;
            String targetTableName = crtTbl.getTableName();
            String[] names = Utilities.getDbTableName(targetTableName);
            tbl.setDbName(names[0]);
            tbl.setTableName(names[1]);
            tbl.setOwner(SessionState.getUserFromAuthenticator());
            if (crtTbl.getLocation() != null) {
                tbl.setDataLocation(new Path(crtTbl.getLocation()));
            } else {
                tbl.unsetDataLocation();
            }
            Class<? extends Deserializer> serdeClass = oldtbl.getDeserializerClass();
            Map<String, String> params = tbl.getParameters();
            SerDeSpec spec = AnnotationUtils.getAnnotation(serdeClass, SerDeSpec.class);
            String paramsStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.DDL_CTL_PARAMETERS_WHITELIST);
            HashSet<String> retainer = new HashSet<String>();
            retainer.add("storage_handler");
            if (spec != null && spec.schemaProps() != null) {
                retainer.addAll(Arrays.asList(spec.schemaProps()));
            }
            if (paramsStr != null) {
                retainer.addAll(Arrays.asList(paramsStr.split(",")));
            }
            if (!retainer.isEmpty()) {
                params.keySet().retainAll(retainer);
            } else {
                params.clear();
            }
            if (crtTbl.getTblProps() != null) {
                params.putAll(crtTbl.getTblProps());
            }
            if (crtTbl.isUserStorageFormat()) {
                tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
                tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
                tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
                tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
                if (crtTbl.getDefaultSerName() == null) {
                    LOG.info("Default to LazySimpleSerDe for like table {}", (Object)targetTableName);
                    tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                } else {
                    this.validateSerDe(crtTbl.getDefaultSerName());
                    tbl.setSerializationLib(crtTbl.getDefaultSerName());
                }
            }
            tbl.getTTable().setTemporary(crtTbl.isTemporary());
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            } else {
                tbl.getParameters().remove("EXTERNAL");
            }
        }
        if (DDLTask.doesTableNeedLocation(tbl)) {
            DDLTask.makeLocationQualified(tbl.getDbName(), tbl, this.conf);
        }
        if (crtTbl.getLocation() == null && !tbl.isPartitioned() && this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            StatsSetupConst.setStatsStateForCreateTable(tbl.getTTable().getParameters(), MetaStoreUtils.getColumnNames(tbl.getCols()), "true");
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        this.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    private int createView(Hive db, CreateViewDesc crtView) throws HiveException {
        Table oldview = db.getTable(crtView.getViewName(), false);
        if (oldview != null) {
            if (crtView.getReplicationSpec().isInReplicationScope()) {
                if (crtView.getReplicationSpec().allowEventReplacementInto(oldview.getParameters())) {
                    crtView.setReplace(true);
                } else {
                    LOG.debug("DDLTask: Create View is skipped as view {} is newer than update", (Object)crtView.getViewName());
                    return 0;
                }
            }
            if (!crtView.isReplace()) {
                throw new HiveException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(crtView.getViewName()));
            }
            assert (!crtView.isMaterialized());
            oldview.setViewOriginalText(crtView.getViewOriginalText());
            oldview.setViewExpandedText(crtView.getViewExpandedText());
            oldview.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                oldview.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                oldview.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            oldview.setPartCols(crtView.getPartCols());
            if (crtView.getInputFormat() != null) {
                oldview.setInputFormatClass(crtView.getInputFormat());
            }
            if (crtView.getOutputFormat() != null) {
                oldview.setOutputFormatClass(crtView.getOutputFormat());
            }
            oldview.checkValidity(null);
            db.alterTable(crtView.getViewName(), oldview, null);
            this.addIfAbsentByName(new WriteEntity(oldview, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            Table tbl = crtView.toTable(this.conf);
            if (tbl.isMaterializedView()) {
                CreationMetadata cm = new CreationMetadata(MetaStoreUtils.getDefaultCatalog(this.conf), tbl.getDbName(), tbl.getTableName(), ImmutableSet.copyOf(crtView.getTablesUsed()));
                cm.setValidTxnList(this.conf.get("hive.txn.tables.valid.writeids"));
                tbl.getTTable().setCreationMetadata(cm);
            }
            db.createTable(tbl, crtView.getIfNotExists());
            this.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
            LineageInfo.DataContainer dc = new LineageInfo.DataContainer(tbl.getTTable());
            this.queryState.getLineageState().setLineage(new Path(crtView.getViewName()), dc, tbl.getCols());
        }
        return 0;
    }

    private int truncateTable(Hive db, TruncateTableDesc truncateTableDesc) throws HiveException {
        Map<String, String> partSpec;
        if (truncateTableDesc.getColumnIndexes() != null) {
            ColumnTruncateWork truncateWork = new ColumnTruncateWork(truncateTableDesc.getColumnIndexes(), truncateTableDesc.getInputDir(), truncateTableDesc.getOutputDir());
            truncateWork.setListBucketingCtx(truncateTableDesc.getLbCtx());
            truncateWork.setMapperCannotSpanPartns(true);
            DriverContext driverCxt = new DriverContext();
            ColumnTruncateTask taskExec = new ColumnTruncateTask();
            taskExec.initialize(this.queryState, null, driverCxt, null);
            taskExec.setWork(truncateWork);
            taskExec.setQueryPlan(this.getQueryPlan());
            this.subtask = taskExec;
            int ret = taskExec.execute(driverCxt);
            if (this.subtask.getException() != null) {
                this.setException(this.subtask.getException());
            }
            return ret;
        }
        String tableName = truncateTableDesc.getTableName();
        if (!this.allowOperationInReplicationScope(db, tableName, partSpec = truncateTableDesc.getPartSpec(), truncateTableDesc.getReplicationSpec())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DDLTask: Truncate Table/Partition is skipped as table {} / partition {} is newer than update", (Object)tableName, (Object)(partSpec == null ? "null" : FileUtils.makePartName(new ArrayList<String>(partSpec.keySet()), new ArrayList<String>(partSpec.values()))));
            }
            return 0;
        }
        try {
            db.truncateTable(tableName, partSpec);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }

    private int exchangeTablePartition(Hive db, AlterTableExchangePartition exchangePartition) throws HiveException {
        Map<String, String> partitionSpecs = exchangePartition.getPartitionSpecs();
        Table destTable = exchangePartition.getDestinationTable();
        Table sourceTable = exchangePartition.getSourceTable();
        List<Partition> partitions = db.exchangeTablePartitions(partitionSpecs, sourceTable.getDbName(), sourceTable.getTableName(), destTable.getDbName(), destTable.getTableName());
        for (Partition partition : partitions) {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(new Partition(sourceTable, partition.getSpec(), null)));
            this.addIfAbsentByName(new WriteEntity(new Partition(sourceTable, partition.getSpec(), null), WriteEntity.WriteType.DELETE));
            this.addIfAbsentByName(new WriteEntity(new Partition(destTable, partition.getSpec(), null), WriteEntity.WriteType.INSERT));
        }
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return "DDL";
    }

    public static void makeLocationQualified(String databaseName, Table table, HiveConf conf) throws HiveException {
        Path path = null;
        StorageDescriptor sd = table.getTTable().getSd();
        if (sd.isSetLocation()) {
            path = new Path(sd.getLocation());
        }
        if (path != null) {
            sd.setLocation(Utilities.getQualifiedPath(conf, path));
        }
    }

    private void makeLocationQualified(Database database) throws HiveException {
        if (database.isSetLocationUri()) {
            database.setLocationUri(Utilities.getQualifiedPath(this.conf, new Path(database.getLocationUri())));
        } else {
            database.setLocationUri(Utilities.getQualifiedPath(this.conf, new Path(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE), database.getName().toLowerCase() + DATABASE_PATH_SUFFIX)));
        }
    }

    private boolean allowOperationInReplicationScope(Hive db, String tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec) throws HiveException {
        if (null == replicationSpec || !replicationSpec.isInReplicationScope()) {
            return true;
        }
        Table existingTable = db.getTable(tableName, false);
        if (existingTable != null && replicationSpec.allowEventReplacementInto(existingTable.getParameters())) {
            if (partSpec != null) {
                Partition existingPtn = db.getPartition(existingTable, partSpec, false);
                return existingPtn != null && replicationSpec.allowEventReplacementInto(existingPtn.getParameters());
            }
            return true;
        }
        return false;
    }

    public static boolean doesTableNeedLocation(Table tbl) {
        boolean retval = true;
        if (tbl.getStorageHandler() != null) {
            String sh = tbl.getStorageHandler().toString();
            retval = !sh.equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler") && !sh.equals("org.apache.hadoop.hive.druid.DruidStorageHandler") && !sh.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler") && !sh.equals("org.apache.hadoop.hive.accumulo.AccumuloStorageHandler");
        }
        return retval;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

