/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.yarn.metrics.DispatcherEventMetrics;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class DispatcherEventMetricsImpl
implements DispatcherEventMetrics {
    private final Map<String, MutableGaugeLong> currentEventCountMetrics = new HashMap<String, MutableGaugeLong>();
    private final Map<String, MutableRate> processingTimeMetrics = new HashMap<String, MutableRate>();
    private final MetricsRegistry registry;

    public DispatcherEventMetricsImpl(String name) {
        this.registry = new MetricsRegistry(Interns.info((String)("DispatcherEventMetrics for " + name), (String)("DispatcherEventMetrics for " + name)));
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    @Override
    public void init(Class<? extends Enum> typeClass) {
        for (Enum constant : typeClass.getEnumConstants()) {
            String key = this.createKey(constant);
            this.currentEventCountMetrics.put(key, this.registry.newGauge(key + "_Current", key + "_Current", 0L));
            this.processingTimeMetrics.put(key, this.registry.newRate(key + "_", key + "_"));
        }
    }

    @Override
    public void addEvent(Object type) {
        this.currentEventCountMetrics.get(this.createKey(type)).incr();
    }

    @Override
    public void removeEvent(Object type) {
        this.currentEventCountMetrics.get(this.createKey(type)).decr();
    }

    @Override
    public void updateRate(Object type, long millisecond) {
        this.processingTimeMetrics.get(this.createKey(type)).add(millisecond);
    }

    private String createKey(Object constant) {
        return constant.getClass().getSimpleName() + "#" + constant;
    }

    public String toString() {
        return new StringJoiner(", ").add("currentEventCountMetrics=" + this.currentEventCountMetrics).add("processingTimeMetrics=" + this.processingTimeMetrics).toString();
    }
}

