/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TablePermission
extends Permission {
    private TableName table;
    private byte[] family;
    private byte[] qualifier;

    TablePermission(TableName table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(assigned);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
        this.scope = Permission.Scope.TABLE;
    }

    public TableName getTableName() {
        return this.table;
    }

    public boolean hasFamily() {
        return this.family != null;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public String getNamespace() {
        return this.table.getNamespaceAsString();
    }

    public boolean implies(TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.failCheckTable(table)) {
            return false;
        }
        if (this.failCheckFamily(family)) {
            return false;
        }
        if (this.failCheckQualifier(qualifier)) {
            return false;
        }
        return this.implies(action);
    }

    public boolean implies(TableName table, byte[] family, Permission.Action action) {
        if (this.failCheckTable(table)) {
            return false;
        }
        if (this.failCheckFamily(family)) {
            return false;
        }
        return this.implies(action);
    }

    private boolean failCheckTable(TableName table) {
        return this.table == null || !this.table.equals(table);
    }

    private boolean failCheckFamily(byte[] family) {
        return this.family != null && (family == null || !Bytes.equals(this.family, family));
    }

    private boolean failCheckQualifier(byte[] qual) {
        return this.qualifier != null && (qual == null || !Bytes.equals(this.qualifier, qual));
    }

    public boolean implies(TableName table, KeyValue kv, Permission.Action action) {
        if (this.failCheckTable(table)) {
            return false;
        }
        if (this.family != null && !CellUtil.matchingFamily((Cell)kv, this.family)) {
            return false;
        }
        if (this.qualifier != null && !CellUtil.matchingQualifier((Cell)kv, this.qualifier)) {
            return false;
        }
        return super.implies(action);
    }

    public boolean tableFieldsEqual(TablePermission tp) {
        if (tp == null) {
            return false;
        }
        boolean tEq = this.table == null && tp.table == null || this.table != null && this.table.equals(tp.table);
        boolean fEq = this.family == null && tp.family == null || Bytes.equals(this.family, tp.family);
        boolean qEq = this.qualifier == null && tp.qualifier == null || Bytes.equals(this.qualifier, tp.qualifier);
        return tEq && fEq && qEq;
    }

    @Override
    public boolean equalsExceptActions(Object obj) {
        if (!(obj instanceof TablePermission)) {
            return false;
        }
        TablePermission other = (TablePermission)obj;
        return this.tableFieldsEqual(other);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equalsExceptActions(obj) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.table != null) {
            result = 37 * result + this.table.hashCode();
        }
        if (this.family != null) {
            result = 37 * result + Bytes.hashCode(this.family);
        }
        if (this.qualifier != null) {
            result = 37 * result + Bytes.hashCode(this.qualifier);
        }
        return result;
    }

    @Override
    public String toString() {
        return "[TablePermission: " + this.rawExpression() + "]";
    }

    @Override
    protected String rawExpression() {
        StringBuilder raw = new StringBuilder();
        if (this.table != null) {
            raw.append("table=").append(this.table).append(", family=").append(this.family == null ? null : Bytes.toString(this.family)).append(", qualifier=").append(this.qualifier == null ? null : Bytes.toString(this.qualifier)).append(", ");
        }
        return raw.toString() + super.rawExpression();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte[] tableBytes = Bytes.readByteArray(in);
        if (tableBytes.length > 0) {
            this.table = TableName.valueOf(tableBytes);
        }
        if (in.readBoolean()) {
            this.family = Bytes.readByteArray(in);
        }
        if (in.readBoolean()) {
            this.qualifier = Bytes.readByteArray(in);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.table == null ? null : this.table.getName());
        out.writeBoolean(this.family != null);
        if (this.family != null) {
            Bytes.writeByteArray(out, this.family);
        }
        out.writeBoolean(this.qualifier != null);
        if (this.qualifier != null) {
            Bytes.writeByteArray(out, this.qualifier);
        }
    }
}

