/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.searchable_snapshots;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MountSnapshotRequest
implements ToXContentObject,
Validatable {
    private final String repository;
    private final String snapshot;
    private final String index;
    private TimeValue masterTimeout;
    private Boolean waitForCompletion;
    private Storage storage;
    private String renamedIndex;
    private Settings indexSettings;
    private String[] ignoreIndexSettings;

    public String getRepository() {
        return this.repository;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public String getIndex() {
        return this.index;
    }

    public MountSnapshotRequest(String repository, String snapshot, String index) {
        this.repository = Objects.requireNonNull(repository);
        this.snapshot = Objects.requireNonNull(snapshot);
        this.index = Objects.requireNonNull(index);
    }

    public TimeValue getMasterTimeout() {
        return this.masterTimeout;
    }

    public MountSnapshotRequest masterTimeout(TimeValue masterTimeout) {
        this.masterTimeout = masterTimeout;
        return this;
    }

    public Boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public MountSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public MountSnapshotRequest storage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public String getRenamedIndex() {
        return this.renamedIndex;
    }

    public MountSnapshotRequest renamedIndex(String renamedIndex) {
        this.renamedIndex = renamedIndex;
        return this;
    }

    public Settings getIndexSettings() {
        return this.indexSettings;
    }

    public MountSnapshotRequest indexSettings(Settings indexSettings) {
        this.indexSettings = indexSettings;
        return this;
    }

    public String[] getIgnoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public MountSnapshotRequest ignoreIndexSettings(String[] ignoreIndexSettings) {
        if (ignoreIndexSettings != null) {
            for (String ignoreIndexSetting : ignoreIndexSettings) {
                Objects.requireNonNull(ignoreIndexSetting);
            }
        }
        this.ignoreIndexSettings = ignoreIndexSettings;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.index);
        if (this.renamedIndex != null) {
            builder.field("renamed_index", this.renamedIndex);
        }
        if (this.indexSettings != null) {
            builder.startObject("index_settings");
            this.indexSettings.toXContent(builder, params);
            builder.endObject();
        }
        if (this.ignoreIndexSettings != null) {
            builder.array("ignore_index_settings", this.ignoreIndexSettings);
        }
        builder.endObject();
        return builder;
    }

    public static enum Storage {
        FULL_COPY("full_copy"),
        SHARED_CACHE("shared_cache");

        private final String storageName;

        public String storageName() {
            return this.storageName;
        }

        private Storage(String storageName) {
            this.storageName = storageName;
        }
    }
}

