/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Maps {
    private static final Set<Class<?>> IMMUTABLE_MAP_CLASSES = org.elasticsearch.core.Set.of((Object[])new Class[]{Collections.emptyMap().getClass(), Collections.unmodifiableMap(new HashMap()).getClass(), org.elasticsearch.core.Map.of().getClass(), org.elasticsearch.core.Map.of((Object)"a", (Object)"b").getClass()});

    public static <K, V> boolean deepEquals(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.size() != right.size()) {
            return false;
        }
        return left.entrySet().stream().allMatch(e -> right.containsKey(e.getKey()) && Objects.deepEquals(e.getValue(), right.get(e.getKey())));
    }

    public static <K, V> Map<K, V> copyMapWithRemovedEntry(Map<K, V> map, K key) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(key);
        assert (Maps.checkIsImmutableMap(map, key, map.get(key)));
        return map.entrySet().stream().filter(k -> !key.equals(k.getKey())).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));
    }

    private static <K, V> boolean checkIsImmutableMap(Map<K, V> map, K key, V value) {
        if (IMMUTABLE_MAP_CLASSES.contains(map.getClass())) {
            return true;
        }
        try {
            map.put(key, value);
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return true;
        }
    }

    public static Map<String, Object> flatten(Map<String, Object> map, boolean flattenArrays, boolean ordered) {
        return Maps.flatten(map, flattenArrays, ordered, null);
    }

    private static Map<String, Object> flatten(Map<String, Object> map, boolean flattenArrays, boolean ordered, String parentPath) {
        TreeMap<String, Object> flatMap = ordered ? new TreeMap() : new HashMap();
        String prefix = parentPath != null ? parentPath + "." : "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                flatMap.putAll(Maps.flatten((Map)entry.getValue(), flattenArrays, ordered, prefix + entry.getKey()));
                continue;
            }
            if (flattenArrays && entry.getValue() instanceof List) {
                flatMap.putAll(Maps.flatten((List)entry.getValue(), ordered, prefix + entry.getKey()));
                continue;
            }
            flatMap.put(prefix + entry.getKey(), entry.getValue());
        }
        return flatMap;
    }

    private static Map<String, Object> flatten(List<Object> list, boolean ordered, String parentPath) {
        TreeMap<String, Object> flatMap = ordered ? new TreeMap() : new HashMap();
        String prefix = parentPath != null ? parentPath + "." : "";
        for (int i = 0; i < list.size(); ++i) {
            Object cur = list.get(i);
            if (cur instanceof Map) {
                flatMap.putAll(Maps.flatten((Map)cur, true, ordered, prefix + i));
            }
            if (cur instanceof List) {
                flatMap.putAll(Maps.flatten((List)cur, ordered, prefix + i));
                continue;
            }
            flatMap.put(prefix + i, cur);
        }
        return flatMap;
    }

    public static <T, K, V> Collector<T, ?, NavigableMap<K, V>> toUnmodifiableSortedMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key (attempted merging values " + v1 + "  and " + v2 + ")");
        }, () -> new TreeMap()), Collections::unmodifiableNavigableMap);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toUnmodifiableOrderedMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key (attempted merging values " + v1 + "  and " + v2 + ")");
        }, LinkedHashMap::new), Collections::unmodifiableMap);
    }
}

