/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.keycloakusersync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.hadoop.security.authentication.util.SsoConfigurationUtil;
import org.apache.ranger.ugsyncutil.model.KeycloakSyncSourceInfo;
import org.apache.ranger.ugsyncutil.model.UgsyncAuditInfo;
import org.apache.ranger.ugsyncutil.model.UsersGroupRoleAssignments;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakUserGroupSource
implements UserGroupSource {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakUserGroupSource.class);
    public static final String SYNC_SOURCE = "Keycloak";
    private boolean deletesEnabled;
    private long deleteFrequency;
    private long deleteCycles;
    private String clientId;
    private UsersResource usersResource;
    private GroupsResource groupsResource;
    private UgsyncAuditInfo ugsyncAuditInfo;

    @Override
    public void init() throws Throwable {
        UserGroupSyncConfig ugSyncConfig = UserGroupSyncConfig.getInstance();
        SsoConfigurationUtil ssoConfig = SsoConfigurationUtil.getInstance();
        this.deletesEnabled = ugSyncConfig.isUserSyncDeletesEnabled();
        this.deleteFrequency = ugSyncConfig.getUserSyncDeletesFrequency();
        this.clientId = ssoConfig.getClientId();
        String issuerUrl = ssoConfig.getClientIssuer();
        String[] issuerUrlParts = issuerUrl.split("/realms/");
        Keycloak keycloak = Keycloak.getInstance((String)issuerUrlParts[0], (String)issuerUrlParts[1], (String)ugSyncConfig.getKeycloakUsername(), (String)ugSyncConfig.getKeycloakPassword(), (String)this.clientId, (String)ssoConfig.getClientSecret(), (SSLContext)SSLContext.getDefault());
        RealmResource realmResource = keycloak.realm(issuerUrlParts[1]);
        this.usersResource = realmResource.users();
        this.groupsResource = realmResource.groups();
        KeycloakSyncSourceInfo keycloakSyncSourceInfo = new KeycloakSyncSourceInfo();
        keycloakSyncSourceInfo.setRealmUrl(issuerUrl);
        keycloakSyncSourceInfo.setClientId(ssoConfig.getClientId());
        this.ugsyncAuditInfo = new UgsyncAuditInfo();
        this.ugsyncAuditInfo.setSyncSource(SYNC_SOURCE);
        this.ugsyncAuditInfo.setKeycloakSyncSourceInfo(keycloakSyncSourceInfo);
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        List userRepresentations = this.usersResource.list();
        List groupRepresentations = this.groupsResource.groups();
        this.addOrUpdateGropus(sink, userRepresentations, groupRepresentations);
        this.updateRoles(sink, userRepresentations, groupRepresentations);
        sink.postUserGroupAuditInfo(this.ugsyncAuditInfo);
    }

    private void addOrUpdateGropus(UserGroupSink sink, List<UserRepresentation> userRepresentations, List<GroupRepresentation> groupRepresentations) throws Throwable {
        sink.addOrUpdateUsersGroups(this.toMap(groupRepresentations, GroupRepresentation::getName, groupRepresentation -> {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("sync_source", SYNC_SOURCE);
            attributes.put("original_name", groupRepresentation.getName());
            attributes.put("full_name", groupRepresentation.getName());
            return attributes;
        }), this.toMap(userRepresentations, AbstractUserRepresentation::getUsername, userRepresentation -> {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("sync_source", SYNC_SOURCE);
            attributes.put("original_name", userRepresentation.getUsername());
            attributes.put("full_name", userRepresentation.getUsername());
            return attributes;
        }), this.toMap(groupRepresentations, GroupRepresentation::getName, groupRepresentation -> this.toSet(this.getGroupResource((GroupRepresentation)groupRepresentation).members(), AbstractUserRepresentation::getUsername)), this.shouldComputeDeletes());
    }

    private void updateRoles(UserGroupSink sink, List<UserRepresentation> userRepresentations, List<GroupRepresentation> groupRepresentations) {
        UsersGroupRoleAssignments usersGroupRoleAssignments = new UsersGroupRoleAssignments();
        usersGroupRoleAssignments.setUsers(this.toList(userRepresentations, AbstractUserRepresentation::getUsername));
        usersGroupRoleAssignments.setUserRoleAssignments(this.toMap(userRepresentations, AbstractUserRepresentation::getUsername, this::getRangerRole));
        usersGroupRoleAssignments.setGroupRoleAssignments(this.toMap(groupRepresentations, GroupRepresentation::getName, this::getRangerRole));
        sink.updateRoles(usersGroupRoleAssignments);
    }

    private boolean shouldComputeDeletes() {
        if (!this.deletesEnabled) {
            return false;
        }
        if (this.deleteCycles < this.deleteFrequency) {
            ++this.deleteCycles;
            return false;
        }
        this.deleteCycles = 1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compute deleted users/groups is enabled for this sync cycle");
        }
        return true;
    }

    private GroupResource getGroupResource(GroupRepresentation groupRepresentation) {
        return this.groupsResource.group(groupRepresentation.getId());
    }

    private String getRangerRole(UserRepresentation userRepresentation) {
        return this.getRangerRole(this.usersResource.get(userRepresentation.getId()).roles().getAll());
    }

    private String getRangerRole(GroupRepresentation groupRepresentation) {
        return this.getRangerRole(this.getGroupResource(groupRepresentation).roles().getAll());
    }

    private String getRangerRole(MappingsRepresentation mappingsRepresentation) {
        List realmRoles = Optional.ofNullable(mappingsRepresentation).map(MappingsRepresentation::getRealmMappings).map(rm -> this.toList((Collection)rm, RoleRepresentation::getName)).orElseGet(Collections::emptyList);
        List clientRoles = Optional.ofNullable(mappingsRepresentation).map(MappingsRepresentation::getClientMappings).map(cm -> (ClientMappingsRepresentation)cm.get(this.clientId)).map(ClientMappingsRepresentation::getMappings).map(cm -> this.toList((Collection)cm, RoleRepresentation::getName)).orElseGet(Collections::emptyList);
        ArrayList keycloakRoles = new ArrayList(realmRoles);
        keycloakRoles.addAll(clientRoles);
        if (keycloakRoles.contains("fabric-manager")) {
            return "ROLE_SYS_ADMIN";
        }
        return "ROLE_USER";
    }

    private <T, R> Set<R> toSet(Collection<T> collection, Function<T, R> mapper) {
        return collection.stream().map(mapper).collect(Collectors.toSet());
    }

    private <T, R> List<R> toList(Collection<T> collection, Function<T, R> mapper) {
        return collection.stream().map(mapper).collect(Collectors.toList());
    }

    private <T, KR, VR> Map<KR, VR> toMap(Collection<T> collection, Function<T, KR> keyMapper, Function<T, VR> valueMapper) {
        return collection.stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }
}

