/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(MaprSecurity.class);
    private static final String MAPR_HOME = MaprSecurity.findMapRHome();
    public static final String SECURITY_TYPE_PROPERTY = "ranger.security.type";
    public static final String MAPR_SASL = "maprsasl";
    public static final String KERBEROS = "kerberos";
    public static final String NONE = "none";
    private static final String CLUSTERS_FILE = MAPR_HOME + "/conf/mapr-clusters.conf";
    private static String SECURITY_TYPE_FROM_FILE;
    private static String clusterName;

    public static String getSecurityTypeFromClustersFile() {
        return SECURITY_TYPE_FROM_FILE;
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static String findMapRHome() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            LOG.warn("Environment variable MAPR_HOME is null");
            maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null) {
                LOG.warn("System property mapr.home.dir is null");
                maprHome = SystemUtils.IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
                LOG.warn("Setting MapR home as {} by default", (Object)maprHome);
            }
        }
        return maprHome;
    }

    static {
        try (Scanner sc = new Scanner(new FileInputStream(CLUSTERS_FILE));){
            String line = sc.nextLine();
            clusterName = line.trim().split("\\s+")[0];
            SECURITY_TYPE_FROM_FILE = line.contains("kerberosEnable=true") ? KERBEROS : (line.contains("secure=true") ? MAPR_SASL : NONE);
        }
        catch (FileNotFoundException e) {
            clusterName = "";
            SECURITY_TYPE_FROM_FILE = NONE;
        }
    }
}

