/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.List;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.zookeeper.data.ACL;

public abstract class SecurityAwareZkACLProvider
implements ZkACLProvider {
    public static final String SECURITY_ZNODE_PATH = "/security";
    private List<ACL> nonSecurityACLsToAdd;
    private List<ACL> securityACLsToAdd;

    @Override
    public final List<ACL> getACLsToAdd(String zNodePath) {
        if (this.isSecurityZNodePath(zNodePath)) {
            return this.getSecurityACLsToAdd();
        }
        return this.getNonSecurityACLsToAdd();
    }

    protected boolean isSecurityZNodePath(String zNodePath) {
        return zNodePath != null && (zNodePath.equals("/security.json") || zNodePath.equals(SECURITY_ZNODE_PATH) || zNodePath.startsWith("/security/"));
    }

    protected abstract List<ACL> createNonSecurityACLsToAdd();

    protected abstract List<ACL> createSecurityACLsToAdd();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ACL> getNonSecurityACLsToAdd() {
        if (this.nonSecurityACLsToAdd == null) {
            SecurityAwareZkACLProvider securityAwareZkACLProvider = this;
            synchronized (securityAwareZkACLProvider) {
                if (this.nonSecurityACLsToAdd == null) {
                    this.nonSecurityACLsToAdd = this.createNonSecurityACLsToAdd();
                }
            }
        }
        return this.nonSecurityACLsToAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ACL> getSecurityACLsToAdd() {
        if (this.securityACLsToAdd == null) {
            SecurityAwareZkACLProvider securityAwareZkACLProvider = this;
            synchronized (securityAwareZkACLProvider) {
                if (this.securityACLsToAdd == null) {
                    this.securityACLsToAdd = this.createSecurityACLsToAdd();
                }
            }
        }
        return this.securityACLsToAdd;
    }
}

