/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.management.servicebus.implementation.Token;
import com.microsoft.azure.management.servicebus.implementation.TokenParser;
import org.joda.time.Period;

public class TimeSpan {
    private static long ticksPerMillisecond = 10000L;
    private static long ticksPerSecond = ticksPerMillisecond * 1000L;
    private static long ticksPerMinute = ticksPerSecond * 60L;
    private static long ticksPerHour = ticksPerMinute * 60L;
    private static long ticksPerDay = ticksPerHour * 24L;
    private static double millisecondsPerTick = 1.0 / (double)ticksPerMillisecond;
    private static double secondsPerTick = 1.0 / (double)ticksPerSecond;
    private static double minutesPerTick = 1.0 / (double)ticksPerMinute;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;

    public TimeSpan withDays(int days) {
        this.days = days;
        return this;
    }

    public TimeSpan withHours(int hours) {
        this.hours = hours;
        return this;
    }

    public TimeSpan withMinutes(int minutes) {
        this.minutes = minutes;
        return this;
    }

    public TimeSpan withSeconds(int seconds) {
        this.seconds = seconds;
        return this;
    }

    public TimeSpan withMilliseconds(int milliseconds) {
        this.milliseconds = milliseconds;
        return this;
    }

    public int days() {
        return this.days;
    }

    public int hours() {
        return this.hours;
    }

    public int minutes() {
        return this.minutes;
    }

    public int seconds() {
        return this.seconds;
    }

    public int milliseconds() {
        return this.milliseconds;
    }

    public double totalMilliseconds() {
        return (double)this.totalTicks() * millisecondsPerTick;
    }

    public double totalSeconds() {
        return (double)this.totalTicks() * secondsPerTick;
    }

    public double totalMinutes() {
        return (double)this.totalTicks() * minutesPerTick;
    }

    public static TimeSpan fromPeriod(Period period) {
        Period p = new Period(period.toStandardDuration().getMillis());
        return TimeSpan.parse(new TimeSpan().withDays(p.getDays()).withHours(p.getHours()).withMinutes(p.getMinutes()).withSeconds(p.getSeconds()).withMilliseconds(p.getMillis()).toString());
    }

    public static TimeSpan parse(String input) {
        int sign;
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        String str = input.trim();
        TimeSpan timeSpan = new TimeSpan();
        TokenParser parser = new TokenParser(str, str.charAt(0) == '-' ? 1 : 0);
        Token token = parser.nextToken();
        token.throwIfEmpty();
        int n = sign = str.charAt(0) == '-' ? -1 : 1;
        if (token.isTerminalCharNull()) {
            timeSpan.withDays(TimeSpan.toInt(token.getRawValue()) * sign);
            return timeSpan;
        }
        if (token.isTerminalMatched(Character.valueOf('.'))) {
            timeSpan.withDays(TimeSpan.toInt(token.getRawValue()) * sign);
            token = parser.nextToken();
            token.throwIfEmpty();
            timeSpan.withHours(TimeSpan.toInt(token.getRawValue()) * sign);
        } else {
            timeSpan.withDays(0);
            timeSpan.withHours(TimeSpan.toInt(token.getRawValue()) * sign);
        }
        if (timeSpan.hours() > 23) {
            parser.throwOutOfRange();
        }
        token.throwIfTerminalCharNotMatch(Character.valueOf(':'));
        token = parser.nextToken();
        token.throwIfEmpty();
        timeSpan.withMinutes(TimeSpan.toInt(token.getRawValue()) * sign);
        if (timeSpan.minutes() > 59) {
            parser.throwOutOfRange();
        }
        if (token.isTerminalCharNull()) {
            return timeSpan;
        }
        token.throwIfTerminalCharNotMatch(Character.valueOf(':'));
        token = parser.nextToken();
        token.throwIfEmpty();
        timeSpan.withSeconds(TimeSpan.toInt(token.getRawValue()) * sign);
        if (timeSpan.seconds() > 59) {
            parser.throwOutOfRange();
        }
        if (token.isTerminalCharNull()) {
            return timeSpan;
        }
        token.throwIfTerminalCharNotMatch(Character.valueOf('.'));
        token = parser.nextToken();
        token.throwIfEmpty();
        String milliStr = "." + token.getRawValue();
        if (milliStr.length() > 8) {
            parser.throwOutOfRange();
        }
        int milliSeconds = (int)(Double.parseDouble(milliStr) * 1000.0);
        timeSpan.withMilliseconds(milliSeconds * sign);
        if (!token.isTerminalCharNull()) {
            TokenParser.throwParseError();
        }
        return timeSpan;
    }

    public String toString() {
        long totalTicks = this.totalTicks();
        int days = (int)Math.abs(totalTicks / ticksPerDay);
        StringBuilder stringBuilder = new StringBuilder();
        if (totalTicks < 0L) {
            stringBuilder.append("-");
        }
        if (days != 0) {
            stringBuilder.append(String.format("%d.", days));
        }
        long remainingTicks = Math.abs(totalTicks % ticksPerDay);
        int hours = (int)(remainingTicks / ticksPerHour % 24L);
        int minutes = (int)(remainingTicks / ticksPerMinute % 60L);
        int seconds = (int)(remainingTicks / ticksPerSecond % 60L);
        stringBuilder.append(String.format("%02d:%02d:%02d", hours, minutes, seconds));
        int fraction = (int)(remainingTicks % ticksPerSecond);
        if (fraction != 0) {
            stringBuilder.append(String.format(".%07d", fraction));
        }
        return stringBuilder.toString();
    }

    private long totalTicks() {
        long totalMilliSeconds = ((long)this.days * 3600L * 24L + (long)this.hours * 3600L + (long)this.minutes * 60L + (long)this.seconds) * 1000L + (long)this.milliseconds;
        return totalMilliSeconds * ticksPerMillisecond;
    }

    private static int toInt(String intStr) {
        return Integer.parseInt(intStr);
    }
}

