/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Statistic;
import org.apache.hadoop.fs.StorageStatistics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemStorageStatistics
extends StorageStatistics
implements Iterable<StorageStatistics.LongStatistic> {
    private final Map<Statistic, AtomicLong> opsCount = new EnumMap<Statistic, AtomicLong>(Statistic.class);

    FileSystemStorageStatistics(String name) {
        super(name);
        for (Statistic opType : Statistic.VALUES) {
            this.opsCount.put(opType, new AtomicLong(0L));
        }
    }

    public long incrementCounter(Statistic op, long count) {
        return this.opsCount.get((Object)op).addAndGet(count);
    }

    @Override
    public String getScheme() {
        return this.getName();
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return new LongStatisticIterator();
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> iterator() {
        return this.getLongStatistics();
    }

    @Override
    public Long getLong(String key) {
        Statistic type = Statistic.fromSymbol(key);
        return type == null ? null : Long.valueOf(this.getLong(type));
    }

    public long getLong(Statistic op) {
        return this.opsCount.get((Object)op).get();
    }

    @Override
    public boolean isTracked(String key) {
        return Statistic.fromSymbol(key) != null;
    }

    @Override
    public void reset() {
        for (AtomicLong value : this.opsCount.values()) {
            value.set(0L);
        }
    }

    private class LongStatisticIterator
    implements Iterator<StorageStatistics.LongStatistic> {
        private final Iterator<Map.Entry<Statistic, AtomicLong>> iterator;

        private LongStatisticIterator() {
            this.iterator = FileSystemStorageStatistics.this.opsCount.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public StorageStatistics.LongStatistic next() {
            Map.Entry<Statistic, AtomicLong> entry = this.iterator.next();
            return new StorageStatistics.LongStatistic(entry.getKey().getSymbol(), entry.getValue().get());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

