/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIJob;
import com.microsoft.azure.management.batchai.BatchAIJobs;
import com.microsoft.azure.management.batchai.JobsListByExperimentOptions;
import com.microsoft.azure.management.batchai.implementation.BatchAIExperimentImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.BatchAIWorkspaceImpl;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.batchai.implementation.JobsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BatchAIJobsImpl
extends CreatableResourcesImpl<BatchAIJob, BatchAIJobImpl, JobInner>
implements BatchAIJobs {
    private final BatchAIWorkspaceImpl workspace;
    private final BatchAIExperimentImpl experiment;

    BatchAIJobsImpl(BatchAIExperimentImpl experiment) {
        this.workspace = (BatchAIWorkspaceImpl)experiment.workspace();
        this.experiment = experiment;
    }

    public BatchAIJobImpl define(String name) {
        return this.wrapModel(name);
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return this.inner().deleteAsync(this.workspace.resourceGroupName(), this.workspace.name(), this.experiment.name(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.workspace.resourceGroupName(), this.workspace.name(), this.parent().name(), name).toCompletable();
    }

    public PagedList<BatchAIJob> list() {
        return this.wrapList(((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.workspace.manager()).inner())).jobs().listByExperiment(this.workspace.resourceGroupName(), this.workspace.name(), this.experiment.name()));
    }

    @Override
    public PagedList<BatchAIJob> list(int maxResults) {
        return this.wrapList(((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.workspace.manager()).inner())).jobs().listByExperiment(this.workspace.resourceGroupName(), this.workspace.name(), this.experiment.name(), new JobsListByExperimentOptions().withMaxResults(maxResults)));
    }

    public BatchAIJob getByName(String name) {
        JobInner inner = ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.workspace.manager()).inner())).jobs().get(this.workspace.resourceGroupName(), this.workspace.name(), this.experiment.name(), name);
        return new BatchAIJobImpl(name, this.experiment, inner);
    }

    public Observable<BatchAIJob> listAsync() {
        return this.wrapPageAsync(this.inner().listByExperimentAsync(this.workspace.resourceGroupName(), this.workspace.name(), this.experiment.name()));
    }

    public Observable<BatchAIJob> getByNameAsync(String name) {
        return this.inner().getAsync(this.workspace.resourceGroupName(), this.workspace.name(), this.parent().name(), name).map((Func1)new Func1<JobInner, BatchAIJob>(){

            public BatchAIJob call(JobInner inner) {
                return BatchAIJobsImpl.this.wrapModel(inner);
            }
        });
    }

    public BatchAIJobImpl getById(String id) {
        return (BatchAIJobImpl)this.getByIdAsync(id).toBlocking().single();
    }

    public Observable<BatchAIJob> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().getAsync(resourceId.resourceGroupName(), this.workspace.name(), this.experiment.name(), resourceId.name()).map((Func1)new Func1<JobInner, BatchAIJob>(){

            public BatchAIJob call(JobInner inner) {
                return BatchAIJobsImpl.this.wrapModel(inner);
            }
        });
    }

    public ServiceFuture<BatchAIJob> getByIdAsync(String id, ServiceCallback<BatchAIJob> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    protected BatchAIJobImpl wrapModel(String name) {
        JobInner inner = new JobInner();
        return new BatchAIJobImpl(name, this.experiment, inner);
    }

    public Completable deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), this.workspace.name(), this.experiment.name(), resourceId.name()).toCompletable();
    }

    public JobsInner inner() {
        return ((BatchAIManagementClientImpl)((Object)this.manager().inner())).jobs();
    }

    protected BatchAIJobImpl wrapModel(JobInner inner) {
        if (inner == null) {
            return null;
        }
        return new BatchAIJobImpl(inner.name(), this.experiment, inner);
    }

    public BatchAIExperimentImpl parent() {
        return this.experiment;
    }

    public BatchAIManager manager() {
        return (BatchAIManager)this.workspace.manager();
    }
}

