/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.GroupInfo;
import org.apache.ranger.plugin.model.UserInfo;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerUserStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CLOUD_IDENTITY_NAME = "cloud_id";
    private Long userStoreVersion;
    private Date userStoreUpdateTime;
    private Map<String, Map<String, String>> userAttrMapping;
    private Map<String, Map<String, String>> groupAttrMapping;
    private Map<String, Set<String>> userGroupMapping;
    private Map<String, String> userCloudIdMapping;
    private Map<String, String> groupCloudIdMapping;

    public RangerUserStore() {
        this(-1L, null, null, null);
    }

    public RangerUserStore(Long userStoreVersion, Set<UserInfo> users, Set<GroupInfo> groups, Map<String, Set<String>> userGroups) {
        this.setUserStoreVersion(userStoreVersion);
        this.setUserStoreUpdateTime(new Date());
        this.setUserGroupMapping(userGroups);
        this.buildMap(users, groups);
    }

    public Long getUserStoreVersion() {
        return this.userStoreVersion;
    }

    public void setUserStoreVersion(Long userStoreVersion) {
        this.userStoreVersion = userStoreVersion;
    }

    public Date getUserStoreUpdateTime() {
        return this.userStoreUpdateTime;
    }

    public void setUserStoreUpdateTime(Date userStoreUpdateTime) {
        this.userStoreUpdateTime = userStoreUpdateTime;
    }

    public Map<String, Map<String, String>> getUserAttrMapping() {
        return this.userAttrMapping;
    }

    public void setUserAttrMapping(Map<String, Map<String, String>> userAttrMapping) {
        this.userAttrMapping = userAttrMapping;
    }

    public Map<String, Map<String, String>> getGroupAttrMapping() {
        return this.groupAttrMapping;
    }

    public void setGroupAttrMapping(Map<String, Map<String, String>> groupAttrMapping) {
        this.groupAttrMapping = groupAttrMapping;
    }

    public Map<String, Set<String>> getUserGroupMapping() {
        return this.userGroupMapping;
    }

    public void setUserGroupMapping(Map<String, Set<String>> userGroupMapping) {
        this.userGroupMapping = userGroupMapping;
    }

    public Map<String, String> getUserCloudIdMapping() {
        return this.userCloudIdMapping;
    }

    public void setUserCloudIdMapping(Map<String, String> userCloudIdMapping) {
        this.userCloudIdMapping = userCloudIdMapping;
    }

    public Map<String, String> getGroupCloudIdMapping() {
        return this.groupCloudIdMapping;
    }

    public void setGroupCloudIdMapping(Map<String, String> groupCloudIdMapping) {
        this.groupCloudIdMapping = groupCloudIdMapping;
    }

    public void dedupStrings() {
        HashMap<String, String> strTbl = new HashMap<String, String>();
        this.userAttrMapping = StringUtil.dedupStringsMapOfMap(this.userAttrMapping, strTbl);
        this.groupAttrMapping = StringUtil.dedupStringsMapOfMap(this.groupAttrMapping, strTbl);
        this.userGroupMapping = StringUtil.dedupStringsMapOfSet(this.userGroupMapping, strTbl);
        this.userCloudIdMapping = StringUtil.dedupStringsMap(this.userCloudIdMapping, strTbl);
        this.groupCloudIdMapping = StringUtil.dedupStringsMap(this.groupCloudIdMapping, strTbl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerUserStore={").append("userStoreVersion=").append(this.userStoreVersion).append(", ").append("userStoreUpdateTime=").append(this.userStoreUpdateTime).append(", ");
        sb.append("users={");
        if (MapUtils.isNotEmpty(this.userAttrMapping)) {
            for (String string : this.userAttrMapping.keySet()) {
                sb.append(string).append(" ");
            }
        }
        sb.append("}, ");
        sb.append("groups={");
        if (MapUtils.isNotEmpty(this.groupAttrMapping)) {
            for (String string : this.groupAttrMapping.keySet()) {
                sb.append(string).append(" ");
            }
        }
        sb.append("}");
        sb.append(", userGroupMapping={");
        if (MapUtils.isNotEmpty(this.userGroupMapping)) {
            for (Map.Entry entry : this.userGroupMapping.entrySet()) {
                String user = (String)entry.getKey();
                Set userGroups = (Set)entry.getValue();
                sb.append(user).append("[");
                if (CollectionUtils.isNotEmpty((Collection)userGroups)) {
                    for (String userGroup : userGroups) {
                        sb.append(userGroup).append(" ");
                    }
                }
                sb.append("] ");
            }
        }
        sb.append("}");
        sb.append("}");
        return sb;
    }

    private void buildMap(Set<UserInfo> users, Set<GroupInfo> groups) {
        String cloudId;
        if (CollectionUtils.isNotEmpty(users)) {
            this.userAttrMapping = new HashMap<String, Map<String, String>>();
            this.userCloudIdMapping = new HashMap<String, String>();
            for (UserInfo user : users) {
                String username = user.getName();
                Map<String, String> userAttrs = user.getOtherAttributes();
                if (!MapUtils.isNotEmpty(userAttrs)) continue;
                this.userAttrMapping.put(username, userAttrs);
                cloudId = userAttrs.get(CLOUD_IDENTITY_NAME);
                if (!StringUtils.isNotEmpty((String)cloudId)) continue;
                this.userCloudIdMapping.put(cloudId, username);
            }
        }
        if (CollectionUtils.isNotEmpty(groups)) {
            this.groupAttrMapping = new HashMap<String, Map<String, String>>();
            this.groupCloudIdMapping = new HashMap<String, String>();
            for (GroupInfo group : groups) {
                String groupname = group.getName();
                Map<String, String> groupAttrs = group.getOtherAttributes();
                if (!MapUtils.isNotEmpty(groupAttrs)) continue;
                this.groupAttrMapping.put(groupname, groupAttrs);
                cloudId = groupAttrs.get(CLOUD_IDENTITY_NAME);
                if (!StringUtils.isNotEmpty((String)cloudId)) continue;
                this.groupCloudIdMapping.put(cloudId, groupname);
            }
        }
    }
}

