/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DynamicTemplate
implements ToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicTemplate.class);
    private final String name;
    private final String pathMatch;
    private final String pathUnmatch;
    private final String match;
    private final String unmatch;
    private final MatchType matchType;
    private final XContentFieldType[] xContentFieldTypes;
    private final Map<String, Object> mapping;
    private final boolean runtimeMapping;

    static DynamicTemplate parse(String name, Map<String, Object> conf, Version indexVersionCreated) throws MapperParsingException {
        XContentFieldType[] xContentFieldTypes;
        String match = null;
        String pathMatch = null;
        String unmatch = null;
        String pathUnmatch = null;
        Map mapping = null;
        boolean runtime = false;
        String matchMappingType = null;
        String matchPattern = MatchType.SIMPLE.toString();
        for (Map.Entry<String, Object> entry : conf.entrySet()) {
            String propName = entry.getKey();
            if ("match".equals(propName)) {
                match = entry.getValue().toString();
                continue;
            }
            if ("path_match".equals(propName)) {
                pathMatch = entry.getValue().toString();
                continue;
            }
            if ("unmatch".equals(propName)) {
                unmatch = entry.getValue().toString();
                continue;
            }
            if ("path_unmatch".equals(propName)) {
                pathUnmatch = entry.getValue().toString();
                continue;
            }
            if ("match_mapping_type".equals(propName)) {
                matchMappingType = entry.getValue().toString();
                continue;
            }
            if ("match_pattern".equals(propName)) {
                matchPattern = entry.getValue().toString();
                continue;
            }
            if ("mapping".equals(propName)) {
                if (mapping != null) {
                    throw new MapperParsingException("mapping and runtime cannot be both specified in the same dynamic template [" + name + "]");
                }
                mapping = (Map)entry.getValue();
                runtime = false;
                continue;
            }
            if ("runtime".equals(propName)) {
                if (mapping != null) {
                    throw new MapperParsingException("mapping and runtime cannot be both specified in the same dynamic template [" + name + "]");
                }
                mapping = (Map)entry.getValue();
                runtime = true;
                continue;
            }
            throw new IllegalArgumentException("Illegal dynamic template parameter: [" + propName + "]");
        }
        if (mapping == null) {
            throw new MapperParsingException("template [" + name + "] must have either mapping or runtime set");
        }
        if ("*".equals(matchMappingType) || matchMappingType == null && (match != null || pathMatch != null)) {
            xContentFieldTypes = runtime ? (XContentFieldType[])Arrays.stream(XContentFieldType.values()).filter(XContentFieldType::supportsRuntimeField).toArray(XContentFieldType[]::new) : XContentFieldType.values();
        } else if (matchMappingType != null) {
            XContentFieldType xContentFieldType;
            try {
                xContentFieldType = XContentFieldType.fromString(matchMappingType);
                if (runtime && !xContentFieldType.supportsRuntimeField()) {
                    throw new MapperParsingException("Dynamic template [" + name + "] defines a runtime field but type [" + (Object)((Object)xContentFieldType) + "] is not supported as runtime field");
                }
            }
            catch (IllegalArgumentException e) {
                if (indexVersionCreated.onOrAfter(Version.V_6_0_0_alpha1)) {
                    throw e;
                }
                deprecationLogger.critical(DeprecationCategory.MAPPINGS, "invalid_mapping_type", "match_mapping_type [" + matchMappingType + "] is invalid and will be ignored: " + e.getMessage(), new Object[0]);
                return null;
            }
            xContentFieldTypes = new XContentFieldType[]{xContentFieldType};
        } else {
            xContentFieldTypes = new XContentFieldType[]{};
        }
        MatchType matchType = MatchType.fromString(matchPattern);
        if (indexVersionCreated.onOrAfter(Version.V_6_3_0)) {
            for (String regex : new String[]{pathMatch, match, pathUnmatch, unmatch}) {
                if (regex == null) continue;
                try {
                    matchType.matches(regex, "");
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Pattern [" + regex + "] of type [" + (Object)((Object)matchType) + "] is invalid. Cannot create dynamic template [" + name + "].", e);
                }
            }
        }
        return new DynamicTemplate(name, pathMatch, pathUnmatch, match, unmatch, xContentFieldTypes, matchType, mapping, runtime);
    }

    private DynamicTemplate(String name, String pathMatch, String pathUnmatch, String match, String unmatch, XContentFieldType[] xContentFieldTypes, MatchType matchType, Map<String, Object> mapping, boolean runtimeMapping) {
        this.name = name;
        this.pathMatch = pathMatch;
        this.pathUnmatch = pathUnmatch;
        this.match = match;
        this.unmatch = unmatch;
        this.matchType = matchType;
        this.xContentFieldTypes = xContentFieldTypes;
        this.mapping = mapping;
        this.runtimeMapping = runtimeMapping;
    }

    public String name() {
        return this.name;
    }

    public String pathMatch() {
        return this.pathMatch;
    }

    public String match() {
        return this.match;
    }

    public boolean match(String templateName, String path, String fieldName, XContentFieldType xcontentFieldType) {
        if (templateName != null) {
            return templateName.equals(this.name);
        }
        if (this.pathMatch != null && !this.matchType.matches(this.pathMatch, path)) {
            return false;
        }
        if (this.match != null && !this.matchType.matches(this.match, fieldName)) {
            return false;
        }
        if (this.pathUnmatch != null && this.matchType.matches(this.pathUnmatch, path)) {
            return false;
        }
        if (this.unmatch != null && this.matchType.matches(this.unmatch, fieldName)) {
            return false;
        }
        if (Arrays.stream(this.xContentFieldTypes).noneMatch(xcontentFieldType::equals)) {
            return false;
        }
        return !this.runtimeMapping || xcontentFieldType.supportsRuntimeField();
    }

    public String mappingType(String dynamicType) {
        Object index;
        String type;
        if (this.mapping.containsKey("type")) {
            type = this.mapping.get("type").toString();
            type = type.replace("{dynamic_type}", dynamicType);
            type = type.replace("{dynamicType}", dynamicType);
        } else {
            type = dynamicType;
        }
        if (!type.equals(this.mapping.get("type")) && "text".equals(type) && ("not_analyzed".equals(index = this.mapping.get("index")) || "no".equals(index))) {
            return "keyword";
        }
        return type;
    }

    public boolean isRuntimeMapping() {
        return this.runtimeMapping;
    }

    public Map<String, Object> mappingForName(String name, String dynamicType) {
        return DynamicTemplate.processMap(this.mapping, name, dynamicType);
    }

    private static Map<String, Object> processMap(Map<String, Object> map, String name, String dynamicType) {
        HashMap<String, Object> processedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            processedMap.put(key, DynamicTemplate.extractValue(entry.getValue(), name, dynamicType));
        }
        return processedMap;
    }

    private static List<?> processList(List<?> list, String name, String dynamicType) {
        ArrayList<Object> processedList = new ArrayList<Object>(list.size());
        for (Object value : list) {
            processedList.add(DynamicTemplate.extractValue(value, name, dynamicType));
        }
        return processedList;
    }

    private static Object extractValue(Object value, String name, String dynamicType) {
        if (value instanceof Map) {
            return DynamicTemplate.processMap((Map)value, name, dynamicType);
        }
        if (value instanceof List) {
            return DynamicTemplate.processList((List)value, name, dynamicType);
        }
        if (value instanceof String) {
            return value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
        }
        return value;
    }

    String getName() {
        return this.name;
    }

    XContentFieldType[] getXContentFieldTypes() {
        return this.xContentFieldTypes;
    }

    Map<String, Object> getMapping() {
        return this.mapping;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.match != null) {
            builder.field("match", this.match);
        }
        if (this.pathMatch != null) {
            builder.field("path_match", this.pathMatch);
        }
        if (this.unmatch != null) {
            builder.field("unmatch", this.unmatch);
        }
        if (this.pathUnmatch != null) {
            builder.field("path_unmatch", this.pathUnmatch);
        }
        if (this.xContentFieldTypes.length > 1 && this.match == null && this.pathMatch == null) {
            builder.field("match_mapping_type", "*");
        } else if (this.xContentFieldTypes.length == 1) {
            builder.field("match_mapping_type", (Enum)this.xContentFieldTypes[0]);
        }
        if (this.matchType != MatchType.SIMPLE) {
            builder.field("match_pattern", (Enum)this.matchType);
        }
        if (this.runtimeMapping) {
            builder.field("runtime", new TreeMap<String, Object>(this.mapping));
        } else {
            builder.field("mapping", new TreeMap<String, Object>(this.mapping));
        }
        builder.endObject();
        return builder;
    }

    public static enum MatchType {
        SIMPLE{

            @Override
            public boolean matches(String pattern, String value) {
                return Regex.simpleMatch(pattern, value);
            }

            public String toString() {
                return "simple";
            }
        }
        ,
        REGEX{

            @Override
            public boolean matches(String pattern, String value) {
                return value.matches(pattern);
            }

            public String toString() {
                return "regex";
            }
        };


        public static MatchType fromString(String value) {
            for (MatchType v : MatchType.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("No matching pattern matched on [" + value + "]");
        }

        public abstract boolean matches(String var1, String var2);
    }

    public static enum XContentFieldType {
        OBJECT{

            @Override
            boolean supportsRuntimeField() {
                return false;
            }
        }
        ,
        STRING{

            @Override
            public String defaultMappingType() {
                return "text";
            }

            @Override
            String defaultRuntimeMappingType() {
                return "keyword";
            }
        }
        ,
        LONG,
        DOUBLE{

            @Override
            public String defaultMappingType() {
                return NumberFieldMapper.NumberType.FLOAT.typeName();
            }
        }
        ,
        BOOLEAN,
        DATE,
        BINARY{

            @Override
            boolean supportsRuntimeField() {
                return false;
            }
        };


        public static XContentFieldType fromString(String value) {
            for (XContentFieldType v : XContentFieldType.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("No field type matched on [" + value + "], possible values are " + Arrays.toString((Object[])XContentFieldType.values()));
        }

        String defaultMappingType() {
            return this.toString();
        }

        String defaultRuntimeMappingType() {
            return this.toString();
        }

        boolean supportsRuntimeField() {
            return true;
        }

        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

