/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.test;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.FileStorageConfigInfo;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.GrantResources;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.NamespacePrivilege;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.PolicyGrant;
import org.apache.polaris.core.admin.model.PolicyPrivilege;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.TablePrivilege;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.policy.PredefinedPolicyTypes;
import org.apache.polaris.core.policy.exceptions.PolicyInUseException;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.IcebergHelper;
import org.apache.polaris.service.it.env.IntegrationTestsHelper;
import org.apache.polaris.service.it.env.ManagementApi;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;
import org.apache.polaris.service.it.env.PolicyApi;
import org.apache.polaris.service.it.ext.PolarisIntegrationTestExtension;
import org.apache.polaris.service.types.ApplicablePolicy;
import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.Policy;
import org.apache.polaris.service.types.PolicyAttachmentTarget;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.apache.polaris.service.types.UpdatePolicyRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@ExtendWith(value={PolarisIntegrationTestExtension.class})
public class PolarisPolicyServiceIntegrationTest {
    private static final String TEST_ROLE_ARN = Optional.ofNullable(System.getenv("INTEGRATION_TEST_ROLE_ARN")).orElse("arn:aws:iam::123456789012:role/my-role");
    private static final String CATALOG_ROLE_1 = "catalogrole1";
    private static final String CATALOG_ROLE_2 = "catalogrole2";
    private static final String EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT = "{\"enable\":true}";
    private static final Namespace NS1 = Namespace.of((String[])new String[]{"NS1"});
    private static final Namespace NS2 = Namespace.of((String[])new String[]{"NS2"});
    private static final PolicyIdentifier NS1_P1 = new PolicyIdentifier(NS1, "P1");
    private static final PolicyIdentifier NS1_P2 = new PolicyIdentifier(NS1, "P2");
    private static final PolicyIdentifier NS1_P3 = new PolicyIdentifier(NS1, "P3");
    private static final TableIdentifier NS2_T1 = TableIdentifier.of((Namespace)NS2, (String)"T1");
    private static final String NS1_NAME = RESTUtil.encodeNamespace((Namespace)NS1);
    private static final String INVALID_NAMESPACE = "INVALID_NAMESPACE";
    private static final String INVALID_POLICY = "INVALID_POLICY";
    private static final String INVALID_TABLE = "INVALID_TABLE";
    private static final String INVALID_NAMESPACE_MSG = "Namespace does not exist: INVALID_NAMESPACE";
    private static URI s3BucketBase;
    private static String principalRoleName;
    private static ClientCredentials adminCredentials;
    private static PrincipalWithCredentials principalCredentials;
    private static PolarisApiEndpoints endpoints;
    private static PolarisClient client;
    private static ManagementApi managementApi;
    private static PolicyApi policyApi;
    private RESTCatalog restCatalog;
    private String currentCatalogName;
    private final String catalogBaseLocation = String.valueOf(s3BucketBase) + "/" + System.getenv("USER") + "/path/to/data";
    private static final String[] DEFAULT_CATALOG_PROPERTIES;

    @BeforeAll
    public static void setup(PolarisApiEndpoints apiEndpoints, ClientCredentials credentials, @TempDir Path tempDir) {
        adminCredentials = credentials;
        endpoints = apiEndpoints;
        client = PolarisClient.polarisClient(endpoints);
        managementApi = client.managementApi(credentials);
        String principalName = client.newEntityName("snowman-rest");
        principalRoleName = client.newEntityName("rest-admin");
        principalCredentials = managementApi.createPrincipalWithRole(principalName, principalRoleName);
        URI testRootUri = IntegrationTestsHelper.getTemporaryDirectory(tempDir);
        s3BucketBase = testRootUri.resolve("my-bucket");
        policyApi = client.policyApi(principalCredentials);
    }

    @AfterAll
    public static void close() throws Exception {
        client.close();
    }

    @BeforeEach
    public void before(TestInfo testInfo) {
        String principalName = "snowman-rest-" + String.valueOf(UUID.randomUUID());
        principalRoleName = "rest-admin-" + String.valueOf(UUID.randomUUID());
        PrincipalWithCredentials principalCredentials = managementApi.createPrincipalWithRole(principalName, principalRoleName);
        Method method = (Method)testInfo.getTestMethod().orElseThrow();
        this.currentCatalogName = client.newEntityName(method.getName());
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn(TEST_ROLE_ARN).setExternalId("externalId").setUserArn("a:user:arn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        Optional<CatalogConfig> catalogConfig = Optional.ofNullable(method.getAnnotation(CatalogConfig.class));
        CatalogProperties.Builder catalogPropsBuilder = CatalogProperties.builder((String)this.catalogBaseLocation);
        String[] properties = catalogConfig.map(CatalogConfig::properties).orElse(DEFAULT_CATALOG_PROPERTIES);
        for (int i = 0; i < properties.length; i += 2) {
            catalogPropsBuilder.addProperty(properties[i], properties[i + 1]);
        }
        if (!s3BucketBase.getScheme().equals("file")) {
            catalogPropsBuilder.addProperty("replace-new-location-prefix-with-catalog-default", "file:");
        }
        PolarisCatalog catalog = PolarisCatalog.builder().setType(catalogConfig.map(CatalogConfig::value).orElse(Catalog.TypeEnum.INTERNAL)).setName(this.currentCatalogName).setProperties(catalogPropsBuilder.build()).setStorageConfigInfo((StorageConfigInfo)(s3BucketBase.getScheme().equals("file") ? new FileStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.FILE, List.of("file://")) : awsConfigModel)).build();
        managementApi.createCatalog(principalRoleName, (Catalog)catalog);
        Optional restCatalogConfig = testInfo.getTestMethod().flatMap(m -> Optional.ofNullable(m.getAnnotation(RestCatalogConfig.class)));
        ImmutableMap.Builder extraPropertiesBuilder = ImmutableMap.builder();
        restCatalogConfig.ifPresent(config -> {
            for (int i = 0; i < config.value().length; i += 2) {
                extraPropertiesBuilder.put((Object)config.value()[i], (Object)config.value()[i + 1]);
            }
        });
        this.restCatalog = IcebergHelper.restCatalog(client, endpoints, principalCredentials, this.currentCatalogName, (Map<String, String>)extraPropertiesBuilder.build());
        CatalogGrant catalogGrant = new CatalogGrant(CatalogPrivilege.CATALOG_MANAGE_CONTENT, GrantResource.TypeEnum.CATALOG);
        managementApi.createCatalogRole(this.currentCatalogName, CATALOG_ROLE_1);
        managementApi.addGrant(this.currentCatalogName, CATALOG_ROLE_1, (GrantResource)catalogGrant);
        CatalogRole catalogRole = managementApi.getCatalogRole(this.currentCatalogName, CATALOG_ROLE_1);
        managementApi.grantCatalogRoleToPrincipalRole(principalRoleName, this.currentCatalogName, catalogRole);
        policyApi = client.policyApi(principalCredentials);
    }

    @AfterEach
    public void cleanUp() {
        client.cleanUp(adminCredentials);
    }

    @Test
    public void testCreatePolicy() {
        this.restCatalog.createNamespace(NS1);
        Policy policy = policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        Assertions.assertThat((Object)policy).isNotNull();
        Assertions.assertThat((String)policy.getName()).isEqualTo("P1");
        Assertions.assertThat((String)policy.getDescription()).isEqualTo("test policy");
        Assertions.assertThat((String)policy.getPolicyType()).isEqualTo(PredefinedPolicyTypes.DATA_COMPACTION.getName());
        Assertions.assertThat((String)policy.getContent()).isEqualTo(EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT);
        Assertions.assertThat((Boolean)policy.getInheritable()).isEqualTo(PredefinedPolicyTypes.DATA_COMPACTION.isInheritable());
        Assertions.assertThat((Integer)policy.getVersion()).isEqualTo(0);
        Policy loadedPolicy = policyApi.loadPolicy(this.currentCatalogName, NS1_P1);
        Assertions.assertThat((Object)loadedPolicy).isEqualTo((Object)policy);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @ParameterizedTest
    @ValueSource(strings={" invalid", "invalid ", " invalid ", "", "policy name", "policy@name", "policy#name", "policy$name", "policy!name", "policy name with space", "policy.name", "policy,name", "policy~name", "policy`name", "policy;name", "policy:name", "policy<>name", "policy[]name", "policy{}name", "policy|name", "policy\\name", "policy/name", "policy*name", "policy^name", "policy%name"})
    public void testCreatePolicyWithInvalidName(String policyName) {
        this.restCatalog.createNamespace(NS1);
        PolicyIdentifier policyIdentifier = new PolicyIdentifier(NS1, policyName);
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        CreatePolicyRequest request = CreatePolicyRequest.builder().setType(PredefinedPolicyTypes.DATA_COMPACTION.getName()).setName(policyIdentifier.getName()).setDescription("test policy").setContent(EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT).build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies", Map.of("cat", this.currentCatalogName, "ns", ns)).post(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"{\"error\":{\"message\":\"Invalid value: createPolicy.arg2.name: must match \\\"^[A-Za-z0-9\\\\-_]+$\\\"\",\"type\":\"ResteasyReactiveViolationException\",\"code\":400}}"});
        }
    }

    @Test
    public void testCreatePolicyWithNonExistingNamespace() {
        CreatePolicyRequest request = CreatePolicyRequest.builder().setType(PredefinedPolicyTypes.DATA_COMPACTION.getName()).setName(this.currentCatalogName).setDescription("test policy").setContent(EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT).build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies", Map.of("cat", this.currentCatalogName, "ns", INVALID_NAMESPACE)).post(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{INVALID_NAMESPACE_MSG});
        }
    }

    @Test
    public void testAttachPolicyToNonExistingNamespace() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        Namespace invalidNamespace = Namespace.of((String[])new String[]{INVALID_NAMESPACE});
        PolicyAttachmentTarget invalidTarget = new PolicyAttachmentTarget(PolicyAttachmentTarget.TypeEnum.NAMESPACE, List.of(invalidNamespace.levels()));
        AttachPolicyRequest request = AttachPolicyRequest.builder().setTarget(invalidTarget).setParameters(Map.of()).build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy-name}/mappings", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy-name", NS1_P1.getName())).put(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{INVALID_NAMESPACE_MSG});
        }
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @Test
    public void testAttachPolicyToNonExistingTable() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        TableIdentifier invalidTable = TableIdentifier.of((Namespace)NS1, (String)INVALID_TABLE);
        PolicyAttachmentTarget invalidTarget = new PolicyAttachmentTarget(PolicyAttachmentTarget.TypeEnum.TABLE_LIKE, List.of(invalidTable.toString().split("\\.")));
        AttachPolicyRequest request = AttachPolicyRequest.builder().setTarget(invalidTarget).setParameters(Map.of()).build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy-name}/mappings", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy-name", NS1_P1.getName())).put(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"Table or view does not exist: " + NS1_NAME + ".INVALID_TABLE"});
        }
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @Test
    public void testDetachPolicyFromNonExistingNamespace() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        Namespace invalidNamespace = Namespace.of((String[])new String[]{INVALID_NAMESPACE});
        PolicyAttachmentTarget invalidTarget = new PolicyAttachmentTarget(PolicyAttachmentTarget.TypeEnum.NAMESPACE, List.of(invalidNamespace.levels()));
        DetachPolicyRequest request = DetachPolicyRequest.builder().setTarget(invalidTarget).build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy-name}/mappings", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy-name", NS1_P1.getName())).post(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{INVALID_NAMESPACE_MSG});
        }
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @Test
    public void testDetachPolicyFromNonExistingTable() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        TableIdentifier invalidTable = TableIdentifier.of((Namespace)NS1, (String)INVALID_TABLE);
        PolicyAttachmentTarget invalidTarget = new PolicyAttachmentTarget(PolicyAttachmentTarget.TypeEnum.TABLE_LIKE, List.of(invalidTable.toString().split("\\.")));
        DetachPolicyRequest request = DetachPolicyRequest.builder().setTarget(invalidTarget).build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy-name}/mappings", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy-name", NS1_P1.getName())).post(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"Table or view does not exist: " + NS1_NAME + ".INVALID_TABLE"});
        }
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @Test
    public void testDropPolicy() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        PolicyAttachmentTarget catalogTarget = PolicyAttachmentTarget.builder().setType(PolicyAttachmentTarget.TypeEnum.CATALOG).build();
        policyApi.attachPolicy(this.currentCatalogName, NS1_P1, catalogTarget, Map.of());
        Assertions.assertThatThrownBy(() -> policyApi.dropPolicy(this.currentCatalogName, NS1_P1)).isInstanceOf(PolicyInUseException.class);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1, true);
        Assertions.assertThat(policyApi.listPolicies(this.currentCatalogName, NS1)).hasSize(0);
        Assertions.assertThat(policyApi.getApplicablePolicies(this.currentCatalogName, null, null, null)).hasSize(0);
    }

    @Test
    public void testDropNonExistingPolicy() {
        this.restCatalog.createNamespace(NS1);
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy", INVALID_POLICY)).delete();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"Policy does not exist: class PolicyIdentifier", "namespace: " + NS1_NAME, "name: INVALID_POLICY"});
        }
    }

    @Test
    public void testUpdatePolicy() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        String updatedContent = "{\"enable\":false}";
        String updatedDescription = "updated test policy";
        Policy updatedPolicy = policyApi.updatePolicy(this.currentCatalogName, NS1_P1, updatedContent, updatedDescription, 0);
        Assertions.assertThat((Object)updatedPolicy).isNotNull();
        Assertions.assertThat((String)updatedPolicy.getName()).isEqualTo("P1");
        Assertions.assertThat((String)updatedPolicy.getDescription()).isEqualTo(updatedDescription);
        Assertions.assertThat((String)updatedPolicy.getPolicyType()).isEqualTo(PredefinedPolicyTypes.DATA_COMPACTION.getName());
        Assertions.assertThat((String)updatedPolicy.getContent()).isEqualTo(updatedContent);
        Assertions.assertThat((Boolean)updatedPolicy.getInheritable()).isEqualTo(PredefinedPolicyTypes.DATA_COMPACTION.isInheritable());
        Assertions.assertThat((Integer)updatedPolicy.getVersion()).isEqualTo(1);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @Test
    public void testUpdateNonExistingPolicy() {
        this.restCatalog.createNamespace(NS1);
        UpdatePolicyRequest request = UpdatePolicyRequest.builder().setContent("{\"enable\":false}").setDescription("updated test policy").build();
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy", INVALID_POLICY)).put(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"Policy does not exist: class PolicyIdentifier", "namespace: " + NS1_NAME, "name: INVALID_POLICY"});
        }
    }

    @Test
    public void testListPolicies() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        policyApi.createPolicy(this.currentCatalogName, NS1_P2, (PolicyType)PredefinedPolicyTypes.METADATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        Assertions.assertThat(policyApi.listPolicies(this.currentCatalogName, NS1)).containsExactlyInAnyOrder((Object[])new PolicyIdentifier[]{NS1_P1, NS1_P2});
        Assertions.assertThat(policyApi.listPolicies(this.currentCatalogName, NS1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION)).containsExactly((Object[])new PolicyIdentifier[]{NS1_P1});
        Assertions.assertThat(policyApi.listPolicies(this.currentCatalogName, NS1, (PolicyType)PredefinedPolicyTypes.METADATA_COMPACTION)).containsExactly((Object[])new PolicyIdentifier[]{NS1_P2});
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P2);
    }

    @Test
    public void testListPoliciesOnNonExistingNamespace() {
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies", Map.of("cat", this.currentCatalogName, "ns", INVALID_NAMESPACE)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{INVALID_NAMESPACE_MSG});
        }
    }

    @Test
    public void testGetApplicablePoliciesOnNonExistingNamespace() {
        try (Response res = policyApi.request("polaris/v1/{cat}/applicable-policies", Map.of("cat", this.currentCatalogName), Map.of("namespace", INVALID_NAMESPACE)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{INVALID_NAMESPACE_MSG});
        }
    }

    @Test
    public void testGetApplicablePoliciesOnNonExistingTable() {
        this.restCatalog.createNamespace(NS1);
        policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        try (Response res = policyApi.request("polaris/v1/{cat}/applicable-policies", Map.of("cat", this.currentCatalogName), Map.of("namespace", NS1_NAME, "target-name", INVALID_TABLE)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"Table does not exist: " + NS1_NAME + ".INVALID_TABLE"});
        }
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
    }

    @Test
    public void testLoadNonExistingPolicy() {
        this.restCatalog.createNamespace(NS1);
        try (Response res = policyApi.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}", Map.of("cat", this.currentCatalogName, "ns", NS1_NAME, "policy", INVALID_POLICY)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"Policy does not exist: class PolicyIdentifier", "namespace: " + NS1_NAME, "name: INVALID_POLICY"});
        }
    }

    @Test
    public void testPolicyMapping() {
        this.restCatalog.createNamespace(NS1);
        this.restCatalog.createNamespace(NS2);
        Policy p1 = policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        Policy p2 = policyApi.createPolicy(this.currentCatalogName, NS1_P2, (PolicyType)PredefinedPolicyTypes.METADATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        Policy p3 = policyApi.createPolicy(this.currentCatalogName, NS1_P3, (PolicyType)PredefinedPolicyTypes.ORPHAN_FILE_REMOVAL, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
        this.restCatalog.buildTable(NS2_T1, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"string", (Type)Types.StringType.get())})).create();
        PolicyAttachmentTarget catalogTarget = PolicyAttachmentTarget.builder().setType(PolicyAttachmentTarget.TypeEnum.CATALOG).build();
        PolicyAttachmentTarget namespaceTarget = PolicyAttachmentTarget.builder().setType(PolicyAttachmentTarget.TypeEnum.NAMESPACE).setPath(Arrays.asList(NS2.levels())).build();
        PolicyAttachmentTarget tableTarget = PolicyAttachmentTarget.builder().setType(PolicyAttachmentTarget.TypeEnum.TABLE_LIKE).setPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)NS2_T1)).build();
        policyApi.attachPolicy(this.currentCatalogName, NS1_P1, catalogTarget, Map.of());
        policyApi.attachPolicy(this.currentCatalogName, NS1_P2, namespaceTarget, Map.of());
        policyApi.attachPolicy(this.currentCatalogName, NS1_P3, tableTarget, Map.of());
        List<ApplicablePolicy> applicablePoliciesOnCatalog = policyApi.getApplicablePolicies(this.currentCatalogName, null, null, null);
        Assertions.assertThat(applicablePoliciesOnCatalog).containsExactly((Object[])new ApplicablePolicy[]{PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p1, false, NS1)});
        List<ApplicablePolicy> applicablePoliciesOnNamespace = policyApi.getApplicablePolicies(this.currentCatalogName, NS2, null, null);
        Assertions.assertThat(applicablePoliciesOnNamespace).containsExactlyInAnyOrder((Object[])new ApplicablePolicy[]{PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p1, true, NS1), PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p2, false, NS1)});
        List<ApplicablePolicy> applicablePoliciesOnTable = policyApi.getApplicablePolicies(this.currentCatalogName, NS2, NS2_T1.name(), null);
        Assertions.assertThat(applicablePoliciesOnTable).containsExactlyInAnyOrder((Object[])new ApplicablePolicy[]{PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p1, true, NS1), PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p2, true, NS1), PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p3, false, NS1)});
        Assertions.assertThat(policyApi.getApplicablePolicies(this.currentCatalogName, NS2, NS2_T1.name(), (PolicyType)PredefinedPolicyTypes.METADATA_COMPACTION)).containsExactlyInAnyOrder((Object[])new ApplicablePolicy[]{PolarisPolicyServiceIntegrationTest.policyToApplicablePolicy(p2, true, NS1)});
        policyApi.detachPolicy(this.currentCatalogName, NS1_P1, catalogTarget);
        policyApi.detachPolicy(this.currentCatalogName, NS1_P2, namespaceTarget);
        policyApi.detachPolicy(this.currentCatalogName, NS1_P3, tableTarget);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P1);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P2);
        policyApi.dropPolicy(this.currentCatalogName, NS1_P3);
        this.restCatalog.dropTable(NS2_T1);
    }

    @Test
    public void testGrantsOnPolicy() {
        this.restCatalog.createNamespace(NS1);
        try {
            policyApi.createPolicy(this.currentCatalogName, NS1_P1, (PolicyType)PredefinedPolicyTypes.DATA_COMPACTION, EXAMPLE_TABLE_MAINTENANCE_POLICY_CONTENT, "test policy");
            managementApi.createCatalogRole(this.currentCatalogName, CATALOG_ROLE_2);
            Stream<PolicyGrant> policyGrants = Arrays.stream(PolicyPrivilege.values()).map(p -> new PolicyGrant(Arrays.asList(NS1.levels()), NS1_P1.getName(), p, GrantResource.TypeEnum.POLICY));
            policyGrants.forEach(g -> managementApi.addGrant(this.currentCatalogName, CATALOG_ROLE_2, (GrantResource)g));
            ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, CATALOG_ROLE_2)).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).map(gr -> ((PolicyGrant)gr).getPrivilege()).containsExactlyInAnyOrder((Object[])PolicyPrivilege.values());
            PolicyGrant policyReadGrant = new PolicyGrant(Arrays.asList(NS1.levels()), NS1_P1.getName(), PolicyPrivilege.POLICY_READ, GrantResource.TypeEnum.POLICY);
            managementApi.revokeGrant(this.currentCatalogName, CATALOG_ROLE_2, (GrantResource)policyReadGrant);
            ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, CATALOG_ROLE_2)).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).map(gr -> ((PolicyGrant)gr).getPrivilege()).doesNotContain((Object[])new PolicyPrivilege[]{PolicyPrivilege.POLICY_READ});
        }
        finally {
            policyApi.purge(this.currentCatalogName, NS1);
        }
    }

    @Test
    public void testGrantsOnNonExistingPolicy() {
        this.restCatalog.createNamespace(NS1);
        try {
            managementApi.createCatalogRole(this.currentCatalogName, CATALOG_ROLE_2);
            Stream<PolicyGrant> policyGrants = Arrays.stream(PolicyPrivilege.values()).map(p -> new PolicyGrant(Arrays.asList(NS1.levels()), NS1_P1.getName(), p, GrantResource.TypeEnum.POLICY));
            policyGrants.forEach(g -> {
                try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", this.currentCatalogName, "role", CATALOG_ROLE_2)).put(Entity.json((Object)g));){
                    Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
                }
            });
        }
        finally {
            policyApi.purge(this.currentCatalogName, NS1);
        }
    }

    @Test
    public void testGrantsOnNamespace() {
        this.restCatalog.createNamespace(NS1);
        try {
            managementApi.createCatalogRole(this.currentCatalogName, CATALOG_ROLE_2);
            List<NamespacePrivilege> policyPrivilegesOnNamespace = List.of(NamespacePrivilege.POLICY_LIST, NamespacePrivilege.POLICY_CREATE, NamespacePrivilege.POLICY_DROP, NamespacePrivilege.POLICY_WRITE, NamespacePrivilege.POLICY_READ, NamespacePrivilege.POLICY_FULL_METADATA, NamespacePrivilege.NAMESPACE_ATTACH_POLICY, NamespacePrivilege.NAMESPACE_DETACH_POLICY);
            Stream<NamespaceGrant> namespaceGrants = policyPrivilegesOnNamespace.stream().map(p -> new NamespaceGrant(Arrays.asList(NS1.levels()), p, GrantResource.TypeEnum.NAMESPACE));
            namespaceGrants.forEach(g -> managementApi.addGrant(this.currentCatalogName, CATALOG_ROLE_2, (GrantResource)g));
            ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, CATALOG_ROLE_2)).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).map(gr -> ((NamespaceGrant)gr).getPrivilege()).containsExactlyInAnyOrderElementsOf(policyPrivilegesOnNamespace);
        }
        finally {
            policyApi.purge(this.currentCatalogName, NS1);
        }
    }

    @Test
    public void testGrantsOnCatalog() {
        managementApi.createCatalogRole(this.currentCatalogName, CATALOG_ROLE_2);
        List<CatalogPrivilege> policyPrivilegesOnCatalog = List.of(CatalogPrivilege.POLICY_LIST, CatalogPrivilege.POLICY_CREATE, CatalogPrivilege.POLICY_DROP, CatalogPrivilege.POLICY_WRITE, CatalogPrivilege.POLICY_READ, CatalogPrivilege.POLICY_FULL_METADATA, CatalogPrivilege.CATALOG_ATTACH_POLICY, CatalogPrivilege.CATALOG_DETACH_POLICY);
        Stream<CatalogGrant> catalogGrants = policyPrivilegesOnCatalog.stream().map(p -> new CatalogGrant(p, GrantResource.TypeEnum.CATALOG));
        catalogGrants.forEach(g -> managementApi.addGrant(this.currentCatalogName, CATALOG_ROLE_2, (GrantResource)g));
        ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, CATALOG_ROLE_2)).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).map(gr -> ((CatalogGrant)gr).getPrivilege()).containsExactlyInAnyOrderElementsOf(policyPrivilegesOnCatalog);
    }

    @Test
    public void testGrantsOnTable() {
        this.restCatalog.createNamespace(NS2);
        try {
            managementApi.createCatalogRole(this.currentCatalogName, CATALOG_ROLE_2);
            this.restCatalog.buildTable(NS2_T1, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"string", (Type)Types.StringType.get())})).create();
            List<TablePrivilege> policyPrivilegesOnTable = List.of(TablePrivilege.TABLE_ATTACH_POLICY, TablePrivilege.TABLE_DETACH_POLICY);
            Stream<TableGrant> tableGrants = policyPrivilegesOnTable.stream().map(p -> new TableGrant(Arrays.asList(NS2.levels()), NS2_T1.name(), p, GrantResource.TypeEnum.TABLE));
            tableGrants.forEach(g -> managementApi.addGrant(this.currentCatalogName, CATALOG_ROLE_2, (GrantResource)g));
            ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, CATALOG_ROLE_2)).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).map(gr -> ((TableGrant)gr).getPrivilege()).containsExactlyInAnyOrderElementsOf(policyPrivilegesOnTable);
        }
        finally {
            policyApi.purge(this.currentCatalogName, NS2);
        }
    }

    private static ApplicablePolicy policyToApplicablePolicy(Policy policy, boolean inherited, Namespace parent) {
        return new ApplicablePolicy(policy.getPolicyType(), policy.getInheritable(), policy.getName(), policy.getDescription(), policy.getContent(), policy.getVersion(), Boolean.valueOf(inherited), Arrays.asList(parent.levels()));
    }

    static {
        DEFAULT_CATALOG_PROPERTIES = new String[]{"polaris.config.allow.unstructured.table.location", "true", "polaris.config.allow.external.table.location", "true"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CatalogConfig {
        public Catalog.TypeEnum value() default Catalog.TypeEnum.INTERNAL;

        public String[] properties() default {"polaris.config.allow.unstructured.table.location", "true", "polaris.config.allow.external.table.location", "true"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface RestCatalogConfig {
        public String[] value() default {};
    }
}

