/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.test;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.AzureStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.CatalogRoles;
import org.apache.polaris.core.admin.model.Catalogs;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.CreatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.GcpStorageConfigInfo;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.NamespacePrivilege;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.PrincipalRoles;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.Principals;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.service.it.env.CatalogApi;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.ManagementApi;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;
import org.apache.polaris.service.it.ext.PolarisIntegrationTestExtension;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={PolarisIntegrationTestExtension.class})
public class PolarisManagementServiceIntegrationTest {
    private static final int MAX_IDENTIFIER_LENGTH = 256;
    private static final String ISSUER_KEY = "polaris";
    private static final String CLAIM_KEY_ACTIVE = "active";
    private static final String CLAIM_KEY_CLIENT_ID = "client_id";
    private static final String CLAIM_KEY_PRINCIPAL_ID = "principalId";
    private static final String CLAIM_KEY_SCOPE = "scope";
    private static PolarisClient client;
    private static ManagementApi managementApi;
    private static CatalogApi catalogApi;
    private static ClientCredentials rootCredentials;

    @BeforeAll
    public static void setup(PolarisApiEndpoints endpoints, ClientCredentials credentials) {
        client = PolarisClient.polarisClient(endpoints);
        managementApi = client.managementApi(credentials);
        catalogApi = client.catalogApi(credentials);
        rootCredentials = credentials;
    }

    @AfterAll
    public static void close() throws Exception {
        client.close();
    }

    @AfterEach
    public void tearDown() {
        client.cleanUp(rootCredentials);
    }

    @Test
    public void testCatalogSerializing() throws IOException {
        CatalogProperties props = new CatalogProperties("s3://my-old-bucket/path/to/data");
        props.put((Object)"prop1", (Object)"propval");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName("my_catalog").setProperties(props).setStorageConfigInfo((StorageConfigInfo)AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build()).build();
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)catalog);
        System.out.println(json);
        Catalog deserialized = (Catalog)mapper.readValue(json, Catalog.class);
        Assertions.assertThat((Object)deserialized).isInstanceOf(PolarisCatalog.class);
    }

    @Test
    public void testListCatalogs() {
        try (Response response = managementApi.request("v1/catalogs").get();){
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Catalogs)r.readEntity(Catalogs.class)).returns(List.of(), l -> l.getCatalogs().stream().filter(c -> !c.getName().equalsIgnoreCase("ROOT")).toList());
        }
    }

    @Test
    public void testListCatalogsUnauthorized() {
        PrincipalWithCredentials principal = managementApi.createPrincipal(client.newEntityName("a_new_user"));
        try (Response response = client.managementApi(principal).request("v1/catalogs").get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testCreateCatalog() {
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)"{\"catalog\":{\"type\":\"INTERNAL\",\"name\":\"my-catalog\",\"properties\":{\"default-base-location\":\"s3://my-bucket/path/to/data\"},\"storageConfigInfo\":{\"storageType\":\"S3\",\"roleArn\":\"arn:aws:iam::123456789012:role/my-role\",\"externalId\":\"externalId\",\"userArn\":\"userArn\",\"allowedLocations\":[\"s3://my-old-bucket/path/to/data\"]}}}"));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/catalogs/my-catalog").delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testCreateCatalogWithInvalidName() {
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        String goodName = RandomStringUtils.random((int)256, (boolean)true, (boolean)true);
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(goodName).setProperties(new CatalogProperties("s3://my-bucket/path/to/data")).setStorageConfigInfo((StorageConfigInfo)awsConfigModel).build();
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)catalog));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidCatalogNames = Arrays.asList(longInvalidName, "", "system$catalog1", "SYSTEM$TestCatalog", "System$test_catalog", "  SysTeM$ test catalog");
        for (String invalidCatalogName : invalidCatalogNames) {
            catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(invalidCatalogName).setProperties(new CatalogProperties("s3://my-bucket/path/to/data")).setStorageConfigInfo((StorageConfigInfo)awsConfigModel).build();
            Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)catalog));
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testCreateCatalogWithAzureStorageConfig() {
        AzureStorageConfigInfo azureConfigInfo = AzureStorageConfigInfo.builder().setConsentUrl("https://consent.url").setMultiTenantAppName("myappname").setTenantId("tenantId").setStorageType(StorageConfigInfo.StorageTypeEnum.AZURE).build();
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName("my-catalog").setProperties(new CatalogProperties("abfss://polaris@polarisdev.dfs.core.windows.net/path/to/my/data/")).setStorageConfigInfo((StorageConfigInfo)azureConfigInfo).build();
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)new CreateCatalogRequest((Catalog)catalog)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/catalogs/my-catalog").get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            Catalog catResponse = (Catalog)response.readEntity(Catalog.class);
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)catResponse.getStorageConfigInfo()).isInstanceOf(AzureStorageConfigInfo.class)).hasFieldOrPropertyWithValue("consentUrl", (Object)"https://consent.url")).hasFieldOrPropertyWithValue("multiTenantAppName", (Object)"myappname")).hasFieldOrPropertyWithValue("allowedLocations", List.of("abfss://polaris@polarisdev.dfs.core.windows.net/path/to/my/data/"));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testCreateCatalogWithGcpStorageConfig() {
        GcpStorageConfigInfo gcpConfigModel = GcpStorageConfigInfo.builder().setGcsServiceAccount("my-sa").setStorageType(StorageConfigInfo.StorageTypeEnum.GCS).build();
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(client.newEntityName("my-catalog")).setProperties(new CatalogProperties("gs://my-bucket/path/to/data")).setStorageConfigInfo((StorageConfigInfo)gcpConfigModel).build();
        managementApi.createCatalog((Catalog)catalog);
        try (Response response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalog.getName())).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            Catalog catResponse = (Catalog)response.readEntity(Catalog.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)catResponse.getStorageConfigInfo()).isInstanceOf(GcpStorageConfigInfo.class)).hasFieldOrPropertyWithValue("gcsServiceAccount", (Object)"my-sa")).hasFieldOrPropertyWithValue("allowedLocations", List.of("gs://my-bucket/path/to/data"));
        }
    }

    @Test
    public void testCreateCatalogWithNullBaseLocation() {
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode storageConfig = mapper.valueToTree((Object)awsConfigModel);
        ObjectNode catalogNode = mapper.createObjectNode();
        catalogNode.set("storageConfigInfo", storageConfig);
        catalogNode.put("name", "my-catalog");
        catalogNode.put("type", "INTERNAL");
        catalogNode.set("properties", (JsonNode)mapper.createObjectNode());
        ObjectNode requestNode = mapper.createObjectNode();
        requestNode.set("catalog", (JsonNode)catalogNode);
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)requestNode));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testCreateCatalogWithoutProperties() {
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode storageConfig = mapper.valueToTree((Object)awsConfigModel);
        ObjectNode catalogNode = mapper.createObjectNode();
        catalogNode.set("storageConfigInfo", storageConfig);
        catalogNode.put("name", "my-catalog");
        catalogNode.put("type", "INTERNAL");
        ObjectNode requestNode = mapper.createObjectNode();
        requestNode.set("catalog", (JsonNode)catalogNode);
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)requestNode));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
            ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ((ObjectAssert)Assertions.assertThat((Object)error).isNotNull()).returns((Object)"Invalid value: createCatalog.arg0.catalog.properties: must not be null", ErrorResponse::message);
        }
    }

    @Test
    public void testCreateCatalogWithoutStorageConfig() {
        String catalogString = "{\"catalog\": {\"type\":\"INTERNAL\",\"name\":\"my-catalog\",\"properties\":{\"default-base-location\":\"s3://my-bucket/path/to/data\"}}}";
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)catalogString));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
            ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ((ObjectAssert)Assertions.assertThat((Object)error).isNotNull()).returns((Object)"Invalid value: createCatalog.arg0.catalog.storageConfigInfo: must not be null", ErrorResponse::message);
        }
    }

    @Test
    public void testCreateCatalogWithUnparsableJson() {
        String catalogString = "{\"catalog\": {{\"bad data}";
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)catalogString));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
            ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ((ObjectAssert)Assertions.assertThat((Object)error).isNotNull()).extracting(ErrorResponse::message).isNotNull();
        }
    }

    @Test
    public void testUpdateCatalogWithoutDefaultBaseLocationInUpdate() {
        Catalog fetchedCatalog;
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        String catalogName = client.newEntityName("testUpdateCatalogWithoutDefaultBaseLocationInUpdate");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setProperties(new CatalogProperties("s3://bucket/path/to/data")).setStorageConfigInfo((StorageConfigInfo)awsConfigModel).build();
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)new CreateCatalogRequest((Catalog)catalog)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((String)fetchedCatalog.getName()).isEqualTo(catalogName);
            Assertions.assertThat((Map)fetchedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "s3://bucket/path/to/data"));
            Assertions.assertThat((Integer)fetchedCatalog.getEntityVersion()).isGreaterThan(0);
        }
        UpdateCatalogRequest updateRequest = new UpdateCatalogRequest(fetchedCatalog.getEntityVersion(), Map.of("foo", "bar"), null);
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            Catalog updatedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((String)updatedCatalog.getName()).isEqualTo(catalogName);
            Assertions.assertThat((Map)updatedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "s3://bucket/path/to/data", "foo", "bar"));
            Assertions.assertThat((Integer)updatedCatalog.getEntityVersion()).isGreaterThan(0);
        }
    }

    @Test
    public void testCreateExternalCatalog() {
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        String catalogName = client.newEntityName("my-external-catalog");
        ExternalCatalog catalog = ExternalCatalog.builder().setType(Catalog.TypeEnum.EXTERNAL).setName(catalogName).setProperties(new CatalogProperties("s3://my-bucket/path/to/data")).setStorageConfigInfo((StorageConfigInfo)awsConfigModel).build();
        managementApi.createCatalog((Catalog)catalog);
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            Catalog fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            ((ObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)fetchedCatalog).isNotNull()).isInstanceOf(ExternalCatalog.class)).asInstanceOf(InstanceOfAssertFactories.type(ExternalCatalog.class))).extracting(Catalog::getStorageConfigInfo).isNotNull()).isInstanceOf(AwsStorageConfigInfo.class)).asInstanceOf(InstanceOfAssertFactories.type(AwsStorageConfigInfo.class))).returns((Object)"arn:aws:iam::123456789012:role/my-role", AwsStorageConfigInfo::getRoleArn);
        }
        managementApi.deleteCatalog(catalogName);
    }

    @Test
    public void testCreateCatalogWithoutDefaultLocation() {
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode storageConfig = mapper.valueToTree((Object)awsConfigModel);
        ObjectNode catalogNode = mapper.createObjectNode();
        catalogNode.set("storageConfigInfo", storageConfig);
        catalogNode.put("name", "my-catalog");
        catalogNode.put("type", "INTERNAL");
        ObjectNode properties = mapper.createObjectNode();
        properties.set("default-base-location", mapper.nullNode());
        catalogNode.set("properties", (JsonNode)properties);
        ObjectNode requestNode = mapper.createObjectNode();
        requestNode.set("catalog", (JsonNode)catalogNode);
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)requestNode));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void serialization() {
        CatalogProperties properties = new CatalogProperties("s3://my-bucket/path/to/data");
        ObjectMapper mapper = new ObjectMapper();
        CatalogProperties translated = (CatalogProperties)mapper.convertValue((Object)properties, CatalogProperties.class);
        Assertions.assertThat((Map)translated.toMap()).containsEntry((Object)"default-base-location", (Object)"s3://my-bucket/path/to/data");
    }

    @Test
    public void testCreateAndUpdateAzureCatalog() {
        Catalog fetchedCatalog;
        AzureStorageConfigInfo storageConfig = new AzureStorageConfigInfo("azure:tenantid:12345", StorageConfigInfo.StorageTypeEnum.AZURE);
        String catalogName = client.newEntityName("myazurecatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)storageConfig).setProperties(new CatalogProperties("abfss://container1@acct1.dfs.core.windows.net/")).build();
        managementApi.createCatalog((Catalog)catalog);
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((String)fetchedCatalog.getName()).isEqualTo(catalogName);
            Assertions.assertThat((Map)fetchedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "abfss://container1@acct1.dfs.core.windows.net/"));
            Assertions.assertThat((Integer)fetchedCatalog.getEntityVersion()).isGreaterThan(0);
        }
        AzureStorageConfigInfo modifiedStorageConfig = new AzureStorageConfigInfo("azure:tenantid:22222", StorageConfigInfo.StorageTypeEnum.AZURE);
        UpdateCatalogRequest badUpdateRequest = new UpdateCatalogRequest(fetchedCatalog.getEntityVersion(), Map.of("default-base-location", "abfss://newcontainer@acct1.dfs.core.windows.net/"), (StorageConfigInfo)modifiedStorageConfig);
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).put(Entity.json((Object)badUpdateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
            ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ((ObjectAssert)Assertions.assertThat((Object)error).isNotNull()).extracting(ErrorResponse::message).asString().startsWith((CharSequence)"Cannot modify");
        }
        UpdateCatalogRequest updateRequest = new UpdateCatalogRequest(fetchedCatalog.getEntityVersion(), Map.of("default-base-location", "abfss://newcontainer@acct1.dfs.core.windows.net/"), (StorageConfigInfo)storageConfig);
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((Map)fetchedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "abfss://newcontainer@acct1.dfs.core.windows.net/"));
        }
        response = managementApi.request("v1/catalogs/" + catalogName).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testCreateListUpdateAndDeleteCatalog() {
        Catalog fetchedCatalog;
        AwsStorageConfigInfo storageConfig = new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3);
        String catalogName = client.newEntityName("mycatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)storageConfig).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)new CreateCatalogRequest((Catalog)catalog)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CONFLICT.getStatusCode(), Response::getStatus);
        }
        try (Response response = managementApi.request("v1/catalogs/" + catalogName).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((String)fetchedCatalog.getName()).isEqualTo(catalogName);
            Assertions.assertThat((Map)fetchedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "s3://bucket1/"));
            Assertions.assertThat((Integer)fetchedCatalog.getEntityVersion()).isGreaterThan(0);
        }
        response = managementApi.request("v1/catalogs").get();
        try {
            ((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Catalogs)r.readEntity(Catalogs.class)).extracting(Catalogs::getCatalogs).asInstanceOf(InstanceOfAssertFactories.list(Catalog.class))).filteredOn(cat -> !cat.getName().equalsIgnoreCase("ROOT"))).satisfiesExactly(new ThrowingConsumer[]{cat -> Assertions.assertThat((Object)cat).returns((Object)catalogName, Catalog::getName)});
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        AwsStorageConfigInfo invalidModifiedStorageConfig = new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3);
        UpdateCatalogRequest badUpdateRequest = new UpdateCatalogRequest(fetchedCatalog.getEntityVersion(), Map.of("default-base-location", "s3://newbucket/"), (StorageConfigInfo)invalidModifiedStorageConfig);
        try (Response response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).put(Entity.json((Object)badUpdateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
            ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ((ObjectAssert)Assertions.assertThat((Object)error).isNotNull()).extracting(ErrorResponse::message).asString().startsWith((CharSequence)"Cannot modify");
        }
        AwsStorageConfigInfo validModifiedStorageConfig = new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3);
        UpdateCatalogRequest updateRequest = new UpdateCatalogRequest(fetchedCatalog.getEntityVersion(), Map.of("default-base-location", "s3://newbucket/"), (StorageConfigInfo)validModifiedStorageConfig);
        try (Response response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((Map)fetchedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "s3://newbucket/"));
            ((ObjectAssert)Assertions.assertThat((Object)fetchedCatalog.getStorageConfigInfo()).isInstanceOf(AwsStorageConfigInfo.class)).hasFieldOrPropertyWithValue("roleArn", (Object)"arn:aws:iam::123456789011:role/newrole");
        }
        response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalog = (Catalog)response.readEntity(Catalog.class);
            Assertions.assertThat((Map)fetchedCatalog.getProperties().toMap()).isEqualTo(Map.of("default-base-location", "s3://newbucket/"));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NOT_FOUND.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs").get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Catalogs)r.readEntity(Catalogs.class)).returns(List.of(), c -> c.getCatalogs().stream().filter(cat -> !cat.getName().equalsIgnoreCase("ROOT")).toList());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testGetCatalogNotFound() {
        try (Response response = managementApi.request("v1/catalogs/mycatalog").get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NOT_FOUND.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testGetCatalogInvalidName() {
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidCatalogNames = Arrays.asList(longInvalidName, "system$catalog1", "SYSTEM$TestCatalog", "System$test_catalog", "  SysTeM$ test catalog");
        for (String invalidCatalogName : invalidCatalogNames) {
            Response response = managementApi.request("v1/catalogs/" + invalidCatalogName).get();
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testCatalogRoleInvalidName() {
        String catalogName = client.newEntityName("mycatalog1");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setProperties(new CatalogProperties("s3://required/base/location")).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).build();
        managementApi.createCatalog((Catalog)catalog);
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidCatalogRoleNames = Arrays.asList(longInvalidName, "system$catalog1", "SYSTEM$TestCatalog", "System$test_catalog", "  SysTeM$ test catalog");
        for (String invalidCatalogRoleName : invalidCatalogRoleNames) {
            Response response = managementApi.request("v1/catalogs/mycatalog1/catalog-roles/" + invalidCatalogRoleName).get();
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testListPrincipalsUnauthorized() {
        PrincipalWithCredentials principal = managementApi.createPrincipal(client.newEntityName("new_admin"));
        try (Response response = client.managementApi(principal).request("v1/principals").get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testCreatePrincipalAndRotateCredentials() {
        PrincipalWithCredentials newCreds;
        Principal principal = Principal.builder().setName(client.newEntityName("myprincipal")).setProperties(Map.of("custom-tag", "foo")).build();
        PrincipalWithCredentials creds = managementApi.createPrincipal(new CreatePrincipalRequest(principal, Boolean.valueOf(true)));
        Assertions.assertThat((String)creds.getCredentials().getClientId()).isEqualTo(creds.getPrincipal().getClientId());
        try (Response response = managementApi.request("v1/principals/{p}/rotate", Map.of("p", principal.getName())).post(Entity.json((Object)""));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
        String oldUserToken = client.obtainToken(creds);
        try (Response response = client.managementApi(oldUserToken).request("v1/principals/{p}", Map.of("p", principal.getName())).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
            ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ((ObjectAssert)Assertions.assertThat((Object)error).isNotNull()).extracting(ErrorResponse::message).asString().contains(new CharSequence[]{"PRINCIPAL_CREDENTIAL_ROTATION_REQUIRED_STATE"});
        }
        try (Response response = client.managementApi(oldUserToken).request("v1/principals/{p}/rotate", Map.of("p", principal.getName())).post(Entity.json((Object)""));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            newCreds = (PrincipalWithCredentials)response.readEntity(PrincipalWithCredentials.class);
        }
        Assertions.assertThat((String)newCreds.getCredentials().getClientId()).isEqualTo(newCreds.getPrincipal().getClientId());
        Assertions.assertThat((String)newCreds.getCredentials().getClientId()).isEqualTo(creds.getCredentials().getClientId());
        Assertions.assertThat((String)newCreds.getCredentials().getClientSecret()).isNotEqualTo((Object)creds.getCredentials().getClientSecret());
    }

    @Test
    public void testCreateFederatedPrincipalRoleSucceeds() {
        PrincipalRole federatedPrincipalRole = new PrincipalRole(client.newEntityName("federatedRole"), Boolean.valueOf(true), Map.of(), Long.valueOf(Instant.now().toEpochMilli()), Long.valueOf(Instant.now().toEpochMilli()), Integer.valueOf(1));
        try (Response createResponse = managementApi.request("v1/principal-roles").post(Entity.json((Object)new CreatePrincipalRoleRequest(federatedPrincipalRole)));){
            Assertions.assertThat((Object)createResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testCreateListUpdateAndDeletePrincipal() {
        Principal fetchedPrincipal;
        Principal principal = Principal.builder().setName(client.newEntityName("myprincipal")).setProperties(Map.of("custom-tag", "foo")).build();
        managementApi.createPrincipal(new CreatePrincipalRequest(principal, null));
        try (Response response = managementApi.request("v1/principals").post(Entity.json((Object)new CreatePrincipalRequest(principal, Boolean.valueOf(false))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CONFLICT.getStatusCode(), Response::getStatus);
        }
        try (Response response = managementApi.request("v1/principals/{p}", Map.of("p", principal.getName())).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedPrincipal = (Principal)response.readEntity(Principal.class);
            Assertions.assertThat((String)fetchedPrincipal.getName()).isEqualTo(principal.getName());
            Assertions.assertThat((Map)fetchedPrincipal.getProperties()).isEqualTo(Map.of("custom-tag", "foo"));
            Assertions.assertThat((Integer)fetchedPrincipal.getEntityVersion()).isGreaterThan(0);
        }
        response = managementApi.request("v1/principals").get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Principals)r.readEntity(Principals.class)).extracting(Principals::getPrincipals).asInstanceOf(InstanceOfAssertFactories.list(Principal.class))).anySatisfy(pr -> Assertions.assertThat((Object)pr).returns((Object)principal.getName(), Principal::getName));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        UpdatePrincipalRequest updateRequest = new UpdatePrincipalRequest(fetchedPrincipal.getEntityVersion(), Map.of("custom-tag", "updated"));
        try (Response response = managementApi.request("v1/principals/{p}", Map.of("p", principal.getName())).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedPrincipal = (Principal)response.readEntity(Principal.class);
            Assertions.assertThat((Map)fetchedPrincipal.getProperties()).isEqualTo(Map.of("custom-tag", "updated"));
        }
        response = managementApi.request("v1/principals/{p}", Map.of("p", principal.getName())).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedPrincipal = (Principal)response.readEntity(Principal.class);
            Assertions.assertThat((Map)fetchedPrincipal.getProperties()).isEqualTo(Map.of("custom-tag", "updated"));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        managementApi.deletePrincipal(principal);
        response = managementApi.request("v1/principals/{prince}", Map.of("prince", principal.getName())).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NOT_FOUND.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principals").get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Principals)r.readEntity(Principals.class)).extracting(Principals::getPrincipals).asInstanceOf(InstanceOfAssertFactories.list(Principal.class))).noneSatisfy(pr -> Assertions.assertThat((Object)pr).returns((Object)principal.getName(), Principal::getName));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testCreatePrincipalWithInvalidName() {
        String goodName = RandomStringUtils.random((int)256, (boolean)true, (boolean)true);
        Principal principal = Principal.builder().setName(goodName).setProperties(Map.of("custom-tag", "good_principal")).build();
        managementApi.createPrincipal(new CreatePrincipalRequest(principal, null));
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidPrincipalNames = Arrays.asList(longInvalidName, "", "system$principal1", "SYSTEM$TestPrincipal", "System$test_principal", "  SysTeM$ principal");
        for (String invalidPrincipalName : invalidPrincipalNames) {
            principal = Principal.builder().setName(invalidPrincipalName).setProperties(Map.of("custom-tag", "bad_principal")).build();
            Response response = managementApi.request("v1/principals").post(Entity.json((Object)new CreatePrincipalRequest(principal, Boolean.valueOf(false))));
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testGetPrincipalWithInvalidName() {
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidPrincipalNames = Arrays.asList(longInvalidName, "system$principal1", "SYSTEM$TestPrincipal", "System$test_principal", "  SysTeM$ principal");
        for (String invalidPrincipalName : invalidPrincipalNames) {
            Response response = managementApi.request("v1/principals/" + invalidPrincipalName).get();
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testCreateListUpdateAndDeletePrincipalRole() {
        PrincipalRole fetchedPrincipalRole;
        PrincipalRole principalRole = new PrincipalRole(client.newEntityName("myprincipalrole"), Boolean.valueOf(false), Map.of("custom-tag", "foo"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        managementApi.createPrincipalRole(principalRole);
        try (Response response = managementApi.request("v1/principal-roles").post(Entity.json((Object)new CreatePrincipalRoleRequest(principalRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CONFLICT.getStatusCode(), Response::getStatus);
        }
        try (Response response = managementApi.request("v1/principal-roles/{pr}", Map.of("pr", principalRole.getName())).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedPrincipalRole = (PrincipalRole)response.readEntity(PrincipalRole.class);
            Assertions.assertThat((String)fetchedPrincipalRole.getName()).isEqualTo(principalRole.getName());
            Assertions.assertThat((Map)fetchedPrincipalRole.getProperties()).isEqualTo(Map.of("custom-tag", "foo"));
            Assertions.assertThat((Integer)fetchedPrincipalRole.getEntityVersion()).isGreaterThan(0);
        }
        response = managementApi.request("v1/principal-roles").get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).extracting(PrincipalRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(PrincipalRole.class))).anySatisfy(pr -> Assertions.assertThat((Object)pr).returns((Object)principalRole.getName(), PrincipalRole::getName));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        UpdatePrincipalRoleRequest updateRequest = new UpdatePrincipalRoleRequest(fetchedPrincipalRole.getEntityVersion(), Map.of("custom-tag", "updated"));
        try (Response response = managementApi.request("v1/principal-roles/{pr}", Map.of("pr", principalRole.getName())).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedPrincipalRole = (PrincipalRole)response.readEntity(PrincipalRole.class);
            Assertions.assertThat((Map)fetchedPrincipalRole.getProperties()).isEqualTo(Map.of("custom-tag", "updated"));
        }
        response = managementApi.request("v1/principal-roles/{pr}", Map.of("pr", principalRole.getName())).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedPrincipalRole = (PrincipalRole)response.readEntity(PrincipalRole.class);
            Assertions.assertThat((Map)fetchedPrincipalRole.getProperties()).isEqualTo(Map.of("custom-tag", "updated"));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        managementApi.deletePrincipalRole(principalRole);
        response = managementApi.request("v1/principal-roles/{pr}", Map.of("pr", principalRole.getName())).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NOT_FOUND.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles").get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).extracting(PrincipalRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(PrincipalRole.class))).noneSatisfy(pr -> Assertions.assertThat((Object)pr).returns((Object)principalRole.getName(), PrincipalRole::getName));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testCreatePrincipalRoleInvalidName() {
        String goodName = RandomStringUtils.random((int)256, (boolean)true, (boolean)true);
        PrincipalRole principalRole = new PrincipalRole(goodName, Boolean.valueOf(false), Map.of("custom-tag", "good_principal_role"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        managementApi.createPrincipalRole(principalRole);
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidPrincipalRoleNames = Arrays.asList(longInvalidName, "", "system$principalrole1", "SYSTEM$TestPrincipalRole", "System$test_principal_role", "  SysTeM$ principal role");
        for (String invalidPrincipalRoleName : invalidPrincipalRoleNames) {
            principalRole = new PrincipalRole(invalidPrincipalRoleName, Boolean.valueOf(false), Map.of("custom-tag", "bad_principal_role"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
            Response response = managementApi.request("v1/principal-roles").post(Entity.json((Object)new CreatePrincipalRoleRequest(principalRole)));
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testGetPrincipalRoleInvalidName() {
        String longInvalidName = RandomStringUtils.random((int)257, (boolean)true, (boolean)true);
        List<String> invalidPrincipalRoleNames = Arrays.asList(longInvalidName, "system$principalrole1", "SYSTEM$TestPrincipalRole", "System$test_principal_role", "  SysTeM$ principal role");
        for (String invalidPrincipalRoleName : invalidPrincipalRoleNames) {
            Response response = managementApi.request("v1/principal-roles/" + invalidPrincipalRoleName).get();
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
                Assertions.assertThat((boolean)response.hasEntity()).isTrue();
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                Assertions.assertThat((String)errorResponse.message()).contains(new CharSequence[]{"Invalid value:"});
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testCreateListUpdateAndDeleteCatalogRole() {
        CatalogRole fetchedCatalogRole;
        String catalogName = client.newEntityName("mycatalog1");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setProperties(new CatalogProperties("s3://required/base/location")).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).build();
        managementApi.createCatalog((Catalog)catalog);
        String catalogName2 = client.newEntityName("mycatalog2");
        PolarisCatalog catalog2 = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName2).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://required/base/other_location")).build();
        managementApi.createCatalog((Catalog)catalog2);
        CatalogRole catalogRole = new CatalogRole("mycatalogrole", Map.of("custom-tag", "foo"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).post(Entity.json((Object)new CreateCatalogRoleRequest(catalogRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).post(Entity.json((Object)new CreateCatalogRoleRequest(catalogRole)));
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CONFLICT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycatalogrole", Map.of("cat", catalogName)).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalogRole = (CatalogRole)response.readEntity(CatalogRole.class);
            Assertions.assertThat((String)fetchedCatalogRole.getName()).isEqualTo("mycatalogrole");
            Assertions.assertThat((Map)fetchedCatalogRole.getProperties()).isEqualTo(Map.of("custom-tag", "foo"));
            Assertions.assertThat((Integer)fetchedCatalogRole.getEntityVersion()).isGreaterThan(0);
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (CatalogRoles)r.readEntity(CatalogRoles.class)).extracting(CatalogRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(CatalogRole.class))).anySatisfy(cr -> Assertions.assertThat((Object)cr).returns((Object)"mycatalogrole", CatalogRole::getName));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName2)).get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (CatalogRoles)r.readEntity(CatalogRoles.class)).extracting(CatalogRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(CatalogRole.class))).satisfiesExactly(new ThrowingConsumer[]{cr -> Assertions.assertThat((Object)cr).returns((Object)PolarisEntityConstants.getNameOfCatalogAdminRole(), CatalogRole::getName)});
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        UpdateCatalogRoleRequest updateRequest = new UpdateCatalogRoleRequest(fetchedCatalogRole.getEntityVersion(), Map.of("custom-tag", "updated"));
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycatalogrole", Map.of("cat", catalogName)).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalogRole = (CatalogRole)response.readEntity(CatalogRole.class);
            Assertions.assertThat((Map)fetchedCatalogRole.getProperties()).isEqualTo(Map.of("custom-tag", "updated"));
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycatalogrole", Map.of("cat", catalogName)).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            fetchedCatalogRole = (CatalogRole)response.readEntity(CatalogRole.class);
            Assertions.assertThat((Map)fetchedCatalogRole.getProperties()).isEqualTo(Map.of("custom-tag", "updated"));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycatalogrole", Map.of("cat", catalogName)).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycatalogrole", Map.of("cat", catalogName)).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NOT_FOUND.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).get();
        try {
            ((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (CatalogRoles)r.readEntity(CatalogRoles.class)).extracting(CatalogRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(CatalogRole.class))).noneSatisfy(cr -> Assertions.assertThat((Object)cr).returns((Object)"mycatalogrole", CatalogRole::getName));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}", Map.of("cat", catalogName2)).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testAssignListAndRevokePrincipalRoles() {
        Principal principal1 = new Principal(client.newEntityName("myprincipal1"));
        try (Response response = managementApi.request("v1/principals").post(Entity.json((Object)new CreatePrincipalRequest(principal1, Boolean.valueOf(false))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        Principal principal2 = new Principal(client.newEntityName("myprincipal2"));
        try (Response response = managementApi.request("v1/principals").post(Entity.json((Object)new CreatePrincipalRequest(principal2, Boolean.valueOf(false))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        PrincipalRole principalRole = new PrincipalRole(client.newEntityName("myprincipalrole"));
        managementApi.createPrincipalRole(principalRole);
        try (Response response = managementApi.request("v1/principals/{prince}/principal-roles", Map.of("prince", principal1.getName())).put(Entity.json((Object)principalRole));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/principals/{prince}/principal-roles", Map.of("prince", principal1.getName())).get();
        try {
            ((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).extracting(PrincipalRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(PrincipalRole.class))).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{pr -> Assertions.assertThat((Object)pr).returns((Object)principalRole.getName(), PrincipalRole::getName)});
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/principals", Map.of("pr", principalRole.getName())).get();
        try {
            ((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Principals)r.readEntity(Principals.class)).extracting(Principals::getPrincipals).asInstanceOf(InstanceOfAssertFactories.list(Principal.class))).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{pr -> Assertions.assertThat((Object)pr).returns((Object)principal1.getName(), Principal::getName)});
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principals/{prince}/principal-roles", Map.of("prince", principal2.getName())).get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).returns(List.of(), PrincipalRoles::getRoles);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principals/{prince}/principal-roles/{pr}", Map.of("prince", principal1.getName(), "pr", principalRole.getName())).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principals/{prince}/principal-roles", Map.of("prince", principal1.getName())).get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).returns(List.of(), PrincipalRoles::getRoles);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/principals", Map.of("pr", principalRole.getName())).get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (Principals)r.readEntity(Principals.class)).returns(List.of(), Principals::getPrincipals);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principals/{prince}", Map.of("prince", principal1.getName())).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principals/{prince}", Map.of("prince", principal2.getName())).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}", Map.of("pr", principalRole.getName())).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testAssignListAndRevokeCatalogRoles() {
        PrincipalRole principalRole1 = new PrincipalRole(client.newEntityName("mypr1"));
        managementApi.createPrincipalRole(principalRole1);
        PrincipalRole principalRole2 = new PrincipalRole(client.newEntityName("mypr2"));
        managementApi.createPrincipalRole(principalRole2);
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(client.newEntityName("mycatalog")).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        CatalogRole catalogRole = new CatalogRole("mycr");
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalog.getName())).post(Entity.json((Object)new CreateCatalogRoleRequest(catalogRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        PolarisCatalog otherCatalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(client.newEntityName("othercatalog")).setProperties(new CatalogProperties("s3://path/to/data")).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).build();
        managementApi.createCatalog((Catalog)otherCatalog);
        CatalogRole otherCatalogRole = new CatalogRole("myothercr");
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", otherCatalog.getName())).post(Entity.json((Object)new CreateCatalogRoleRequest(otherCatalogRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/principal-roles/{pr}/catalog-roles/{cat}", Map.of("pr", principalRole1.getName(), "cat", catalog.getName())).put(Entity.json((Object)new GrantCatalogRoleRequest(catalogRole)));
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/catalog-roles/{cat}", Map.of("pr", principalRole1.getName(), "cat", otherCatalog.getName())).put(Entity.json((Object)new GrantCatalogRoleRequest(otherCatalogRole)));
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/catalog-roles/{cat}", Map.of("pr", principalRole1.getName(), "cat", catalog.getName())).get();
        try {
            ((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (CatalogRoles)r.readEntity(CatalogRoles.class)).extracting(CatalogRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(CatalogRole.class))).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{cr -> Assertions.assertThat((Object)cr).returns((Object)"mycr", CatalogRole::getName)});
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycr/principal-roles", Map.of("cat", catalog.getName())).get();
        try {
            ((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).extracting(PrincipalRoles::getRoles).asInstanceOf(InstanceOfAssertFactories.list(PrincipalRole.class))).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{pr -> Assertions.assertThat((Object)pr).returns((Object)principalRole1.getName(), PrincipalRole::getName)});
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/catalog-roles/{cat}", Map.of("pr", principalRole2.getName(), "cat", catalog.getName())).get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (CatalogRoles)r.readEntity(CatalogRoles.class)).returns(List.of(), CatalogRoles::getRoles);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/catalog-roles/{cat}/mycr", Map.of("pr", principalRole1.getName(), "cat", catalog.getName())).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/principal-roles/{pr}/catalog-roles/{cat}", Map.of("pr", principalRole1.getName(), "cat", catalog.getName())).get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (CatalogRoles)r.readEntity(CatalogRoles.class)).returns(List.of(), CatalogRoles::getRoles);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycr/principal-roles", Map.of("cat", catalog.getName())).get();
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus)).extracting(r -> (PrincipalRoles)r.readEntity(PrincipalRoles.class)).returns(List.of(), PrincipalRoles::getRoles);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        managementApi.deletePrincipalRole(principalRole1);
        managementApi.deletePrincipalRole(principalRole2);
        managementApi.deleteCatalogRole(catalog.getName(), "mycr");
        managementApi.deleteCatalog(catalog.getName());
        managementApi.deleteCatalogRole(otherCatalog.getName(), otherCatalogRole.getName());
        managementApi.deleteCatalog(otherCatalog.getName());
    }

    @Test
    public void testCatalogAdminGrantAndRevokeCatalogRoles() {
        String principalRoleName = client.newEntityName("mypr33");
        managementApi.createPrincipalRole(principalRoleName);
        String catalogName = client.newEntityName("myuniquetestcatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        CatalogRole catalogAdminRole = managementApi.getCatalogRole(catalogName, "catalog_admin");
        managementApi.grantCatalogRoleToPrincipalRole(principalRoleName, catalogName, catalogAdminRole);
        PrincipalWithCredentials catalogAdminPrincipal = managementApi.createPrincipal(client.newEntityName("principal1"));
        managementApi.assignPrincipalRole(catalogAdminPrincipal.getPrincipal().getName(), principalRoleName);
        String catalogAdminToken = client.obtainToken(catalogAdminPrincipal);
        String principalRoleName2 = "mypr2";
        PrincipalRole principalRole2 = new PrincipalRole(principalRoleName2);
        managementApi.createPrincipalRole(principalRole2);
        String catalogRoleName = "mycr1";
        client.managementApi(catalogAdminToken).createCatalogRole(catalogName, catalogRoleName);
        CatalogPrivilege privilege = CatalogPrivilege.CATALOG_MANAGE_CONTENT;
        client.managementApi(catalogAdminToken).addGrant(catalogName, catalogRoleName, (GrantResource)new CatalogGrant(privilege, GrantResource.TypeEnum.CATALOG));
        client.managementApi(catalogAdminToken).grantCatalogRoleToPrincipalRole(principalRoleName2, catalogName, new CatalogRole(catalogRoleName));
        try (Response response = client.managementApi(catalogAdminToken).request("v1/principal-roles/" + principalRoleName + "/catalog-roles/" + catalogName + "/" + catalogRoleName).delete();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/principal-roles/" + principalRoleName + "/catalog-roles/" + catalogName + "/" + catalogRoleName).delete();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceAdminCanTransferCatalogAdmin() {
        String principalRoleName = client.newEntityName("mypr33");
        PrincipalRole principalRole1 = new PrincipalRole(principalRoleName);
        managementApi.createPrincipalRole(principalRole1);
        String catalogName = client.newEntityName("myothertestcatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        CatalogRole catalogAdminRole = managementApi.getCatalogRole(catalogName, "catalog_admin");
        managementApi.grantCatalogRoleToPrincipalRole(principalRoleName, catalogName, catalogAdminRole);
        PrincipalWithCredentials catalogAdminPrincipal = managementApi.createPrincipal(client.newEntityName("principal1"));
        managementApi.assignPrincipalRole(catalogAdminPrincipal.getPrincipal().getName(), principalRole1.getName());
        String catalogAdminToken = client.obtainToken(catalogAdminPrincipal);
        try {
            try (Response response = managementApi.request("v1/principal-roles/service_admin/catalog-roles/" + catalogName + "/catalog_admin").delete();){
                Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
            }
            response = client.managementApi(catalogAdminToken).request("v1/principal-roles/" + principalRoleName + "/catalog-roles/" + catalogName + "/catalog_admin").delete();
            try {
                Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        finally {
            client.managementApi(catalogAdminToken).grantCatalogRoleToPrincipalRole("service_admin", catalogName, catalogAdminRole);
        }
    }

    @Test
    public void testCatalogAdminGrantAndRevokeCatalogRolesFromWrongCatalog() {
        String principalRoleName = client.newEntityName("mypr33");
        PrincipalRole principalRole1 = new PrincipalRole(principalRoleName);
        managementApi.createPrincipalRole(principalRole1);
        String catalogName = client.newEntityName("mytestcatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        String catalogName2 = client.newEntityName("anothercatalog");
        PolarisCatalog catalog2 = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName2).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog2);
        String catalogRoleName = "mycr1";
        managementApi.createCatalogRole(catalogName2, catalogRoleName);
        CatalogRole catalogAdminRole = managementApi.getCatalogRole(catalogName, "catalog_admin");
        managementApi.grantCatalogRoleToPrincipalRole(principalRoleName, catalogName, catalogAdminRole);
        PrincipalWithCredentials catalogAdminPrincipal = managementApi.createPrincipal(client.newEntityName("principal1"));
        managementApi.assignPrincipalRole(catalogAdminPrincipal.getPrincipal().getName(), principalRole1.getName());
        String catalogAdminToken = client.obtainToken(catalogAdminPrincipal);
        String principalRoleName2 = client.newEntityName("mypr2");
        PrincipalRole principalRole2 = new PrincipalRole(principalRoleName2);
        managementApi.createPrincipalRole(principalRole2);
        try (Response response = client.managementApi(catalogAdminToken).request("v1/principal-roles/" + principalRoleName + "/catalog-roles/" + catalogName2).put(Entity.json((Object)new GrantCatalogRoleRequest(new CatalogRole(catalogRoleName))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testTableManageAccessCanGrantAndRevokeFromCatalogRoles() {
        String principalRoleName = client.newEntityName("mypr33");
        PrincipalRole principalRole1 = new PrincipalRole(principalRoleName);
        managementApi.createPrincipalRole(principalRole1);
        String catalogName = client.newEntityName("mytablemanagecatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        managementApi.createCatalogRole(catalogName, "target_catalog_role");
        String catalogName2 = client.newEntityName("anothertablemanagecatalog");
        PolarisCatalog catalog2 = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName2).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog2);
        managementApi.createCatalogRole(catalogName2, "invalid_target_catalog_role");
        String namespaceName = "c";
        catalogApi.createNamespace(catalogName, namespaceName);
        catalogApi.createNamespace(catalogName2, namespaceName);
        String catalogRoleName = "ns_manage_access_role";
        managementApi.createCatalogRole(catalogName, catalogRoleName);
        managementApi.addGrant(catalogName, catalogRoleName, (GrantResource)new NamespaceGrant(List.of(namespaceName), NamespacePrivilege.CATALOG_MANAGE_ACCESS, GrantResource.TypeEnum.NAMESPACE));
        managementApi.grantCatalogRoleToPrincipalRole(principalRoleName, catalogName, new CatalogRole(catalogRoleName));
        PrincipalWithCredentials catalogAdminPrincipal = managementApi.createPrincipal(client.newEntityName("ns_manage_access_user"));
        managementApi.assignPrincipalRole(catalogAdminPrincipal.getPrincipal().getName(), principalRole1.getName());
        String manageAccessUserToken = client.obtainToken(catalogAdminPrincipal);
        client.managementApi(manageAccessUserToken).addGrant(catalogName, "target_catalog_role", (GrantResource)new NamespaceGrant(List.of(namespaceName), NamespacePrivilege.TABLE_CREATE, GrantResource.TypeEnum.NAMESPACE));
        try (Response response = client.managementApi(manageAccessUserToken).request("v1/principal-roles/" + principalRoleName + "/catalog-roles/" + catalogName).put(Entity.json((Object)new GrantCatalogRoleRequest(new CatalogRole("target_catalog_role"))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
        response = client.managementApi(manageAccessUserToken).request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", catalogName, "role", "target_catalog_role")).put(Entity.json((Object)new CatalogGrant(CatalogPrivilege.TABLE_CREATE, GrantResource.TypeEnum.CATALOG)));
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = client.managementApi(manageAccessUserToken).request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", catalogName2, "role", "invalid_target_catalog_role")).put(Entity.json((Object)new NamespaceGrant(List.of(namespaceName), NamespacePrivilege.TABLE_CREATE, GrantResource.TypeEnum.NAMESPACE)));
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = client.managementApi(manageAccessUserToken).request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", catalogName2, "role", "invalid_target_catalog_role")).put(Entity.json((Object)new CatalogGrant(CatalogPrivilege.TABLE_CREATE, GrantResource.TypeEnum.CATALOG)));
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.FORBIDDEN.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testTokenExpiry() {
        String newToken = PolarisManagementServiceIntegrationTest.defaultJwt().withExpiresAt(Instant.now().plus(1L, ChronoUnit.SECONDS)).sign(Algorithm.HMAC256((String)ISSUER_KEY));
        Awaitility.await((String)"expected list of records should be produced").atMost(Duration.ofSeconds(20L)).pollDelay(Duration.ofSeconds(1L)).pollInterval(Duration.ofSeconds(1L)).untilAsserted(() -> {
            try (Response response = client.managementApi(newToken).request("v1/principals").get();){
                Assertions.assertThat((Object)response).returns((Object)Response.Status.UNAUTHORIZED.getStatusCode(), Response::getStatus);
            }
        });
    }

    @Test
    public void testTokenInactive() {
        String newToken = PolarisManagementServiceIntegrationTest.defaultJwt().withClaim(CLAIM_KEY_ACTIVE, Boolean.valueOf(false)).sign(Algorithm.HMAC256((String)ISSUER_KEY));
        try (Response response = client.managementApi(newToken).request("v1/principals").get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.UNAUTHORIZED.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testTokenInvalidSignature() {
        String newToken = PolarisManagementServiceIntegrationTest.defaultJwt().sign(Algorithm.HMAC256((String)"invalid_secret"));
        try (Response response = client.managementApi(newToken).request("v1/principals").get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.UNAUTHORIZED.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testTokenInvalidPrincipalId() {
        String newToken = PolarisManagementServiceIntegrationTest.defaultJwt().withClaim(CLAIM_KEY_PRINCIPAL_ID, Integer.valueOf(0)).sign(Algorithm.HMAC256((String)ISSUER_KEY));
        try (Response response = client.managementApi(newToken).request("v1/principals").get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.UNAUTHORIZED.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testNamespaceExistsStatus() {
        String catalogName = client.newEntityName("mytablemanagecatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        String namespaceName = "c";
        catalogApi.createNamespace(catalogName, namespaceName);
        try (Response response = catalogApi.request("v1/" + catalogName + "/namespaces/" + namespaceName).head();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testDropNamespaceStatus() {
        String catalogName = client.newEntityName("mytablemanagecatalog");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).setProperties(new CatalogProperties("s3://bucket1/")).build();
        managementApi.createCatalog((Catalog)catalog);
        String namespaceName = "c";
        catalogApi.createNamespace(catalogName, namespaceName);
        try (Response response = catalogApi.request("v1/" + catalogName + "/namespaces/" + namespaceName).delete();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testCreateAndUpdateCatalogRoleWithReservedProperties() {
        String catalogName = client.newEntityName("mycatalog1");
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setProperties(new CatalogProperties("s3://required/base/location")).setStorageConfigInfo((StorageConfigInfo)new AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.S3)).build();
        managementApi.createCatalog((Catalog)catalog);
        CatalogRole badCatalogRole = new CatalogRole("mycatalogrole", Map.of("polaris.reserved", "foo"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).post(Entity.json((Object)new CreateCatalogRoleRequest(badCatalogRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
        CatalogRole okCatalogRole = new CatalogRole("mycatalogrole", Map.of("foo", "bar"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).post(Entity.json((Object)new CreateCatalogRoleRequest(okCatalogRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        UpdateCatalogRoleRequest updateRequest = new UpdateCatalogRoleRequest(okCatalogRole.getEntityVersion(), Map.of("polaris.reserved", "true"));
        try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles/mycatalogrole", Map.of("cat", catalogName)).put(Entity.json((Object)updateRequest));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testCreateAndUpdatePrincipalRoleWithReservedProperties() {
        String principal = "testCreateAndUpdatePrincipalRoleWithReservedProperties";
        managementApi.createPrincipal(principal);
        PrincipalRole badPrincipalRole = new PrincipalRole(client.newEntityName("myprincipalrole"), Boolean.valueOf(false), Map.of("polaris.reserved", "foo"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/principal-roles").post(Entity.json((Object)new CreatePrincipalRoleRequest(badPrincipalRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
        PrincipalRole goodPrincipalRole = new PrincipalRole(client.newEntityName("myprincipalrole"), Boolean.valueOf(false), Map.of("not.reserved", "foo"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/principal-roles").post(Entity.json((Object)new CreatePrincipalRoleRequest(goodPrincipalRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        UpdatePrincipalRoleRequest badUpdate = new UpdatePrincipalRoleRequest(goodPrincipalRole.getEntityVersion(), (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)"true"));
        try (Response response = managementApi.request("v1/principal-roles/{pr}", Map.of("pr", goodPrincipalRole.getName())).put(Entity.json((Object)badUpdate));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
        managementApi.deletePrincipalRole(goodPrincipalRole);
        managementApi.deletePrincipal(principal);
    }

    @Test
    public void testCreateAndUpdatePrincipalWithReservedProperties() {
        String principal = "testCreateAndUpdatePrincipalWithReservedProperties";
        Principal badPrincipal = new Principal(principal, "clientId", (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)"true"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/principals").post(Entity.json((Object)new CreatePrincipalRequest(badPrincipal, Boolean.valueOf(false))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
        Principal goodPrincipal = new Principal(principal, "clientId", (Map)ImmutableMap.of((Object)"not.reserved", (Object)"true"), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(1));
        try (Response response = managementApi.request("v1/principals").post(Entity.json((Object)new CreatePrincipalRequest(goodPrincipal, Boolean.valueOf(false))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        UpdatePrincipalRequest badUpdate = new UpdatePrincipalRequest(goodPrincipal.getEntityVersion(), (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)"true"));
        try (Response response = managementApi.request("v1/principals/{p}", Map.of("p", goodPrincipal.getName())).put(Entity.json((Object)badUpdate));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus);
        }
        managementApi.deletePrincipal(principal);
    }

    public static JWTCreator.Builder defaultJwt() {
        Instant now = Instant.now();
        return JWT.create().withIssuer(ISSUER_KEY).withSubject(String.valueOf(1)).withIssuedAt(now).withExpiresAt(now.plus(10L, ChronoUnit.SECONDS)).withJWTId(UUID.randomUUID().toString()).withClaim(CLAIM_KEY_ACTIVE, Boolean.valueOf(true)).withClaim(CLAIM_KEY_CLIENT_ID, rootCredentials.clientId()).withClaim(CLAIM_KEY_PRINCIPAL_ID, Integer.valueOf(1)).withClaim(CLAIM_KEY_SCOPE, "PRINCIPAL_ROLE:ALL");
    }
}

