/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import jakarta.ws.rs.client.Client;
import java.util.Random;
import org.apache.iceberg.rest.RESTSerializers;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.service.it.env.CatalogApi;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.GenericTableApi;
import org.apache.polaris.service.it.env.ManagementApi;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolicyApi;
import org.apache.polaris.service.it.ext.PolarisServerManagerLoader;

public final class PolarisClient
implements AutoCloseable {
    private final PolarisApiEndpoints endpoints;
    private final Client client;
    private final String clientId = Long.toString(Math.abs(new Random().nextLong()), 36);

    private PolarisClient(PolarisApiEndpoints endpoints) {
        this.endpoints = endpoints;
        this.client = PolarisServerManagerLoader.polarisServerManager().createClient();
    }

    public static PolarisClient polarisClient(PolarisApiEndpoints endpoints) {
        return new PolarisClient(endpoints);
    }

    public static ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.KebabCaseStrategy());
        RESTSerializers.registerAll((ObjectMapper)mapper);
        return mapper;
    }

    public String newEntityName(String hint) {
        return PolarisServerManagerLoader.polarisServerManager().transformEntityName(hint + "_" + this.clientId);
    }

    public ManagementApi managementApi(String authToken) {
        return new ManagementApi(this.client, this.endpoints, authToken, this.endpoints.managementApiEndpoint());
    }

    public ManagementApi managementApi(ClientCredentials credentials) {
        return this.managementApi(this.obtainToken(credentials));
    }

    public ManagementApi managementApi(PrincipalWithCredentials principal) {
        return this.managementApi(this.obtainToken(principal));
    }

    public CatalogApi catalogApi(PrincipalWithCredentials principal) {
        return new CatalogApi(this.client, this.endpoints, this.obtainToken(principal), this.endpoints.catalogApiEndpoint());
    }

    public CatalogApi catalogApi(ClientCredentials credentials) {
        return new CatalogApi(this.client, this.endpoints, this.obtainToken(credentials), this.endpoints.catalogApiEndpoint());
    }

    public CatalogApi catalogApiPlain() {
        return new CatalogApi(this.client, this.endpoints, null, this.endpoints.catalogApiEndpoint());
    }

    public GenericTableApi genericTableApi(PrincipalWithCredentials principal) {
        return new GenericTableApi(this.client, this.endpoints, this.obtainToken(principal), this.endpoints.catalogApiEndpoint());
    }

    public GenericTableApi genericTableApi(ClientCredentials credentials) {
        return new GenericTableApi(this.client, this.endpoints, this.obtainToken(credentials), this.endpoints.catalogApiEndpoint());
    }

    public PolicyApi policyApi(PrincipalWithCredentials principal) {
        return new PolicyApi(this.client, this.endpoints, this.obtainToken(principal), this.endpoints.catalogApiEndpoint());
    }

    public PolicyApi policyApi(ClientCredentials credentials) {
        return new PolicyApi(this.client, this.endpoints, this.obtainToken(credentials), this.endpoints.catalogApiEndpoint());
    }

    public String obtainToken(PrincipalWithCredentials principal) {
        return this.obtainToken(new ClientCredentials(principal.getCredentials().getClientId(), principal.getCredentials().getClientSecret()));
    }

    public String obtainToken(ClientCredentials credentials) {
        return PolarisServerManagerLoader.polarisServerManager().accessManager(this.client).obtainAccessToken(this.endpoints, credentials);
    }

    private boolean ownedName(String name) {
        return name != null && name.contains(this.clientId);
    }

    public void cleanUp(ClientCredentials credentials) {
        ManagementApi managementApi = this.managementApi(credentials);
        CatalogApi catalogApi = this.catalogApi(credentials);
        managementApi.listCatalogs().stream().filter(c -> this.ownedName(c.getName())).forEach(c -> {
            catalogApi.purge(c.getName());
            managementApi.dropCatalog(c.getName());
        });
        managementApi.listPrincipalRoles().stream().filter(r -> this.ownedName(r.getName())).forEach(managementApi::deletePrincipalRole);
        managementApi.listPrincipals().stream().filter(p -> this.ownedName(p.getName())).forEach(p -> managementApi.deletePrincipal(p.getName()));
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

