/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.RestApi;
import org.apache.polaris.service.types.CreateGenericTableRequest;
import org.apache.polaris.service.types.GenericTable;
import org.apache.polaris.service.types.ListGenericTablesResponse;
import org.apache.polaris.service.types.LoadGenericTableResponse;
import org.assertj.core.api.Assertions;

public class GenericTableApi
extends RestApi {
    GenericTableApi(Client client, PolarisApiEndpoints endpoints, String authToken, URI uri) {
        super(client, endpoints, authToken, uri);
    }

    public void purge(String catalog, Namespace ns) {
        this.listGenericTables(catalog, ns).forEach(t -> this.dropGenericTable(catalog, (TableIdentifier)t));
    }

    public List<TableIdentifier> listGenericTables(String catalog, Namespace namespace) {
        String ns = RESTUtil.encodeNamespace((Namespace)namespace);
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/generic-tables", Map.of("cat", catalog, "ns", ns)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List<TableIdentifier> list = ((ListGenericTablesResponse)res.readEntity(ListGenericTablesResponse.class)).getIdentifiers().stream().toList();
            return list;
        }
    }

    public void dropGenericTable(String catalog, TableIdentifier id) {
        String ns = RESTUtil.encodeNamespace((Namespace)id.namespace());
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/generic-tables/{table}", Map.of("cat", catalog, "table", id.name(), "ns", ns)).delete();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public GenericTable getGenericTable(String catalog, TableIdentifier id) {
        String ns = RESTUtil.encodeNamespace((Namespace)id.namespace());
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/generic-tables/{table}", Map.of("cat", catalog, "table", id.name(), "ns", ns)).get();){
            GenericTable genericTable = ((LoadGenericTableResponse)res.readEntity(LoadGenericTableResponse.class)).getTable();
            return genericTable;
        }
    }

    public GenericTable createGenericTable(String catalog, TableIdentifier id, String format, Map<String, String> properties) {
        String ns = RESTUtil.encodeNamespace((Namespace)id.namespace());
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/generic-tables/", Map.of("cat", catalog, "ns", ns)).post(Entity.json((Object)CreateGenericTableRequest.builder().setName(id.name()).setFormat(format).setDoc("doc").setProperties(properties)));){
            GenericTable genericTable = ((LoadGenericTableResponse)res.readEntity(LoadGenericTableResponse.class)).getTable();
            return genericTable;
        }
    }
}

