/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import com.google.common.base.Joiner;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.rest.ErrorHandler;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.RestApi;
import org.assertj.core.api.Assertions;

public class CatalogApi
extends RestApi {
    public CatalogApi(Client client, PolarisApiEndpoints endpoints, String authToken, URI uri) {
        super(client, endpoints, authToken, uri);
    }

    public String obtainToken(ClientCredentials credentials) {
        try (Response response = this.request("v1/oauth/tokens").post(Entity.form((MultivaluedMap)new MultivaluedHashMap(Map.of("grant_type", "client_credentials", "scope", "PRINCIPAL_ROLE:ALL", "client_id", credentials.clientId(), "client_secret", credentials.clientSecret()))));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            String string = ((OAuthTokenResponse)response.readEntity(OAuthTokenResponse.class)).token();
            return string;
        }
    }

    public void createNamespace(String catalogName, String namespaceName) {
        try (Response response = this.request("v1/{cat}/namespaces", Map.of("cat", catalogName)).post(Entity.json((Object)CreateNamespaceRequest.builder().withNamespace(Namespace.of((String[])new String[]{namespaceName})).build()));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
        }
    }

    public List<Namespace> listNamespaces(String catalog, Namespace parent) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (!parent.isEmpty()) {
            queryParams.put("parent", Joiner.on((char)'\u001f').join((Object[])parent.levels()));
        }
        try (Response response = this.request("v1/{cat}/namespaces", Map.of("cat", catalog), queryParams).get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            ListNamespacesResponse res = (ListNamespacesResponse)response.readEntity(ListNamespacesResponse.class);
            List list = res.namespaces();
            return list;
        }
    }

    public List<Namespace> listAllNamespacesChildFirst(String catalog) {
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        for (int idx = -1; idx < result.size(); ++idx) {
            Namespace parent = Namespace.empty();
            if (idx >= 0) {
                parent = (Namespace)result.get(idx);
            }
            result.addAll(this.listNamespaces(catalog, parent));
        }
        return result.reversed();
    }

    public void deleteNamespace(String catalog, Namespace namespace) {
        String ns = RESTUtil.encodeNamespace((Namespace)namespace);
        try (Response response = this.request("v1/{cat}/namespaces/" + ns, Map.of("cat", catalog)).delete();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public void purge(String catalog) {
        this.listAllNamespacesChildFirst(catalog).forEach(ns -> this.purge(catalog, (Namespace)ns));
    }

    public void purge(String catalog, Namespace ns) {
        this.listTables(catalog, ns).forEach(t -> this.dropTable(catalog, (TableIdentifier)t));
        this.listViews(catalog, ns).forEach(t -> this.dropView(catalog, (TableIdentifier)t));
        this.deleteNamespace(catalog, ns);
    }

    public List<TableIdentifier> listTables(String catalog, Namespace namespace) {
        String ns = RESTUtil.encodeNamespace((Namespace)namespace);
        try (Response res = this.request("v1/{cat}/namespaces/" + ns + "/tables", Map.of("cat", catalog)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List list = ((ListTablesResponse)res.readEntity(ListTablesResponse.class)).identifiers();
            return list;
        }
    }

    public void dropTable(String catalog, TableIdentifier id) {
        String ns = RESTUtil.encodeNamespace((Namespace)id.namespace());
        try (Response res = this.request("v1/{cat}/namespaces/" + ns + "/tables/{table}", Map.of("cat", catalog, "table", id.name())).delete();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public LoadTableResponse loadTable(String catalog, TableIdentifier id, String snapshots) {
        return this.loadTable(catalog, id, snapshots, Map.of());
    }

    public LoadTableResponse loadTableWithAccessDelegation(String catalog, TableIdentifier id, String snapshots) {
        return this.loadTable(catalog, id, snapshots, Map.of("X-Iceberg-Access-Delegation", "vended-credentials"));
    }

    public LoadTableResponse loadTable(String catalog, TableIdentifier id, String snapshots, Map<String, String> headers) {
        HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders());
        allHeaders.putAll(headers);
        String ns = RESTUtil.encodeNamespace((Namespace)id.namespace());
        try (Response res = this.request("v1/{cat}/namespaces/" + ns + "/tables/{table}", Map.of("cat", catalog, "table", id.name()), snapshots == null ? Map.of() : Map.of("snapshots", snapshots), allHeaders).get();){
            if (res.getStatus() == Response.Status.OK.getStatusCode()) {
                LoadTableResponse loadTableResponse = (LoadTableResponse)res.readEntity(LoadTableResponse.class);
                return loadTableResponse;
            }
            throw new RESTException("Unhandled error: %s", new Object[]{((ErrorHandler)ErrorHandlers.defaultErrorHandler()).parseResponse(res.getStatus(), (String)res.readEntity(String.class))});
        }
    }

    public List<TableIdentifier> listViews(String catalog, Namespace namespace) {
        String ns = RESTUtil.encodeNamespace((Namespace)namespace);
        try (Response res = this.request("v1/{cat}/namespaces/" + ns + "/views", Map.of("cat", catalog)).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List list = ((ListTablesResponse)res.readEntity(ListTablesResponse.class)).identifiers();
            return list;
        }
    }

    public void dropView(String catalog, TableIdentifier id) {
        String ns = RESTUtil.encodeNamespace((Namespace)id.namespace());
        try (Response res = this.request("v1/{cat}/namespaces/" + ns + "/views/{view}", Map.of("cat", catalog, "view", id.name())).delete();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }
}

