/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context.catalog;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.SecurityContext;
import java.util.HashMap;
import org.apache.iceberg.catalog.Catalog;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.secrets.UserSecretsManagerFactory;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalog;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.config.RealmEntityManagerFactory;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.events.PolarisEventListener;
import org.apache.polaris.service.task.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PolarisCallContextCatalogFactory
implements CallContextCatalogFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCallContextCatalogFactory.class);
    private final RealmEntityManagerFactory entityManagerFactory;
    private final TaskExecutor taskExecutor;
    private final FileIOFactory fileIOFactory;
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final UserSecretsManagerFactory userSecretsManagerFactory;
    private final PolarisEventListener polarisEventListener;

    @Inject
    public PolarisCallContextCatalogFactory(RealmEntityManagerFactory entityManagerFactory, MetaStoreManagerFactory metaStoreManagerFactory, UserSecretsManagerFactory userSecretsManagerFactory, TaskExecutor taskExecutor, FileIOFactory fileIOFactory, PolarisEventListener polarisEventListener) {
        this.entityManagerFactory = entityManagerFactory;
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.userSecretsManagerFactory = userSecretsManagerFactory;
        this.taskExecutor = taskExecutor;
        this.fileIOFactory = fileIOFactory;
        this.polarisEventListener = polarisEventListener;
    }

    @Override
    public Catalog createCallContextCatalog(CallContext context, AuthenticatedPolarisPrincipal authenticatedPrincipal, SecurityContext securityContext, PolarisResolutionManifest resolvedManifest) {
        PolarisEntity baseCatalogEntity = resolvedManifest.getResolvedReferenceCatalogEntity().getRawLeafEntity();
        String catalogName = baseCatalogEntity.getName();
        String realm = context.getRealmContext().getRealmIdentifier();
        String catalogKey = realm + "/" + catalogName;
        LOGGER.debug("Initializing new BasePolarisCatalog for key: {}", (Object)catalogKey);
        PolarisEntityManager entityManager = this.entityManagerFactory.getOrCreateEntityManager(context.getRealmContext());
        IcebergCatalog catalogInstance = new IcebergCatalog(entityManager, this.metaStoreManagerFactory.getOrCreateMetaStoreManager(context.getRealmContext()), context, (PolarisResolutionManifestCatalogView)resolvedManifest, securityContext, this.taskExecutor, this.fileIOFactory, this.polarisEventListener);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)baseCatalogEntity);
        HashMap<String, String> catalogProperties = new HashMap<String, String>(catalog.getPropertiesAsMap());
        String defaultBaseLocation = catalog.getBaseLocation();
        LOGGER.debug("Looked up defaultBaseLocation {} for catalog {}", (Object)defaultBaseLocation, (Object)catalogKey);
        if (defaultBaseLocation == null) {
            throw new IllegalStateException(String.format("Catalog '%s' does not have a configured warehouse location. Please configure a default base location for this catalog.", catalogKey));
        }
        catalogProperties.put("warehouse", defaultBaseLocation);
        catalogInstance.initialize(catalogName, catalogProperties);
        return catalogInstance;
    }
}

