/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.MetadataUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReservedProperties {
    public static final Logger LOGGER = LoggerFactory.getLogger(ReservedProperties.class);
    public static final ReservedProperties NONE = new ReservedProperties(){

        @Override
        public List<String> prefixes() {
            return List.of();
        }

        @Override
        public Set<String> allowlist() {
            return Set.of();
        }
    };

    public List<String> prefixes();

    public Set<String> allowlist();

    default public boolean shouldThrow() {
        return true;
    }

    default public Map<String, String> removeReservedPropertiesFromUpdate(Map<String, String> existingProperties, Map<String, String> updateProperties) throws IllegalArgumentException {
        Map<String, String> updatePropertiesWithoutReservedProperties = this.removeReservedProperties(updateProperties);
        for (Map.Entry<String, String> entry : updateProperties.entrySet()) {
            if (updatePropertiesWithoutReservedProperties.containsKey(entry.getKey()) || !existingProperties.containsKey(entry.getKey())) continue;
            updatePropertiesWithoutReservedProperties.put(entry.getKey(), existingProperties.get(entry.getKey()));
        }
        return updatePropertiesWithoutReservedProperties;
    }

    default public Map<String, String> removeReservedProperties(Map<String, String> properties) throws IllegalArgumentException {
        HashMap<String, String> results = new HashMap<String, String>();
        List<String> prefixes = this.prefixes();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            boolean isReserved = false;
            if (!this.allowlist().contains(entry.getKey())) {
                for (String prefix : prefixes) {
                    if (!entry.getKey().startsWith(prefix)) continue;
                    isReserved = true;
                    String message = String.format("Property '%s' matches reserved prefix '%s'", entry.getKey(), prefix);
                    if (this.shouldThrow()) {
                        throw new IllegalArgumentException(message);
                    }
                    LOGGER.debug(message);
                }
            }
            if (isReserved) continue;
            results.put(entry.getKey(), entry.getValue());
        }
        return results;
    }

    default public List<String> removeReservedProperties(List<String> properties) throws IllegalArgumentException {
        Map<String, String> propertyMap = properties.stream().collect(Collectors.toMap(k -> k, k -> ""));
        Map<String, String> filteredMap = this.removeReservedProperties(propertyMap);
        return filteredMap.keySet().stream().toList();
    }

    default public MetadataUpdate removeReservedProperties(MetadataUpdate update) {
        MetadataUpdate metadataUpdate = update;
        Objects.requireNonNull(metadataUpdate);
        MetadataUpdate metadataUpdate2 = metadataUpdate;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetadataUpdate.SetProperties.class, MetadataUpdate.RemoveProperties.class}, (Object)metadataUpdate2, n)) {
            case 0 -> {
                MetadataUpdate.SetProperties p = (MetadataUpdate.SetProperties)metadataUpdate2;
                yield new MetadataUpdate.SetProperties(this.removeReservedProperties(p.updated()));
            }
            case 1 -> {
                MetadataUpdate.RemoveProperties p = (MetadataUpdate.RemoveProperties)metadataUpdate2;
                List<String> filteredProperties = this.removeReservedProperties(p.removed().stream().toList());
                yield new MetadataUpdate.RemoveProperties(new HashSet<String>(filteredProperties));
            }
            default -> update;
        };
    }
}

