/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.test.commons;

import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresRelationalJdbcLifeCycleManagement
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    public static final String INIT_SCRIPT = "init-script";
    private PostgreSQLContainer<?> postgres;
    private String initScript;
    private DevServicesContext context;

    public void init(Map<String, String> initArgs) {
        this.initScript = initArgs.get(INIT_SCRIPT);
    }

    public Map<String, String> start() {
        this.postgres = new PostgreSQLContainer(DockerImageName.parse((String)"postgres:17-alpine")).withDatabaseName("polaris_db").withUsername("polaris").withPassword("polaris");
        if (this.initScript != null) {
            this.postgres.withInitScript(this.initScript);
        }
        this.context.containerNetworkId().ifPresent(arg_0 -> this.postgres.withNetworkMode(arg_0));
        this.postgres.start();
        return Map.of("polaris.persistence.type", "relational-jdbc", "polaris.persistence.relational.jdbc.max-retries", "2", "quarkus.datasource.db-kind", "pgsql", "quarkus.datasource.jdbc.url", this.postgres.getJdbcUrl(), "quarkus.datasource.username", this.postgres.getUsername(), "quarkus.datasource.password", this.postgres.getPassword(), "quarkus.datasource.jdbc.initial-size", "10");
    }

    public void stop() {
        if (this.postgres != null) {
            try {
                this.postgres.stop();
            }
            finally {
                this.postgres = null;
            }
        }
    }

    public void setIntegrationTestContext(DevServicesContext context) {
        this.context = context;
    }
}

