/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.config;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfigSourceFactory
implements ConfigSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslConfigSourceFactory.class);
    private static final String KEYSTORE_PASSWORD = "ssl.server.keystore.password";
    private static final String SERVICE_PASSWORD = "quarkus.http.ssl.certificate.key-store-password";
    private static final String MANAGEMENT_PASSWORD = "quarkus.management.ssl.certificate.key-store-password";

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        return this.getConfigSource();
    }

    protected List<ConfigSource> getConfigSource() {
        ArrayList<ConfigSource> list = new ArrayList<ConfigSource>();
        String creds = System.getenv("POLARIS_SSL_CREDS_STORE");
        if (creds != null) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.credential.provider.path", creds);
            LOGGER.debug("Getting keystore password from Hadoop credentials provider");
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                char[] sslKeystorePass = conf.getPassword(KEYSTORE_PASSWORD);
                if (sslKeystorePass != null) {
                    map.put(SERVICE_PASSWORD, new String(sslKeystorePass));
                    map.put(MANAGEMENT_PASSWORD, new String(sslKeystorePass));
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("Cannot find {} option ", (Object)KEYSTORE_PASSWORD, (Object)ioe);
            }
            list.add((ConfigSource)new InMemoryConfigSource("ssl-keystore-config", map, 400));
        }
        return list;
    }

    private static final class InMemoryConfigSource
    extends MapBackedConfigSource {
        public InMemoryConfigSource(String name, Map<String, String> propertyMap, int defaultOrdinal) {
            super(name, propertyMap, defaultOrdinal);
        }
    }
}

