/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.quarkus.common.config;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsConfigSourceFactory
implements ConfigSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsConfigSourceFactory.class);
    private static final String JDBC_USERNAME = "quarkus.datasource.username";
    private static final String JDBC_PASSWORD = "quarkus.datasource.password";
    List<String> properties = List.of("quarkus.datasource.username", "quarkus.datasource.password", "polaris.storage.aws.access-key", "polaris.storage.aws.secret-key");

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        return this.getConfigSource();
    }

    protected List<ConfigSource> getConfigSource() {
        ArrayList<ConfigSource> list = new ArrayList<ConfigSource>();
        String creds = System.getenv("POLARIS_CREDS_STORE");
        if (creds != null) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.credential.provider.path", creds);
            LOGGER.debug("Getting username/password from Hadoop credentials provider");
            Map<String, String> map = this.properties.stream().map(item -> {
                try {
                    return new AbstractMap.SimpleEntry<String, char[]>((String)item, conf.getPassword(item));
                }
                catch (IOException ioe) {
                    LOGGER.warn("Cannot find {} option ", item, (Object)ioe);
                    return new AbstractMap.SimpleEntry<String, Object>((String)item, null);
                }
            }).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, value -> String.valueOf((char[])value.getValue())));
            list.add((ConfigSource)new InMemoryConfigSource("custom-jdbc-config", map, 400));
        }
        return list;
    }

    private static final class InMemoryConfigSource
    extends MapBackedConfigSource {
        public InMemoryConfigSource(String name, Map<String, String> propertyMap, int defaultOrdinal) {
            super(name, propertyMap, defaultOrdinal);
        }
    }
}

