/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import java.util.Locale;

public enum DatabaseType {
    POSTGRES("postgres"),
    H2("h2");

    private final String displayName;

    private DatabaseType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static DatabaseType fromDisplayName(String displayName) {
        return switch (displayName.toLowerCase(Locale.ROOT)) {
            case "h2" -> H2;
            case "postgresql" -> POSTGRES;
            default -> throw new IllegalStateException("Unsupported DatabaseType: '" + displayName + "'");
        };
    }

    public String getInitScriptResource() {
        return String.format("%s/schema-v2.sql", this.getDisplayName());
    }
}

