/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.test.minio;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.polaris.containerspec.ContainerSpecHelper;
import org.apache.polaris.test.minio.MinioAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.Base58;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public final class MinioContainer
extends GenericContainer<MinioContainer>
implements MinioAccess,
AutoCloseable {
    private static final Logger LOGGER;
    private static final int DEFAULT_PORT = 9000;
    private static final String MINIO_ACCESS_KEY = "MINIO_ROOT_USER";
    private static final String MINIO_SECRET_KEY = "MINIO_ROOT_PASSWORD";
    private static final String MINIO_DOMAIN = "MINIO_DOMAIN";
    private static final String DEFAULT_STORAGE_DIRECTORY = "/data";
    private static final String HEALTH_ENDPOINT = "/minio/health/ready";
    private static final String MINIO_DOMAIN_NAME;
    private static final String MINIO_DOMAIN_NIP = "s3.127-0-0-1.nip.io";
    private static final String FIXED_BUCKET_NAME;
    private final String accessKey;
    private final String secretKey;
    private final String bucket;
    private String hostPort;
    private String s3endpoint;
    private S3Client s3;
    private String region;

    static boolean canRunOnMacOs() {
        return MINIO_DOMAIN_NAME.equals(MINIO_DOMAIN_NIP);
    }

    private static String validateBucketHost(String bucketName) {
        if (FIXED_BUCKET_NAME != null) {
            String test = bucketName + ".localhost";
            try {
                InetAddress inetAddress = InetAddress.getByName(test);
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Could not resolve '{}',\n  Please add the line \n    '127.0.0.1   {}'\n  to your local '/etc/hosts' file.\n  Tests are expected to fail unless name resolution works.", (Object)test, (Object)test);
            }
        }
        return bucketName;
    }

    public MinioContainer() {
        this(null, null, null, null);
    }

    public MinioContainer(String image, String accessKey, String secretKey, String bucket) {
        super(ContainerSpecHelper.containerSpecHelper((String)"minio", MinioContainer.class).dockerImageName(image));
        this.withNetworkAliases(new String[]{MinioContainer.randomString("minio")});
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(MinioContainer.class)));
        this.addExposedPort(9000);
        this.accessKey = accessKey != null ? accessKey : MinioContainer.randomString("access");
        String string = this.secretKey = secretKey != null ? secretKey : MinioContainer.randomString("secret");
        this.bucket = bucket != null ? MinioContainer.validateBucketHost(bucket) : (FIXED_BUCKET_NAME != null ? FIXED_BUCKET_NAME : MinioContainer.randomString("bucket"));
        this.withEnv(MINIO_ACCESS_KEY, this.accessKey);
        this.withEnv(MINIO_SECRET_KEY, this.secretKey);
        this.withEnv(MINIO_DOMAIN, MINIO_DOMAIN_NAME);
        this.withCommand(new String[]{"server", DEFAULT_STORAGE_DIRECTORY});
        this.setWaitStrategy(new HttpWaitStrategy().forPort(9000).forPath(HEALTH_ENDPOINT).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    public MinioContainer withRegion(String region) {
        this.region = region;
        return this;
    }

    private static String randomString(String prefix) {
        return prefix + "-" + Base58.randomString((int)6).toLowerCase(Locale.ROOT);
    }

    @Override
    public String hostPort() {
        Preconditions.checkState((this.hostPort != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.hostPort;
    }

    @Override
    public String accessKey() {
        return this.accessKey;
    }

    @Override
    public String secretKey() {
        return this.secretKey;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public String s3endpoint() {
        Preconditions.checkState((this.s3endpoint != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.s3endpoint;
    }

    @Override
    public S3Client s3Client() {
        Preconditions.checkState((this.s3 != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.s3;
    }

    @Override
    public Map<String, String> icebergProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("s3.access-key-id", this.accessKey());
        props.put("s3.secret-access-key", this.secretKey());
        props.put("s3.endpoint", this.s3endpoint());
        props.put("http-client.type", "urlconnection");
        return props;
    }

    @Override
    public Map<String, String> hadoopConfig() {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("fs.s3.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        r.put("fs.s3a.access.key", this.accessKey());
        r.put("fs.s3a.secret.key", this.secretKey());
        r.put("fs.s3a.endpoint", this.s3endpoint());
        return r;
    }

    @Override
    public URI s3BucketUri(String path) {
        return this.s3BucketUri("s3", path);
    }

    public URI s3BucketUri(String scheme, String path) {
        Preconditions.checkState((this.bucket != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return URI.create(String.format("%s://%s/", scheme, this.bucket)).resolve(path);
    }

    public void start() {
        super.start();
        this.hostPort = MINIO_DOMAIN_NAME + ":" + this.getMappedPort(9000);
        this.s3endpoint = String.format("http://%s/", this.hostPort);
        this.s3 = this.createS3Client();
        this.s3.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucket()).build());
    }

    @Override
    public void close() {
        this.stop();
    }

    public void stop() {
        try {
            if (this.s3 != null) {
                this.s3.close();
            }
        }
        finally {
            this.s3 = null;
            super.stop();
        }
    }

    private S3Client createS3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).applyMutation(builder -> builder.endpointOverride(URI.create(this.s3endpoint())))).applyMutation(builder -> {
            if (this.region != null) {
                builder.region(Region.of((String)this.region));
            }
        })).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey(), (String)this.secretKey())))).build();
    }

    static {
        String name;
        LOGGER = LoggerFactory.getLogger(MinioContainer.class);
        String fixedBucketName = null;
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux")) {
            name = "localhost";
        } else {
            try {
                InetAddress ignored = InetAddress.getByName(MINIO_DOMAIN_NIP);
                name = MINIO_DOMAIN_NIP;
            }
            catch (UnknownHostException x) {
                LOGGER.warn("Could not resolve '{}', falling back to 'localhost'. This usually happens when your router or DNS provider is unable to resolve the nip.io addresses.", (Object)MINIO_DOMAIN_NIP);
                name = "localhost";
                fixedBucketName = "miniobucket";
                MinioContainer.validateBucketHost(fixedBucketName);
            }
        }
        MINIO_DOMAIN_NAME = name;
        FIXED_BUCKET_NAME = fixedBucketName;
    }
}

