/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import com.sun.source.doctree.DocCommentTree;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.AbstractElementVisitor8;
import jdk.javadoc.doclet.DocletEnvironment;
import org.apache.polaris.docs.generator.SmallRyeConfigPropertyInfo;

public final class SmallRyeConfigMappingInfo {
    private final String prefix;
    private final List<ConfigMappingInterface> configMappingInterfaces = new ArrayList<ConfigMappingInterface>();
    private final Map<String, List<ExecutableElement>> methodExecutables = new HashMap<String, List<ExecutableElement>>();
    private final Set<String> propertiesMethodNameOrder = new LinkedHashSet<String>();
    private final Map<String, ConfigMappingInterface.Property> methodNameToProperty = new LinkedHashMap<String, ConfigMappingInterface.Property>();
    private DocCommentTree typeComment;
    private TypeElement element;
    final ElementVisitor<Void, Void> executablesVisitor = new AbstractElementVisitor8<Void, Void>(){

        @Override
        public Void visitType(TypeElement e, Void unused) {
            for (Element element : e.getEnclosedElements()) {
                if (element.asType().getKind() != TypeKind.EXECUTABLE) continue;
                element.accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void unused) {
            if (e.getKind() == ElementKind.METHOD && (e.getModifiers().contains((Object)Modifier.ABSTRACT) || e.getModifiers().contains((Object)Modifier.DEFAULT)) && e.getParameters().isEmpty() && e.getReturnType().getKind() != TypeKind.VOID) {
                String methodName = e.getSimpleName().toString();
                SmallRyeConfigMappingInfo.this.propertiesMethodNameOrder.add(methodName);
                List<ExecutableElement> methodList = SmallRyeConfigMappingInfo.this.methodExecutables.get(methodName);
                if (methodList != null) {
                    methodList.add(e);
                }
            }
            return null;
        }

        @Override
        public Void visitPackage(PackageElement e, Void unused) {
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Void unused) {
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Void unused) {
            return null;
        }
    };

    SmallRyeConfigMappingInfo(String prefix) {
        this.prefix = prefix;
    }

    public Stream<SmallRyeConfigPropertyInfo> properties(DocletEnvironment env) {
        for (ConfigMappingInterface configMappingInterface : this.configMappingInterfaces) {
            for (ConfigMappingInterface.Property property : configMappingInterface.getProperties()) {
                String methodName = property.getMethod().getName();
                this.methodNameToProperty.putIfAbsent(methodName, property);
            }
        }
        return this.propertiesMethodNameOrder.stream().map(name -> this.buildPropertyInfo(env, (String)name)).filter(Objects::nonNull);
    }

    String prefix() {
        return this.prefix;
    }

    TypeElement element() {
        return this.element;
    }

    DocCommentTree typeComment() {
        return this.typeComment;
    }

    private SmallRyeConfigPropertyInfo buildPropertyInfo(DocletEnvironment env, String methodName) {
        ConfigMappingInterface.Property property = this.methodNameToProperty.get(methodName);
        if (property == null) {
            return null;
        }
        DocCommentTree doc = null;
        List<ExecutableElement> executables = this.methodExecutables.get(methodName);
        if (executables == null) {
            return null;
        }
        ExecutableElement docExec = null;
        for (ExecutableElement executable : executables) {
            if (doc != null || (doc = env.getDocTrees().getDocCommentTree(executable)) == null) continue;
            docExec = executable;
        }
        if (docExec == null) {
            docExec = executables.get(0);
        }
        ConfigMapping.NamingStrategy namingStrategy = this.configMappingInterfaces.isEmpty() ? ConfigMapping.NamingStrategy.KEBAB_CASE : this.configMappingInterfaces.get(0).getNamingStrategy();
        String propertyName = property.getPropertyName(namingStrategy);
        return new SmallRyeConfigPropertyInfo(docExec, property, propertyName, doc);
    }

    void processType(DocletEnvironment env, ConfigMappingInterface configMappingInterface, TypeElement typeElement) {
        this.configMappingInterfaces.add(configMappingInterface);
        for (ConfigMappingInterface.Property property : configMappingInterface.getProperties()) {
            Method method = property.getMethod();
            this.methodExecutables.putIfAbsent(method.getName(), new ArrayList());
        }
        typeElement.accept(this.executablesVisitor, null);
        if (this.typeComment == null) {
            this.typeComment = env.getDocTrees().getDocCommentTree(typeElement);
            if (this.typeComment != null) {
                this.element = typeElement;
            }
        }
    }
}

