package org.apache.polaris.service.admin.api;

import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalRoles;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.Principals;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

/**
 * The principals API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/management/v1/principals")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.836467545Z[UTC]", comments = "Generator version: 7.12.0")
public class PolarisPrincipalsApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(PolarisPrincipalsApi.class);

  private final PolarisPrincipalsApiService service;

  @Inject
  public PolarisPrincipalsApi(PolarisPrincipalsApiService service) {
    this.service = service;
  }

  /**
   * Add a role to the principal
   *
   * Response type: {@code Void}.
   * @param principalName Required - The name of the target principal
   * @param grantPrincipalRoleRequest Required - The principal role to assign
   *
   * @return 201 - Successful response
   * @return 403 - The caller does not have permission to add assign a role to the principal
   * @return 404 - The catalog, the principal, or the role does not exist
   */
  @PUT
  @Path("/{principalName}/principal-roles")
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.assignPrincipalRole")
  @Timeout
  public Response assignPrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName, @Nonnull @Valid GrantPrincipalRoleRequest grantPrincipalRoleRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "assignPrincipalRole")
      .addKeyValue("principalName", principalName)
      .addKeyValue("grantPrincipalRoleRequest", String.valueOf(grantPrincipalRoleRequest))
      .log();

    Response ret =
      service.assignPrincipalRole(principalName,grantPrincipalRoleRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of assignPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Create a principal
   *
   * Response type: {@code PrincipalWithCredentials}.
   * @param createPrincipalRequest Required - The principal to create
   *
   * @return 201 - Successful response
   * @return 403 - The caller does not have permission to add a principal
   */
  @POST
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.createPrincipal")
  @Timeout
  public Response createPrincipal( @Nonnull @Valid CreatePrincipalRequest createPrincipalRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "createPrincipal")
      .addKeyValue("createPrincipalRequest", String.valueOf(createPrincipalRequest))
      .log();

    Response ret =
      service.createPrincipal(createPrincipalRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createPrincipal API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a principal from polaris
   *
   * Response type: {@code Void}.
   * @param principalName Required - The principal name
   *
   * @return 204 - Success, no content
   * @return 403 - The caller does not have permission to delete a principal
   * @return 404 - The principal does not exist
   */
  @DELETE
  @Path("/{principalName}")
  @RolesAllowed("**")
  @Timed("polaris.principals.deletePrincipal")
  @Timeout
  public Response deletePrincipal( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "deletePrincipal")
      .addKeyValue("principalName", principalName)
      .log();

    Response ret =
      service.deletePrincipal(principalName,realmContext,securityContext);
    LOGGER.debug("Completed execution of deletePrincipal API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Get the principal details
   *
   * Response type: {@code Principal}.
   * @param principalName Required - The principal name
   *
   * @return 200 - The requested principal
   * @return 403 - The caller does not have permission to get principal details
   * @return 404 - The catalog or principal does not exist
   */
  @GET
  @Path("/{principalName}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.getPrincipal")
  @Timeout
  public Response getPrincipal( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "getPrincipal")
      .addKeyValue("principalName", principalName)
      .log();

    Response ret =
      service.getPrincipal(principalName,realmContext,securityContext);
    LOGGER.debug("Completed execution of getPrincipal API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List the roles assigned to the principal
   *
   * Response type: {@code PrincipalRoles}.
   * @param principalName Required - The name of the target principal
   *
   * @return 200 - List of roles assigned to this principal
   * @return 403 - The caller does not have permission to list roles
   * @return 404 - The principal or catalog does not exist
   */
  @GET
  @Path("/{principalName}/principal-roles")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.listPrincipalRolesAssigned")
  @Timeout
  public Response listPrincipalRolesAssigned( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "listPrincipalRolesAssigned")
      .addKeyValue("principalName", principalName)
      .log();

    Response ret =
      service.listPrincipalRolesAssigned(principalName,realmContext,securityContext);
    LOGGER.debug("Completed execution of listPrincipalRolesAssigned API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List the principals for the current catalog
   *
   * Response type: {@code Principals}.
   *
   * @return 200 - List of principals for this catalog
   * @return 403 - The caller does not have permission to list catalog admins
   * @return 404 - The catalog does not exist
   */
  @GET
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.listPrincipals")
  @Timeout
  public Response listPrincipals(@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "listPrincipals")
      .log();

    Response ret =
      service.listPrincipals(realmContext,securityContext);
    LOGGER.debug("Completed execution of listPrincipals API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a role from a catalog principal
   *
   * Response type: {@code Void}.
   * @param principalName Required - The name of the target principal
   * @param principalRoleName Required - The name of the role
   *
   * @return 204 - Success, no content
   * @return 403 - The caller does not have permission to remove a role from the principal
   * @return 404 - The catalog or principal does not exist
   */
  @DELETE
  @Path("/{principalName}/principal-roles/{principalRoleName}")
  @RolesAllowed("**")
  @Timed("polaris.principals.revokePrincipalRole")
  @Timeout
  public Response revokePrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "revokePrincipalRole")
      .addKeyValue("principalName", principalName)
      .addKeyValue("principalRoleName", principalRoleName)
      .log();

    Response ret =
      service.revokePrincipalRole(principalName,principalRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of revokePrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Rotate a principal&#39;s credentials. The new credentials will be returned in the response. This is the only API, aside from createPrincipal, that returns the user&#39;s credentials. This API is *not* idempotent.
   *
   * Response type: {@code PrincipalWithCredentials}.
   * @param principalName Required - The user name
   *
   * @return 200 - The principal details along with the newly rotated credentials
   * @return 403 - The caller does not have permission to rotate credentials
   * @return 404 - The principal does not exist
   */
  @POST
  @Path("/{principalName}/rotate")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.rotateCredentials")
  @Timeout
  public Response rotateCredentials( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "rotateCredentials")
      .addKeyValue("principalName", principalName)
      .log();

    Response ret =
      service.rotateCredentials(principalName,realmContext,securityContext);
    LOGGER.debug("Completed execution of rotateCredentials API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Update an existing principal
   *
   * Response type: {@code Principal}.
   * @param principalName Required - The principal name
   * @param updatePrincipalRequest Required - The principal details to use in the update
   *
   * @return 200 - The updated principal
   * @return 403 - The caller does not have permission to update principal details
   * @return 404 - The principal does not exist
   * @return 409 - The entity version doesn't match the currentEntityVersion; retry after fetching latest version
   */
  @PUT
  @Path("/{principalName}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principals.updatePrincipal")
  @Timeout
  public Response updatePrincipal( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalName") String principalName, @Nonnull @Valid UpdatePrincipalRequest updatePrincipalRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principals with params")
      .addKeyValue("operation", "updatePrincipal")
      .addKeyValue("principalName", principalName)
      .addKeyValue("updatePrincipalRequest", String.valueOf(updatePrincipalRequest))
      .log();

    Response ret =
      service.updatePrincipal(principalName,updatePrincipalRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updatePrincipal API with status code {}", ret.getStatus());
    return ret;
  }
}
