package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Identity metadata for the Polaris service used to access external resources.")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "identityType",
    visible = true
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AwsIamServiceIdentityInfo.class, name = "AWS_IAM")
})public class ServiceIdentityInfo   {

      /**
   * The type of identity used to access external resources
   */
  public enum IdentityTypeEnum {
    AWS_IAM("AWS_IAM");
    private String value;

    IdentityTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }

  @NotNull
  private final IdentityTypeEnum identityType;
    /**
     * The type of identity used to access external resources
     **/
    @ApiModelProperty(required = true, value = "The type of identity used to access external resources")
    @JsonProperty(value = "identityType", required = true)
    public IdentityTypeEnum getIdentityType() {
        return identityType;
    }
    
    @JsonCreator
    public ServiceIdentityInfo(@JsonProperty(value = "identityType", required = true) IdentityTypeEnum identityType) {
        this.identityType = identityType;
    }





    public static final class Builder {
      private IdentityTypeEnum identityType;
      private Builder() {
      }
      private Builder(IdentityTypeEnum identityType) {
        this.identityType = identityType;
      }

      public Builder setIdentityType(IdentityTypeEnum identityType) {
        this.identityType = identityType;
        return this;
      }


      public ServiceIdentityInfo build() {
        ServiceIdentityInfo inst = new ServiceIdentityInfo(identityType);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceIdentityInfo serviceIdentityInfo = (ServiceIdentityInfo) o;
    return Objects.equals(this.identityType, serviceIdentityInfo.identityType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identityType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceIdentityInfo {\n");
    
    sb.append("    identityType: ").append(toIndentedString(identityType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
