package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalWithCredentialsCredentials;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="A user with its client id and secret. This type is returned when a new principal is created or when its credentials are rotated")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class PrincipalWithCredentials   {

  @NotNull
  @Valid
  private final Principal principal;
  @NotNull
  @Valid
  private final PrincipalWithCredentialsCredentials credentials;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "principal", required = true)
    public Principal getPrincipal() {
        return principal;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "credentials", required = true)
    public PrincipalWithCredentialsCredentials getCredentials() {
        return credentials;
    }
    
    @JsonCreator
    public PrincipalWithCredentials(@JsonProperty(value = "principal", required = true) Principal principal, @JsonProperty(value = "credentials", required = true) PrincipalWithCredentialsCredentials credentials) {
        this.principal = principal;
        this.credentials = credentials;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(Principal principal, PrincipalWithCredentialsCredentials credentials) {
        return new Builder(principal, credentials);
    }


    public static final class Builder {
      private Principal principal;
      private PrincipalWithCredentialsCredentials credentials;
      private Builder() {
      }
      private Builder(Principal principal, PrincipalWithCredentialsCredentials credentials) {
        this.principal = principal;
        this.credentials = credentials;
      }

      public Builder setPrincipal(Principal principal) {
        this.principal = principal;
        return this;
      }
      public Builder setCredentials(PrincipalWithCredentialsCredentials credentials) {
        this.credentials = credentials;
        return this;
      }


      public PrincipalWithCredentials build() {
        PrincipalWithCredentials inst = new PrincipalWithCredentials(principal, credentials);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrincipalWithCredentials principalWithCredentials = (PrincipalWithCredentials) o;
    return Objects.equals(this.principal, principalWithCredentials.principal) &&
        Objects.equals(this.credentials, principalWithCredentials.credentials);
  }

  @Override
  public int hashCode() {
    return Objects.hash(principal, credentials);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrincipalWithCredentials {\n");
    
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
