package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="aws storage configuration info")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class AwsStorageConfigInfo extends StorageConfigInfo  {

  private final String roleArn;
  private final String externalId;
  private final String userArn;
  private final String region;
  private final String endpoint;
  private final String stsEndpoint;
  private final Boolean pathStyleAccess;
    /**
     * the aws role arn that grants privileges on the S3 buckets
     **/
    @ApiModelProperty(example = "arn:aws:iam::123456789001:principal/abc1-b-self1234", value = "the aws role arn that grants privileges on the S3 buckets")
    @JsonProperty(value = "roleArn")
    public String getRoleArn() {
        return roleArn;
    }
    
    /**
     * an optional external id used to establish a trust relationship with AWS in the trust policy
     **/
    @ApiModelProperty(value = "an optional external id used to establish a trust relationship with AWS in the trust policy")
    @JsonProperty(value = "externalId")
    public String getExternalId() {
        return externalId;
    }
    
    /**
     * the aws user arn used to assume the aws role
     **/
    @ApiModelProperty(example = "arn:aws:iam::123456789001:user/abc1-b-self1234", value = "the aws user arn used to assume the aws role")
    @JsonProperty(value = "userArn")
    public String getUserArn() {
        return userArn;
    }
    
    /**
     * the aws region where data is stored
     **/
    @ApiModelProperty(example = "us-east-2", value = "the aws region where data is stored")
    @JsonProperty(value = "region")
    public String getRegion() {
        return region;
    }
    
    /**
     * endpoint for S3 requests (optional)
     **/
    @ApiModelProperty(example = "https://s3.example.com:1234", value = "endpoint for S3 requests (optional)")
    @JsonProperty(value = "endpoint")
    public String getEndpoint() {
        return endpoint;
    }
    
    /**
     * endpoint for STS requests (optional). If not set, defaults to &#39;endpoint&#39;.
     **/
    @ApiModelProperty(example = "https://sts.example.com:1234", value = "endpoint for STS requests (optional). If not set, defaults to 'endpoint'.")
    @JsonProperty(value = "stsEndpoint")
    public String getStsEndpoint() {
        return stsEndpoint;
    }
    
    /**
     * Whether S3 requests to files in this catalog should use &#39;path-style addressing for buckets&#39;.
     **/
    @ApiModelProperty(example = "true", value = "Whether S3 requests to files in this catalog should use 'path-style addressing for buckets'.")
    @JsonProperty(value = "pathStyleAccess")
    public Boolean getPathStyleAccess() {
        return pathStyleAccess;
    }
    
    @JsonCreator
    public AwsStorageConfigInfo(@JsonProperty(value = "roleArn") String roleArn, @JsonProperty(value = "externalId") String externalId, @JsonProperty(value = "userArn") String userArn, @JsonProperty(value = "region") String region, @JsonProperty(value = "endpoint") String endpoint, @JsonProperty(value = "stsEndpoint") String stsEndpoint, @JsonProperty(value = "pathStyleAccess") Boolean pathStyleAccess, @JsonProperty(value = "storageType", required = true) StorageTypeEnum storageType, @JsonProperty(value = "allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.roleArn = roleArn;
        this.externalId = externalId;
        this.userArn = userArn;
        this.region = region;
        this.endpoint = endpoint;
        this.stsEndpoint = stsEndpoint;
        this.pathStyleAccess = Objects.requireNonNullElse(pathStyleAccess, false);
    }


    public AwsStorageConfigInfo(StorageTypeEnum storageType) {
        super(storageType);
        this.roleArn = null;
        this.externalId = null;
        this.userArn = null;
        this.region = null;
        this.endpoint = null;
        this.stsEndpoint = null;
        this.pathStyleAccess = false;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(StorageTypeEnum storageType) {
        return new Builder(storageType);
    }


    public static final class Builder {
      private String roleArn;
      private String externalId;
      private String userArn;
      private String region;
      private String endpoint;
      private String stsEndpoint;
      private Boolean pathStyleAccess;
      private StorageTypeEnum storageType;
      private List<String> allowedLocations;
      private Builder() {
      }
      private Builder(StorageTypeEnum storageType) {
        this.storageType = storageType;
      }

      public Builder setRoleArn(String roleArn) {
        this.roleArn = roleArn;
        return this;
      }
      public Builder setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
      }
      public Builder setUserArn(String userArn) {
        this.userArn = userArn;
        return this;
      }
      public Builder setRegion(String region) {
        this.region = region;
        return this;
      }
      public Builder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
      }
      public Builder setStsEndpoint(String stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
        return this;
      }
      public Builder setPathStyleAccess(Boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
        return this;
      }
      public Builder setStorageType(StorageTypeEnum storageType) {
        this.storageType = storageType;
        return this;
      }
      public Builder setAllowedLocations(List<String> allowedLocations) {
        this.allowedLocations = allowedLocations;
        return this;
      }


      public AwsStorageConfigInfo build() {
        AwsStorageConfigInfo inst = new AwsStorageConfigInfo(roleArn, externalId, userArn, region, endpoint, stsEndpoint, pathStyleAccess, storageType, allowedLocations);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AwsStorageConfigInfo awsStorageConfigInfo = (AwsStorageConfigInfo) o;
    return super.equals(o) && Objects.equals(this.roleArn, awsStorageConfigInfo.roleArn) &&
        Objects.equals(this.externalId, awsStorageConfigInfo.externalId) &&
        Objects.equals(this.userArn, awsStorageConfigInfo.userArn) &&
        Objects.equals(this.region, awsStorageConfigInfo.region) &&
        Objects.equals(this.endpoint, awsStorageConfigInfo.endpoint) &&
        Objects.equals(this.stsEndpoint, awsStorageConfigInfo.stsEndpoint) &&
        Objects.equals(this.pathStyleAccess, awsStorageConfigInfo.pathStyleAccess);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), roleArn, super.hashCode(), externalId, super.hashCode(), userArn, super.hashCode(), region, super.hashCode(), endpoint, super.hashCode(), stsEndpoint, super.hashCode(), pathStyleAccess);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AwsStorageConfigInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    roleArn: ").append(toIndentedString(roleArn)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    userArn: ").append(toIndentedString(userArn)).append("\n");
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("    endpoint: ").append(toIndentedString(endpoint)).append("\n");
    sb.append("    stsEndpoint: ").append(toIndentedString(stsEndpoint)).append("\n");
    sb.append("    pathStyleAccess: ").append(toIndentedString(pathStyleAccess)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
