package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="The base catalog type - this contains all the fields necessary to construct an INTERNAL catalog")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class PolarisCatalog extends Catalog  {

    @JsonCreator
    public PolarisCatalog(@JsonProperty("type") TypeEnum type, @JsonProperty("name") String name, @JsonProperty("properties") CatalogProperties properties, @JsonProperty("createTimestamp") Long createTimestamp, @JsonProperty("lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty("entityVersion") Integer entityVersion, @JsonProperty("storageConfigInfo") StorageConfigInfo storageConfigInfo) {
        super(type, name, properties, createTimestamp, lastUpdateTimestamp, entityVersion, storageConfigInfo);
    }


    public PolarisCatalog(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        super(type, name, properties, storageConfigInfo);
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        return new Builder(type, name, properties, storageConfigInfo);
    }


    public static final class Builder {
      private TypeEnum type;
      private String name;
      private CatalogProperties properties;
      private Long createTimestamp;
      private Long lastUpdateTimestamp;
      private Integer entityVersion;
      private StorageConfigInfo storageConfigInfo;
      private Builder() {
      }
      private Builder(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
        this.name = name;
        this.properties = properties;
        this.storageConfigInfo = storageConfigInfo;
      }

      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }
      public Builder setName(String name) {
        this.name = name;
        return this;
      }
      public Builder setProperties(CatalogProperties properties) {
        this.properties = properties;
        return this;
      }
      public Builder setCreateTimestamp(Long createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
      }
      public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        return this;
      }
      public Builder setEntityVersion(Integer entityVersion) {
        this.entityVersion = entityVersion;
        return this;
      }
      public Builder setStorageConfigInfo(StorageConfigInfo storageConfigInfo) {
        this.storageConfigInfo = storageConfigInfo;
        return this;
      }


      public PolarisCatalog build() {
        PolarisCatalog inst = new PolarisCatalog(type, name, properties, createTimestamp, lastUpdateTimestamp, entityVersion, storageConfigInfo);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PolarisCatalog polarisCatalog = (PolarisCatalog) o;return super.equals(o);
  }

  @Override
  public int hashCode() {
    return super.hashCode();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PolarisCatalog {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
