package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Configuration necessary for connecting to an Iceberg REST Catalog")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class IcebergRestConnectionConfigInfo extends ConnectionConfigInfo  {

  private final String remoteCatalogName;
    /**
     * The name of a remote catalog instance within the remote catalog service; in some older systems this is specified as the &#39;warehouse&#39; when multiple logical catalogs are served under the same base uri, and often translates into a &#39;prefix&#39; added to all REST resource paths
     **/
    @ApiModelProperty(value = "The name of a remote catalog instance within the remote catalog service; in some older systems this is specified as the 'warehouse' when multiple logical catalogs are served under the same base uri, and often translates into a 'prefix' added to all REST resource paths")
    @JsonProperty(value = "remoteCatalogName")
    public String getRemoteCatalogName() {
        return remoteCatalogName;
    }
    
    @JsonCreator
    public IcebergRestConnectionConfigInfo(@JsonProperty(value = "remoteCatalogName") String remoteCatalogName, @JsonProperty(value = "connectionType", required = true) ConnectionTypeEnum connectionType, @JsonProperty(value = "uri") String uri, @JsonProperty(value = "authenticationParameters") AuthenticationParameters authenticationParameters, @JsonProperty(value = "serviceIdentity") ServiceIdentityInfo serviceIdentity) {
        super(connectionType, uri, authenticationParameters, serviceIdentity);
        this.remoteCatalogName = remoteCatalogName;
    }


    public IcebergRestConnectionConfigInfo(ConnectionTypeEnum connectionType) {
        super(connectionType);
        this.remoteCatalogName = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ConnectionTypeEnum connectionType) {
        return new Builder(connectionType);
    }


    public static final class Builder {
      private String remoteCatalogName;
      private ConnectionTypeEnum connectionType;
      private String uri;
      private AuthenticationParameters authenticationParameters;
      private ServiceIdentityInfo serviceIdentity;
      private Builder() {
      }
      private Builder(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
      }

      public Builder setRemoteCatalogName(String remoteCatalogName) {
        this.remoteCatalogName = remoteCatalogName;
        return this;
      }
      public Builder setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
      }
      public Builder setUri(String uri) {
        this.uri = uri;
        return this;
      }
      public Builder setAuthenticationParameters(AuthenticationParameters authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
        return this;
      }
      public Builder setServiceIdentity(ServiceIdentityInfo serviceIdentity) {
        this.serviceIdentity = serviceIdentity;
        return this;
      }


      public IcebergRestConnectionConfigInfo build() {
        IcebergRestConnectionConfigInfo inst = new IcebergRestConnectionConfigInfo(remoteCatalogName, connectionType, uri, authenticationParameters, serviceIdentity);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IcebergRestConnectionConfigInfo icebergRestConnectionConfigInfo = (IcebergRestConnectionConfigInfo) o;
    return super.equals(o) && Objects.equals(this.remoteCatalogName, icebergRestConnectionConfigInfo.remoteCatalogName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), remoteCatalogName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IcebergRestConnectionConfigInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    remoteCatalogName: ").append(toIndentedString(remoteCatalogName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
