package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.Catalog;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Request to create a new catalog")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class CreateCatalogRequest   {

  @NotNull
  @Valid
  private final Catalog catalog;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "catalog", required = true)
    public Catalog getCatalog() {
        return catalog;
    }
    
    @JsonCreator
    public CreateCatalogRequest(@JsonProperty(value = "catalog", required = true) Catalog catalog) {
        this.catalog = catalog;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(Catalog catalog) {
        return new Builder(catalog);
    }


    public static final class Builder {
      private Catalog catalog;
      private Builder() {
      }
      private Builder(Catalog catalog) {
        this.catalog = catalog;
      }

      public Builder setCatalog(Catalog catalog) {
        this.catalog = catalog;
        return this;
      }


      public CreateCatalogRequest build() {
        CreateCatalogRequest inst = new CreateCatalogRequest(catalog);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCatalogRequest createCatalogRequest = (CreateCatalogRequest) o;
    return Objects.equals(this.catalog, createCatalogRequest.catalog);
  }

  @Override
  public int hashCode() {
    return Objects.hash(catalog);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCatalogRequest {\n");
    
    sb.append("    catalog: ").append(toIndentedString(catalog)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
