package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.GrantResource;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class CatalogGrant extends GrantResource  {

  @NotNull
  @Valid
  private final CatalogPrivilege privilege;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "privilege", required = true)
    public CatalogPrivilege getPrivilege() {
        return privilege;
    }
    
    @JsonCreator
    public CatalogGrant(@JsonProperty(value = "privilege", required = true) CatalogPrivilege privilege, @JsonProperty(value = "type", required = true) TypeEnum type) {
        super(type);
        this.privilege = privilege;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CatalogPrivilege privilege, TypeEnum type) {
        return new Builder(privilege, type);
    }


    public static final class Builder {
      private CatalogPrivilege privilege;
      private TypeEnum type;
      private Builder() {
      }
      private Builder(CatalogPrivilege privilege, TypeEnum type) {
        this.privilege = privilege;
        this.type = type;
      }

      public Builder setPrivilege(CatalogPrivilege privilege) {
        this.privilege = privilege;
        return this;
      }
      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }


      public CatalogGrant build() {
        CatalogGrant inst = new CatalogGrant(privilege, type);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CatalogGrant catalogGrant = (CatalogGrant) o;
    return super.equals(o) && Objects.equals(this.privilege, catalogGrant.privilege);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), privilege);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CatalogGrant {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    privilege: ").append(toIndentedString(privilege)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
