package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Bearer authentication directly embedded in request auth headers")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class BearerAuthenticationParameters extends AuthenticationParameters  {

  private final String bearerToken;
    /**
     * Bearer token (input-only)
     **/
    @ApiModelProperty(value = "Bearer token (input-only)")
    @JsonProperty(value = "bearerToken")
    public String getBearerToken() {
        return bearerToken;
    }
    
    @JsonCreator
    public BearerAuthenticationParameters(@JsonProperty(value = "bearerToken") String bearerToken, @JsonProperty(value = "authenticationType", required = true) AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.bearerToken = bearerToken;
    }


    public BearerAuthenticationParameters(AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.bearerToken = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AuthenticationTypeEnum authenticationType) {
        return new Builder(authenticationType);
    }


    public static final class Builder {
      private String bearerToken;
      private AuthenticationTypeEnum authenticationType;
      private Builder() {
      }
      private Builder(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
      }

      public Builder setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return this;
      }
      public Builder setAuthenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
        return this;
      }


      public BearerAuthenticationParameters build() {
        BearerAuthenticationParameters inst = new BearerAuthenticationParameters(bearerToken, authenticationType);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BearerAuthenticationParameters bearerAuthenticationParameters = (BearerAuthenticationParameters) o;
    return super.equals(o) && Objects.equals(this.bearerToken, bearerAuthenticationParameters.bearerToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), bearerToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BearerAuthenticationParameters {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    bearerToken: ").append("*").append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
