package org.apache.polaris.service.catalog.api;

import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.polaris.service.types.NotificationRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * The CatalogApi API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/catalog/v1/{prefix}")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.406523497Z[UTC]", comments = "Generator version: 7.12.0")
public class IcebergRestCatalogApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(IcebergRestCatalogApi.class);

  private final IcebergRestCatalogApiService service;

  @Inject
  public IcebergRestCatalogApi(IcebergRestCatalogApiService service) {
    this.service = service;
  }

  /**
   * Commit updates to multiple tables in an atomic operation
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param commitTransactionRequest Required - Commit updates to multiple tables in an atomic operation  A commit for a single table consists of a table identifier with requirements and updates. Requirements are assertions that will be validated before attempting to make and commit changes. For example, &#x60;assert-ref-snapshot-id&#x60; will check that a named ref&#39;s snapshot ID has a certain value. Server implementations are required to fail with a 400 status code if any unknown updates or requirements are received. Updates are changes to make to table metadata. For example, after asserting that the current main ref is at the expected snapshot, a commit may add a new child snapshot and set the ref to the new snapshot id.
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, table to load does not exist
   * @return 409 - Conflict - CommitFailedException, one or more requirements failed. The client may retry.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 500 - An unknown server-side problem occurred; the commit state is unknown.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 502 - A gateway or proxy received an invalid response from the upstream server; the commit state is unknown.
   * @return 504 - A server-side gateway timeout occurred; the commit state is unknown.
   * @return 5XX - A server-side problem that might not be addressable on the client.
   */
  @POST
  @Path("/transactions/commit")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.commitTransaction")
  @Timeout
  public Response commitTransaction( @PathParam("prefix") String prefix, CommitTransactionRequest commitTransactionRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "commitTransaction")
      .addKeyValue("prefix", prefix)
      .addKeyValue("commitTransactionRequest", String.valueOf(commitTransactionRequest))
      .log();

    Response ret =
      service.commitTransaction(prefix,commitTransactionRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of commitTransaction API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Create a namespace, with an optional set of properties. The server might also add properties, such as &#x60;last_modified_time&#x60; etc.
   *
   * Response type: {@code CreateNamespaceResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param createNamespaceRequest Required - 
   *
   * @return 200 - Represents a successful call to create a namespace. Returns the namespace created, as well as any properties that were stored for the namespace, including those the server might have added. Implementations are not required to support namespace properties.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 406 - Not Acceptable / Unsupported Operation. The server does not support this operation.
   * @return 409 - Conflict - The namespace already exists
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.createNamespace")
  @Timeout
  public Response createNamespace( @PathParam("prefix") String prefix, CreateNamespaceRequest createNamespaceRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "createNamespace")
      .addKeyValue("prefix", prefix)
      .addKeyValue("createNamespaceRequest", String.valueOf(createNamespaceRequest))
      .log();

    Response ret =
      service.createNamespace(prefix,createNamespaceRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createNamespace API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Create a table or start a create transaction, like atomic CTAS.  If &#x60;stage-create&#x60; is false, the table is created immediately.  If &#x60;stage-create&#x60; is true, the table is not created, but table metadata is initialized and returned. The service should prepare as needed for a commit to the table commit endpoint to complete the create transaction. The client uses the returned metadata to begin a transaction. To commit the transaction, the client sends all create and subsequent changes to the table commit route. Changes from the table create operation include changes like AddSchemaUpdate and SetCurrentSchemaUpdate that set the initial table state.
   *
   * Response type: {@code LoadTableResult}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param createTableRequest Required - 
   * @param xIcebergAccessDelegation  Optional signal to the server that the client supports delegated access via a comma-separated list of access mechanisms.  The server may choose to supply access via any or none of the requested mechanisms.  Specific properties and handling for &#x60;vended-credentials&#x60; is documented in the &#x60;LoadTableResult&#x60; schema section of this spec document.  The protocol and specification for &#x60;remote-signing&#x60; is documented in  the &#x60;s3-signer-open-api.yaml&#x60; OpenApi spec in the &#x60;aws&#x60; module. 
   *
   * @return 200 - Table metadata result after creating a table
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 409 - Conflict - The table already exists
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/tables")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.createTable")
  @Timeout
  public Response createTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, CreateTableRequest createTableRequest,@HeaderParam("X-Iceberg-Access-Delegation") String xIcebergAccessDelegation,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "createTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("createTableRequest", String.valueOf(createTableRequest))
      .log();

    Response ret =
      service.createTable(prefix,namespace,createTableRequest,xIcebergAccessDelegation,realmContext,securityContext);
    LOGGER.debug("Completed execution of createTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Create a view in the given namespace.
   *
   * Response type: {@code LoadViewResult}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param createViewRequest Required - 
   *
   * @return 200 - View metadata result when loading a view
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 409 - Conflict - The view already exists
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/views")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.createView")
  @Timeout
  public Response createView( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, CreateViewRequest createViewRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "createView")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("createViewRequest", String.valueOf(createViewRequest))
      .log();

    Response ret =
      service.createView(prefix,namespace,createViewRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createView API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Drop a namespace from the catalog. Namespace must be empty.
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - Namespace to delete does not exist.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @DELETE
  @Path("/namespaces/{namespace}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.dropNamespace")
  @Timeout
  public Response dropNamespace( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "dropNamespace")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .log();

    Response ret =
      service.dropNamespace(prefix,namespace,realmContext,securityContext);
    LOGGER.debug("Completed execution of dropNamespace API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a table from the catalog
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   * @param purgeRequested  Whether the user requested to purge the underlying table&#39;s data and metadata
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, Table to drop does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @DELETE
  @Path("/namespaces/{namespace}/tables/{table}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.dropTable")
  @Timeout
  public Response dropTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table, @DefaultValue("false") @QueryParam("purgeRequested") Boolean purgeRequested,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "dropTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .addKeyValue("purgeRequested", purgeRequested)
      .log();

    Response ret =
      service.dropTable(prefix,namespace,table,purgeRequested,realmContext,securityContext);
    LOGGER.debug("Completed execution of dropTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a view from the catalog
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param view Required - A view name
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchViewException, view to drop does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @DELETE
  @Path("/namespaces/{namespace}/views/{view}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.dropView")
  @Timeout
  public Response dropView( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("view") String view,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "dropView")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("view", view)
      .log();

    Response ret =
      service.dropView(prefix,namespace,view,realmContext,securityContext);
    LOGGER.debug("Completed execution of dropView API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List all namespaces at a certain level, optionally starting from a given parent namespace. If table accounting.tax.paid.info exists, using &#39;SELECT NAMESPACE IN accounting&#39; would translate into &#x60;GET /namespaces?parent&#x3D;accounting&#x60; and must return a namespace, [\&quot;accounting\&quot;, \&quot;tax\&quot;] only. Using &#39;SELECT NAMESPACE IN accounting.tax&#39; would translate into &#x60;GET /namespaces?parent&#x3D;accounting%1Ftax&#x60; and must return a namespace, [\&quot;accounting\&quot;, \&quot;tax\&quot;, \&quot;paid\&quot;]. If &#x60;parent&#x60; is not provided, all top-level namespaces should be listed.
   *
   * Response type: {@code ListNamespacesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param pageToken  
   * @param pageSize  For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated &#x60;pageSize&#x60;.
   * @param parent  An optional namespace, underneath which to list namespaces. If not provided or empty, all top-level namespaces should be listed. If parent is a multipart namespace, the parts must be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   *
   * @return 200 - A list of namespaces
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - Namespace provided in the `parent` query parameter is not found.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.listNamespaces")
  @Timeout
  public Response listNamespaces( @PathParam("prefix") String prefix, @QueryParam("pageToken") String pageToken, @QueryParam("pageSize") Integer pageSize, @QueryParam("parent") String parent,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "listNamespaces")
      .addKeyValue("prefix", prefix)
      .addKeyValue("pageToken", pageToken)
      .addKeyValue("pageSize", pageSize)
      .addKeyValue("parent", parent)
      .log();

    Response ret =
      service.listNamespaces(prefix,pageToken,pageSize,parent,realmContext,securityContext);
    LOGGER.debug("Completed execution of listNamespaces API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Return all table identifiers under this namespace
   *
   * Response type: {@code ListTablesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param pageToken  
   * @param pageSize  For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated &#x60;pageSize&#x60;.
   *
   * @return 200 - A list of table identifiers
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/tables")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.listTables")
  @Timeout
  public Response listTables( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @QueryParam("pageToken") String pageToken, @QueryParam("pageSize") Integer pageSize,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "listTables")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("pageToken", pageToken)
      .addKeyValue("pageSize", pageSize)
      .log();

    Response ret =
      service.listTables(prefix,namespace,pageToken,pageSize,realmContext,securityContext);
    LOGGER.debug("Completed execution of listTables API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Return all view identifiers under this namespace
   *
   * Response type: {@code ListTablesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param pageToken  
   * @param pageSize  For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated &#x60;pageSize&#x60;.
   *
   * @return 200 - A list of table identifiers
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/views")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.listViews")
  @Timeout
  public Response listViews( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @QueryParam("pageToken") String pageToken, @QueryParam("pageSize") Integer pageSize,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "listViews")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("pageToken", pageToken)
      .addKeyValue("pageSize", pageSize)
      .log();

    Response ret =
      service.listViews(prefix,namespace,pageToken,pageSize,realmContext,securityContext);
    LOGGER.debug("Completed execution of listViews API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Load vended credentials for a table from the catalog.
   *
   * Response type: {@code LoadCredentialsResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   *
   * @return 200 - Table credentials result when loading credentials for a table
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, table to load credentials for does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/tables/{table}/credentials")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.loadCredentials")
  @Timeout
  public Response loadCredentials( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "loadCredentials")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .log();

    Response ret =
      service.loadCredentials(prefix,namespace,table,realmContext,securityContext);
    LOGGER.debug("Completed execution of loadCredentials API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Return all stored metadata properties for a given namespace
   *
   * Response type: {@code GetNamespaceResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   *
   * @return 200 - Returns a namespace, as well as any properties stored on the namespace if namespace properties are supported by the server.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - Namespace not found
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.loadNamespaceMetadata")
  @Timeout
  public Response loadNamespaceMetadata( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "loadNamespaceMetadata")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .log();

    Response ret =
      service.loadNamespaceMetadata(prefix,namespace,realmContext,securityContext);
    LOGGER.debug("Completed execution of loadNamespaceMetadata API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Load a table from the catalog.  The response contains both configuration and table metadata. The configuration, if non-empty is used as additional configuration for the table that overrides catalog configuration. For example, this configuration may change the FileIO implementation to be used for the table.  The response also contains the table&#39;s full metadata, matching the table metadata JSON file.  The catalog configuration may contain credentials that should be used for subsequent requests for the table. The configuration key \&quot;token\&quot; is used to pass an access token to be used as a bearer token for table requests. Otherwise, a token may be passed using a RFC 8693 token type as a configuration key. For example, \&quot;urn:ietf:params:oauth:token-type:jwt&#x3D;&lt;JWT-token&gt;\&quot;.
   *
   * Response type: {@code LoadTableResult}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   * @param xIcebergAccessDelegation  Optional signal to the server that the client supports delegated access via a comma-separated list of access mechanisms.  The server may choose to supply access via any or none of the requested mechanisms.  Specific properties and handling for &#x60;vended-credentials&#x60; is documented in the &#x60;LoadTableResult&#x60; schema section of this spec document.  The protocol and specification for &#x60;remote-signing&#x60; is documented in  the &#x60;s3-signer-open-api.yaml&#x60; OpenApi spec in the &#x60;aws&#x60; module. 
   * @param ifNoneMatch  An optional header that allows the server to return 304 (Not Modified) if the metadata is current. The content is the value of the ETag received in a CreateTableResponse or LoadTableResponse.
   * @param snapshots  The snapshots to return in the body of the metadata. Setting the value to &#x60;all&#x60; would return the full set of snapshots currently valid for the table. Setting the value to &#x60;refs&#x60; would load all snapshots referenced by branches or tags. Default if no param is provided is &#x60;all&#x60;.
   *
   * @return 200 - Table metadata result when loading a table
   * @return 304 - Not Modified - Based on the content of the 'If-None-Match' header the table metadata has not changed since.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, table to load does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/tables/{table}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.loadTable")
  @Timeout
  public Response loadTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table,@HeaderParam("X-Iceberg-Access-Delegation") String xIcebergAccessDelegation,@HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("snapshots") String snapshots,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "loadTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .addKeyValue("snapshots", snapshots)
      .log();

    Response ret =
      service.loadTable(prefix,namespace,table,xIcebergAccessDelegation,ifNoneMatch,snapshots,realmContext,securityContext);
    LOGGER.debug("Completed execution of loadTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Load a view from the catalog.  The response contains both configuration and view metadata. The configuration, if non-empty is used as additional configuration for the view that overrides catalog configuration.  The response also contains the view&#39;s full metadata, matching the view metadata JSON file.  The catalog configuration may contain credentials that should be used for subsequent requests for the view. The configuration key \&quot;token\&quot; is used to pass an access token to be used as a bearer token for view requests. Otherwise, a token may be passed using a RFC 8693 token type as a configuration key. For example, \&quot;urn:ietf:params:oauth:token-type:jwt&#x3D;&lt;JWT-token&gt;\&quot;.
   *
   * Response type: {@code LoadViewResult}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param view Required - A view name
   *
   * @return 200 - View metadata result when loading a view
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchViewException, view to load does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/views/{view}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.loadView")
  @Timeout
  public Response loadView( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("view") String view,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "loadView")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("view", view)
      .log();

    Response ret =
      service.loadView(prefix,namespace,view,realmContext,securityContext);
    LOGGER.debug("Completed execution of loadView API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Check if a namespace exists. The response does not contain a body.
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - Namespace not found
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @HEAD
  @Path("/namespaces/{namespace}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.namespaceExists")
  @Timeout
  public Response namespaceExists( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "namespaceExists")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .log();

    Response ret =
      service.namespaceExists(prefix,namespace,realmContext,securityContext);
    LOGGER.debug("Completed execution of namespaceExists API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Register a table using given metadata file location.
   *
   * Response type: {@code LoadTableResult}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param registerTableRequest Required - 
   *
   * @return 200 - Table metadata result when loading a table
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 409 - Conflict - The table already exists
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/register")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.registerTable")
  @Timeout
  public Response registerTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, RegisterTableRequest registerTableRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "registerTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("registerTableRequest", String.valueOf(registerTableRequest))
      .log();

    Response ret =
      service.registerTable(prefix,namespace,registerTableRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of registerTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Rename a table from one identifier to another. It&#39;s valid to move a table across namespaces, but the server implementation is not required to support it.
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param renameTableRequest Required - Current table identifier to rename and new table identifier to rename to
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, Table to rename does not exist - NoSuchNamespaceException, The target namespace of the new table identifier does not exist
   * @return 406 - Not Acceptable / Unsupported Operation. The server does not support this operation.
   * @return 409 - Conflict - The target identifier to rename to already exists as a table or view
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/tables/rename")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.renameTable")
  @Timeout
  public Response renameTable( @PathParam("prefix") String prefix, RenameTableRequest renameTableRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "renameTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("renameTableRequest", String.valueOf(renameTableRequest))
      .log();

    Response ret =
      service.renameTable(prefix,renameTableRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of renameTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Rename a view from one identifier to another. It&#39;s valid to move a view across namespaces, but the server implementation is not required to support it.
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param renameTableRequest Required - Current view identifier to rename and new view identifier to rename to
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchViewException, view to rename does not exist - NoSuchNamespaceException, The target namespace of the new identifier does not exist
   * @return 406 - Not Acceptable / Unsupported Operation. The server does not support this operation.
   * @return 409 - Conflict - The target identifier to rename to already exists as a table or view
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/views/rename")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.renameView")
  @Timeout
  public Response renameView( @PathParam("prefix") String prefix, RenameTableRequest renameTableRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "renameView")
      .addKeyValue("prefix", prefix)
      .addKeyValue("renameTableRequest", String.valueOf(renameTableRequest))
      .log();

    Response ret =
      service.renameView(prefix,renameTableRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of renameView API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Commit updates to a view.
   *
   * Response type: {@code LoadViewResult}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param view Required - A view name
   * @param commitViewRequest Required - 
   *
   * @return 200 - View metadata result when loading a view
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchViewException, view to load does not exist
   * @return 409 - Conflict - CommitFailedException. The client may retry.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 500 - An unknown server-side problem occurred; the commit state is unknown.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 502 - A gateway or proxy received an invalid response from the upstream server; the commit state is unknown.
   * @return 504 - A server-side gateway timeout occurred; the commit state is unknown.
   * @return 5XX - A server-side problem that might not be addressable on the client.
   */
  @POST
  @Path("/namespaces/{namespace}/views/{view}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.replaceView")
  @Timeout
  public Response replaceView( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("view") String view, CommitViewRequest commitViewRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "replaceView")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("view", view)
      .addKeyValue("commitViewRequest", String.valueOf(commitViewRequest))
      .log();

    Response ret =
      service.replaceView(prefix,namespace,view,commitViewRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of replaceView API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Send a metrics report to this endpoint to be processed by the backend
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   * @param reportMetricsRequest Required - The request containing the metrics report to be sent
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, table to load does not exist
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/tables/{table}/metrics")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.reportMetrics")
  @Timeout
  public Response reportMetrics( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table, ReportMetricsRequest reportMetricsRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "reportMetrics")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .addKeyValue("reportMetricsRequest", String.valueOf(reportMetricsRequest))
      .log();

    Response ret =
      service.reportMetrics(prefix,namespace,table,reportMetricsRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of reportMetrics API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Sends a notification to the table
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   * @param notificationRequest Required - The request containing the notification to be sent. For each table, Polaris will reject any notification where the timestamp in the request body is older than or equal to the most recent time Polaris has already processed for the table. The responsibility of ensuring the correct order of timestamps for a sequence of notifications lies with the caller of the API. This includes managing potential clock skew or inconsistencies when notifications are sent from multiple sources. A VALIDATE request behaves like a dry-run of a CREATE or UPDATE request up to but not including loading the contents of a metadata file; this includes validations of permissions, the specified metadata path being within ALLOWED_LOCATIONS, having an EXTERNAL catalog, etc. The intended use case for a VALIDATE notification is to allow a remote catalog to pre-validate the general settings of a receiving catalog against an intended new table location before possibly creating a table intended for sending notifications in the remote catalog at all. For a VALIDATE request, the specified metadata-location can either be a prospective full metadata file path, or a relevant parent directory of the intended table to validate against ALLOWED_LOCATIONS.
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, table to load does not exist
   * @return 409 - Conflict - The timestamp of the received notification is older than or equal to the most recent timestamp Polaris has already processed for the specified table.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/tables/{table}/notifications")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.sendNotification")
  @Timeout
  public Response sendNotification( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table, NotificationRequest notificationRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "sendNotification")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .addKeyValue("notificationRequest", String.valueOf(notificationRequest))
      .log();

    Response ret =
      service.sendNotification(prefix,namespace,table,notificationRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of sendNotification API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Check if a table exists within a given namespace. The response does not contain a body.
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, Table not found
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @HEAD
  @Path("/namespaces/{namespace}/tables/{table}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.tableExists")
  @Timeout
  public Response tableExists( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "tableExists")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .log();

    Response ret =
      service.tableExists(prefix,namespace,table,realmContext,securityContext);
    LOGGER.debug("Completed execution of tableExists API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Set and/or remove properties on a namespace. The request body specifies a list of properties to remove and a map of key value pairs to update. Properties that are not in the request are not modified or removed by this call. Server implementations are not required to support namespace properties.
   *
   * Response type: {@code UpdateNamespacePropertiesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param updateNamespacePropertiesRequest Required - 
   *
   * @return 200 - JSON data response for a synchronous update properties request.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - Namespace not found
   * @return 406 - Not Acceptable / Unsupported Operation. The server does not support this operation.
   * @return 422 - Unprocessable Entity - A property key was included in both `removals` and `updates`
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/properties")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.updateProperties")
  @Timeout
  public Response updateProperties( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "updateProperties")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("updateNamespacePropertiesRequest", String.valueOf(updateNamespacePropertiesRequest))
      .log();

    Response ret =
      service.updateProperties(prefix,namespace,updateNamespacePropertiesRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updateProperties API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Commit updates to a table.  Commits have two parts, requirements and updates. Requirements are assertions that will be validated before attempting to make and commit changes. For example, &#x60;assert-ref-snapshot-id&#x60; will check that a named ref&#39;s snapshot ID has a certain value. Server implementations are required to fail with a 400 status code if any unknown updates or requirements are received.  Updates are changes to make to table metadata. For example, after asserting that the current main ref is at the expected snapshot, a commit may add a new child snapshot and set the ref to the new snapshot id.  Create table transactions that are started by createTable with &#x60;stage-create&#x60; set to true are committed using this route. Transactions should include all changes to the table, including table initialization, like AddSchemaUpdate and SetCurrentSchemaUpdate. The &#x60;assert-create&#x60; requirement is used to ensure that the table was not created concurrently.
   *
   * Response type: {@code CommitTableResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param table Required - A table name
   * @param commitTableRequest Required - 
   *
   * @return 200 - Response used when a table is successfully updated. The table metadata JSON is returned in the metadata field. The corresponding file location of table metadata must be returned in the metadata-location field. Clients can check whether metadata has changed by comparing metadata locations.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, table to load does not exist
   * @return 409 - Conflict - CommitFailedException, one or more requirements failed. The client may retry.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 500 - An unknown server-side problem occurred; the commit state is unknown.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 502 - A gateway or proxy received an invalid response from the upstream server; the commit state is unknown.
   * @return 504 - A server-side gateway timeout occurred; the commit state is unknown.
   * @return 5XX - A server-side problem that might not be addressable on the client.
   */
  @POST
  @Path("/namespaces/{namespace}/tables/{table}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.updateTable")
  @Timeout
  public Response updateTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("table") String table, CommitTableRequest commitTableRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "updateTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("table", table)
      .addKeyValue("commitTableRequest", String.valueOf(commitTableRequest))
      .log();

    Response ret =
      service.updateTable(prefix,namespace,table,commitTableRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updateTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Check if a view exists within a given namespace. This request does not return a response body.
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param view Required - A view name
   *
   * @return 204 - Success, no content
   * @return 400 - Bad Request
   * @return 401 - Unauthorized
   * @return 404 - Not Found
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @HEAD
  @Path("/namespaces/{namespace}/views/{view}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.CatalogApi.viewExists")
  @Timeout
  public Response viewExists( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("view") String view,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking CatalogApi with params")
      .addKeyValue("operation", "viewExists")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("view", view)
      .log();

    Response ret =
      service.viewExists(prefix,namespace,view,realmContext,securityContext);
    LOGGER.debug("Completed execution of viewExists API with status code {}", ret.getStatus());
    return ret;
  }
}
