package org.apache.polaris.service.catalog.api;

import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.polaris.service.types.TokenType;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * The OAuth2Api API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/catalog/v1/oauth/tokens")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.526548072Z[UTC]", comments = "Generator version: 7.12.0")
public class IcebergRestOAuth2Api  {
  private static final Logger LOGGER = LoggerFactory.getLogger(IcebergRestOAuth2Api.class);

  private final IcebergRestOAuth2ApiService service;

  @Inject
  public IcebergRestOAuth2Api(IcebergRestOAuth2ApiService service) {
    this.service = service;
  }

  /**
   * The &#x60;oauth/tokens&#x60; endpoint is **DEPRECATED for REMOVAL**. It is _not_ recommended to implement this endpoint, unless you are fully aware of the potential security implications. All clients are encouraged to explicitly set the configuration property &#x60;oauth2-server-uri&#x60; to the correct OAuth endpoint. Deprecated since Iceberg (Java) 1.6.0. The endpoint and related types will be removed from this spec in Iceberg (Java) 2.0. See [Security improvements in the Iceberg REST specification](https://github.com/apache/iceberg/issues/10537)  Exchange credentials for a token using the OAuth2 client credentials flow or token exchange.  This endpoint is used for three purposes - 1. To exchange client credentials (client ID and secret) for an access token This uses the client credentials flow. 2. To exchange a client token and an identity token for a more specific access token This uses the token exchange flow. 3. To exchange an access token for one with the same claims and a refreshed expiration period This uses the token exchange flow.  For example, a catalog client may be configured with client credentials from the OAuth2 Authorization flow. This client would exchange its client ID and secret for an access token using the client credentials request with this endpoint (1). Subsequent requests would then use that access token.  Some clients may also handle sessions that have additional user context. These clients would use the token exchange flow to exchange a user token (the \&quot;subject\&quot; token) from the session for a more specific access token for that user, using the catalog&#39;s access token as the \&quot;actor\&quot; token (2). The user ID token is the \&quot;subject\&quot; token and can be any token type allowed by the OAuth2 token exchange flow, including a unsecured JWT token with a sub claim. This request should use the catalog&#39;s bearer token in the \&quot;Authorization\&quot; header.  Clients may also use the token exchange flow to refresh a token that is about to expire by sending a token exchange request (3). The request&#39;s \&quot;subject\&quot; token should be the expiring token. This request should use the subject token in the \&quot;Authorization\&quot; header.
   *
   * Response type: {@code OAuthTokenResponse}.
   * @param authorization  
   * @param grantType  
   * @param scope  
   * @param clientId  Client ID  This can be sent in the request body, but OAuth2 recommends sending it in a Basic Authorization header.
   * @param clientSecret  Client secret  This can be sent in the request body, but OAuth2 recommends sending it in a Basic Authorization header.
   * @param requestedTokenType  
   * @param subjectToken  Subject token for token exchange request
   * @param subjectTokenType  
   * @param actorToken  Actor token for token exchange request
   * @param actorTokenType  
   *
   * @return 200 - OAuth2 token response for client credentials or token exchange
   * @return 400 - OAuth2 error response
   * @return 401 - OAuth2 error response
   * @return 5XX - OAuth2 error response
   */
  @POST
  @Consumes({ "application/x-www-form-urlencoded" })
  @Produces({ "application/json" })
  
  @Timed("polaris.OAuth2Api.getToken")
  @Timeout
  public Response getToken(@HeaderParam("Authorization") String authorization,@FormParam("grant_type") String grantType,@FormParam("scope") String scope,@FormParam("client_id") String clientId,@FormParam("client_secret") String clientSecret,@FormParam("requested_token_type") TokenType requestedTokenType,@FormParam("subject_token") String subjectToken,@FormParam("subject_token_type") TokenType subjectTokenType,@FormParam("actor_token") String actorToken,@FormParam("actor_token_type") TokenType actorTokenType,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking OAuth2Api with params")
      .addKeyValue("operation", "getToken")
      .log();

    Response ret =
      service.getToken(authorization,grantType,scope,clientId,clientSecret,requestedTokenType,subjectToken,subjectTokenType,actorToken,actorTokenType,realmContext,securityContext);
    LOGGER.debug("Completed execution of getToken API with status code {}", ret.getStatus());
    return ret;
  }
}
