package org.apache.polaris.service.catalog.api;



import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.GetApplicablePoliciesResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.service.types.ListPoliciesResponse;
import org.apache.polaris.service.types.LoadPolicyResponse;
import org.apache.polaris.service.types.UpdatePolicyRequest;

import java.util.List;

import java.io.InputStream;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;

import org.apache.polaris.core.context.RealmContext;

/**
 * Service interface for implementations of the PolarisCatalogPolicyApiService. Provides default
 * implemntations for all service methods that return 501 error codes (not implemented).
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * pom.xml file in the module.
 *
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.398743462Z[UTC]", comments = "Generator version: 7.12.0")
public interface PolarisCatalogPolicyApiService {
  default Response attachPolicy(String prefix,String namespace,String policyName,AttachPolicyRequest attachPolicyRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response createPolicy(String prefix,String namespace,CreatePolicyRequest createPolicyRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response detachPolicy(String prefix,String namespace,String policyName,DetachPolicyRequest detachPolicyRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response dropPolicy(String prefix,String namespace,String policyName,Boolean detachAll,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response getApplicablePolicies(String prefix,String pageToken,Integer pageSize,String namespace,String targetName,String policyType,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response listPolicies(String prefix,String namespace,String pageToken,Integer pageSize,String policyType,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response loadPolicy(String prefix,String namespace,String policyName,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response updatePolicy(String prefix,String namespace,String policyName,UpdatePolicyRequest updatePolicyRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
}
